/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.AbstractCommonCheckinAction;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class CommonCheckinFilesAction
extends AbstractCommonCheckinAction {
    @Override
    protected String getActionName(@NotNull VcsContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/openapi/vcs/actions/CommonCheckinFilesAction", "getActionName"));
        }
        String checkinActionName = this.getCheckinActionName(dataContext);
        return this.modifyCheckinActionName(dataContext, checkinActionName);
    }

    private String modifyCheckinActionName(VcsContext dataContext, String checkinActionName) {
        FilePath[] roots = this.getRoots(dataContext);
        if (roots.length == 0) {
            return checkinActionName;
        }
        FilePath first = roots[0];
        if (roots.length == 1) {
            if (first.isDirectory()) {
                return VcsBundle.message((String)"action.name.checkin.directory", (Object[])new Object[]{checkinActionName});
            }
            return VcsBundle.message((String)"action.name.checkin.file", (Object[])new Object[]{checkinActionName});
        }
        if (first.isDirectory()) {
            return VcsBundle.message((String)"action.name.checkin.directories", (Object[])new Object[]{checkinActionName});
        }
        return VcsBundle.message((String)"action.name.checkin.files", (Object[])new Object[]{checkinActionName});
    }

    @Override
    protected String getMnemonicsFreeActionName(VcsContext context) {
        return this.modifyCheckinActionName(context, VcsBundle.message((String)"vcs.command.name.checkin.no.mnemonics", (Object[])new Object[0]));
    }

    @Override
    protected LocalChangeList getInitiallySelectedChangeList(VcsContext context, Project project) {
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        LocalChangeList defaultChangeList = changeListManager.getDefaultChangeList();
        FilePath[] roots = this.getRoots(context);
        LocalChangeList changeList = null;
        for (FilePath root : roots) {
            VirtualFile file = root.getVirtualFile();
            if (file == null) continue;
            Collection<LocalChangeList> lists = CommonCheckinFilesAction.getChangeListsForRoot(changeListManager, root);
            if (lists.contains(defaultChangeList)) {
                return defaultChangeList;
            }
            Iterator<LocalChangeList> it = lists.iterator();
            changeList = it.hasNext() ? it.next() : null;
        }
        return changeList == null ? defaultChangeList : changeList;
    }

    private static Collection<LocalChangeList> getChangeListsForRoot(ChangeListManager changeListManager, FilePath dirPath) {
        Collection changes = changeListManager.getChangesIn(dirPath);
        HashSet changeLists = new HashSet();
        for (Change change : changes) {
            changeLists.add(changeListManager.getChangeList(change));
        }
        return changeLists;
    }

    private String getCheckinActionName(VcsContext dataContext) {
        Project project = dataContext.getProject();
        if (project == null) {
            return VcsBundle.message((String)"vcs.command.name.checkin", (Object[])new Object[0]);
        }
        AbstractVcs vcs = CommonCheckinFilesAction.getCommonVcsFor(this.getRoots(dataContext), project);
        if (vcs == null) {
            return VcsBundle.message((String)"vcs.command.name.checkin", (Object[])new Object[0]);
        }
        CheckinEnvironment checkinEnvironment = vcs.getCheckinEnvironment();
        if (checkinEnvironment == null) {
            return VcsBundle.message((String)"vcs.command.name.checkin", (Object[])new Object[0]);
        }
        return checkinEnvironment.getCheckinOperationName();
    }

    @Override
    protected boolean approximatelyHasRoots(VcsContext dataContext) {
        FilePath[] paths = dataContext.getSelectedFilePaths();
        if (paths.length == 0) {
            return false;
        }
        FileStatusManager fsm = FileStatusManager.getInstance((Project)dataContext.getProject());
        for (FilePath path : paths) {
            FileStatus status;
            VirtualFile file = path.getVirtualFile();
            if (file == null || !this.isApplicableRoot(file, status = fsm.getStatus(file), dataContext)) continue;
            return true;
        }
        return false;
    }

    protected boolean isApplicableRoot(@NotNull VirtualFile file, @NotNull FileStatus status, @NotNull VcsContext dataContext) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/actions/CommonCheckinFilesAction", "isApplicableRoot"));
        }
        if (status == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "com/intellij/openapi/vcs/actions/CommonCheckinFilesAction", "isApplicableRoot"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/openapi/vcs/actions/CommonCheckinFilesAction", "isApplicableRoot"));
        }
        return status != FileStatus.UNKNOWN && status != FileStatus.IGNORED;
    }

    @Override
    @NotNull
    protected FilePath[] getRoots(@NotNull VcsContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/actions/CommonCheckinFilesAction", "getRoots"));
        }
        FilePath[] filePathArray = context.getSelectedFilePaths();
        if (filePathArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/CommonCheckinFilesAction", "getRoots"));
        }
        return filePathArray;
    }

    @Override
    protected boolean filterRootsBeforeAction() {
        return true;
    }
}

