/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffManager;
import com.intellij.openapi.diff.DiffNavigationContext;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DiffTool;
import com.intellij.openapi.diff.FileContent;
import com.intellij.openapi.diff.SimpleDiffRequest;
import com.intellij.openapi.diff.impl.external.BinaryDiffTool;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.BinaryContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.FakeRevision;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.actions.ChangeDiffRequest;
import com.intellij.openapi.vcs.changes.actions.ChangeForDiffConvertor;
import com.intellij.openapi.vcs.changes.actions.DiffRequestPresentable;
import com.intellij.openapi.vcs.changes.actions.ShowDiffUIContext;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BeforeAfter;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowDiffAction
extends AnAction
implements DumbAware {
    private static final String ourText = ActionsBundle.actionText((String)"ChangesView.Diff");

    public ShowDiffAction() {
        super(ourText, ActionsBundle.actionDescription((String)"ChangesView.Diff"), AllIcons.Actions.Diff);
    }

    public void update(AnActionEvent e) {
        Change[] changes = (Change[])e.getData(VcsDataKeys.CHANGES);
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        e.getPresentation().setEnabled(project != null && ShowDiffAction.canShowDiff(changes));
    }

    protected static boolean canShowDiff(Change[] changes) {
        if (changes == null || changes.length == 0) {
            return false;
        }
        return !ChangesUtil.getFilePath((Change)changes[0]).isDirectory() || changes[0].hasOtherLayers();
    }

    public void actionPerformed(AnActionEvent e) {
        final Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        if (ChangeListManager.getInstance((Project)project).isFreezedWithNotification(null)) {
            return;
        }
        final Change[] changes = (Change[])e.getData(VcsDataKeys.CHANGES);
        if (changes == null) {
            return;
        }
        final boolean needsConvertion = ShowDiffAction.checkIfThereAreFakeRevisions(project, changes);
        final List changesInList = (List)e.getData(VcsDataKeys.CHANGES_IN_LIST_KEY);
        Runnable performer = new Runnable(){

            @Override
            public void run() {
                Change[] convertedChanges = needsConvertion ? ShowDiffAction.loadFakeRevisions(project, changes) : changes;
                if (convertedChanges == null || convertedChanges.length == 0) {
                    return;
                }
                ArrayList changesInListCopy = changesInList;
                int index = 0;
                if (convertedChanges.length == 1) {
                    Change selectedChange = convertedChanges[0];
                    LocalChangeList changeList = ((ChangeListManagerImpl)ChangeListManager.getInstance((Project)project)).getIdentityChangeList(selectedChange);
                    if (changeList != null) {
                        if (changesInListCopy == null) {
                            changesInListCopy = new ArrayList(changeList.getChanges());
                            Collections.sort(changesInListCopy, new Comparator<Change>(){

                                @Override
                                public int compare(Change o1, Change o2) {
                                    return ChangesUtil.getFilePath((Change)o1).getName().compareToIgnoreCase(ChangesUtil.getFilePath((Change)o2).getName());
                                }
                            });
                        }
                        convertedChanges = changesInListCopy.toArray(new Change[changesInListCopy.size()]);
                        index = Math.max(0, ContainerUtil.indexOfIdentity(changesInListCopy, (Object)selectedChange));
                    }
                }
                ShowDiffAction.showDiffForChange(convertedChanges, index, project);
            }
        };
        if (needsConvertion) {
            ChangeListManager.getInstance((Project)project).invokeAfterUpdate(performer, InvokeAfterUpdateMode.BACKGROUND_CANCELLABLE, ourText, ModalityState.current());
        } else {
            performer.run();
        }
    }

    public static void showDiffForChange(Change[] changes, int index, Project project) {
        ShowDiffAction.showDiffForChange(changes, index, project, new ShowDiffUIContext(true));
    }

    private static boolean checkIfThereAreFakeRevisions(Project project, Change[] changes) {
        boolean needsConversion = false;
        for (Change change : changes) {
            ContentRevision beforeRevision = change.getBeforeRevision();
            ContentRevision afterRevision = change.getAfterRevision();
            if (beforeRevision instanceof FakeRevision) {
                VcsDirtyScopeManager.getInstance((Project)project).fileDirty(beforeRevision.getFile());
                needsConversion = true;
            }
            if (!(afterRevision instanceof FakeRevision)) continue;
            VcsDirtyScopeManager.getInstance((Project)project).fileDirty(afterRevision.getFile());
            needsConversion = true;
        }
        return needsConversion;
    }

    @Nullable
    private static Change[] loadFakeRevisions(Project project, Change[] changes) {
        ArrayList matchingChanges = new ArrayList();
        for (Change change : changes) {
            matchingChanges.addAll(ChangeListManager.getInstance((Project)project).getChangesIn(ChangesUtil.getFilePath((Change)change)));
        }
        return matchingChanges.toArray(new Change[matchingChanges.size()]);
    }

    public static void showDiffForChange(Iterable<Change> changes, Condition<Change> selectionChecker, Project project, @NotNull ShowDiffUIContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/changes/actions/ShowDiffAction", "showDiffForChange"));
        }
        int newIndex = -1;
        ChangeForDiffConvertor convertor = new ChangeForDiffConvertor(project, true);
        ArrayList changeList = ContainerUtil.newArrayList();
        for (Change change : changes) {
            DiffRequestPresentable presentable;
            if (ShowDiffAction.directoryOrBinary(change) || (presentable = convertor.convert(change)) == null) continue;
            if (newIndex == -1 && selectionChecker.value((Object)change)) {
                newIndex = changeList.size();
            }
            changeList.add(presentable);
        }
        if (changeList.isEmpty()) {
            return;
        }
        if (newIndex < 0) {
            newIndex = 0;
        }
        ShowDiffAction.showDiffImpl(project, changeList, newIndex, context);
    }

    public static void showDiffForChange(Change[] changes, int index, Project project, @NotNull ShowDiffUIContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/changes/actions/ShowDiffAction", "showDiffForChange"));
        }
        final Change selected = index >= 0 ? changes[index] : null;
        ShowDiffAction.showDiffForChange(Arrays.asList(changes), new Condition<Change>(){

            public boolean value(Change change) {
                return selected != null && selected.equals((Object)change);
            }
        }, project, context);
    }

    private static FileContent createBinaryFileContent(Project project, ContentRevision contentRevision, String fileName) throws VcsException, IOException {
        FileContent fileContent;
        if (contentRevision == null) {
            fileContent = FileContent.createFromTempFile((Project)project, (String)fileName, (String)fileName, (byte[])ArrayUtil.EMPTY_BYTE_ARRAY);
        } else {
            byte[] content = ((BinaryContentRevision)contentRevision).getBinaryContent();
            fileContent = FileContent.createFromTempFile((Project)project, (String)contentRevision.getFile().getName(), (String)contentRevision.getFile().getName(), (byte[])(content == null ? ArrayUtil.EMPTY_BYTE_ARRAY : content));
        }
        return fileContent;
    }

    private static SimpleDiffRequest createBinaryDiffRequest(Project project, Change change) throws VcsException {
        FilePath filePath = ChangesUtil.getFilePath((Change)change);
        SimpleDiffRequest request = new SimpleDiffRequest(project, filePath.getPath());
        try {
            request.setContents((DiffContent)ShowDiffAction.createBinaryFileContent(project, change.getBeforeRevision(), filePath.getName()), (DiffContent)ShowDiffAction.createBinaryFileContent(project, change.getAfterRevision(), filePath.getName()));
            return request;
        }
        catch (IOException e) {
            throw new VcsException((Throwable)e);
        }
    }

    public static BeforeAfter<DiffContent> createBinaryDiffContents(Project project, Change change) throws VcsException {
        FilePath filePath = ChangesUtil.getFilePath((Change)change);
        try {
            return new BeforeAfter((Object)ShowDiffAction.createBinaryFileContent(project, change.getBeforeRevision(), filePath.getName()), (Object)ShowDiffAction.createBinaryFileContent(project, change.getAfterRevision(), filePath.getName()));
        }
        catch (IOException e) {
            throw new VcsException((Throwable)e);
        }
    }

    private static void showBinaryDiff(Project project, Change change) {
        try {
            SimpleDiffRequest request = ShowDiffAction.createBinaryDiffRequest(project, change);
            if (DiffManager.getInstance().getDiffTool().canShow((DiffRequest)request)) {
                DiffManager.getInstance().getDiffTool().show((DiffRequest)request);
            }
        }
        catch (VcsException e) {
            Messages.showWarningDialog((String)e.getMessage(), (String)"Show Diff");
        }
    }

    private static boolean isBinaryDiff(Project project, Change[] changes, int index) {
        if (index >= 0 && index < changes.length) {
            Change change = changes[index];
            return ShowDiffAction.isBinaryChangeAndCanShow(project, change);
        }
        return false;
    }

    public static boolean isBinaryChange(Change change) {
        if (change.hasOtherLayers()) {
            return false;
        }
        ContentRevision bRev = change.getBeforeRevision();
        ContentRevision aRev = change.getAfterRevision();
        return !(aRev != null && !(aRev instanceof BinaryContentRevision) || bRev != null && !(bRev instanceof BinaryContentRevision));
    }

    public static boolean isBinaryChangeAndCanShow(Project project, Change change) {
        return ShowDiffAction.isBinaryChange(change) && (change.getAfterRevision() == null || BinaryDiffTool.canShow(project, change.getVirtualFile()));
    }

    public static void showDiffImpl(Project project, @NotNull List<DiffRequestPresentable> changeList, int index, @NotNull ShowDiffUIContext context) {
        DiffRequest simpleRequest;
        if (changeList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeList", "com/intellij/openapi/vcs/changes/actions/ShowDiffAction", "showDiffImpl"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/changes/actions/ShowDiffAction", "showDiffImpl"));
        }
        ChangeDiffRequest request = new ChangeDiffRequest(project, changeList, context.getActionsFactory(), context.isShowFrame());
        DiffTool tool = DiffManager.getInstance().getDiffTool();
        try {
            request.quickCheckHaveStuff();
            simpleRequest = request.init(index);
        }
        catch (VcsException e) {
            Messages.showWarningDialog((String)e.getMessage(), (String)"Show Diff");
            return;
        }
        if (simpleRequest != null) {
            DiffNavigationContext navigationContext = context.getDiffNavigationContext();
            if (navigationContext != null) {
                simpleRequest.passForDataContext(DiffTool.SCROLL_TO_LINE, (Object)navigationContext);
            }
            tool.show(simpleRequest);
        }
    }

    private static boolean directoryOrBinary(Change change) {
        FilePath path = ChangesUtil.getFilePath((Change)change);
        if (path.isDirectory()) {
            return !change.hasOtherLayers();
        }
        return false;
    }

    private static boolean checkNotifyBinaryDiff(Change selectedChange) {
        ContentRevision beforeRevision = selectedChange.getBeforeRevision();
        ContentRevision afterRevision = selectedChange.getAfterRevision();
        if (beforeRevision instanceof BinaryContentRevision && afterRevision instanceof BinaryContentRevision) {
            try {
                byte[] beforeContent = ((BinaryContentRevision)beforeRevision).getBinaryContent();
                byte[] afterContent = ((BinaryContentRevision)afterRevision).getBinaryContent();
                if (Arrays.equals(beforeContent, afterContent)) {
                    Messages.showInfoMessage((String)VcsBundle.message((String)"message.text.binary.versions.are.identical", (Object[])new Object[0]), (String)VcsBundle.message((String)"message.title.diff", (Object[])new Object[0]));
                } else {
                    Messages.showInfoMessage((String)VcsBundle.message((String)"message.text.binary.versions.are.different", (Object[])new Object[0]), (String)VcsBundle.message((String)"message.title.diff", (Object[])new Object[0]));
                }
            }
            catch (VcsException e) {
                Messages.showInfoMessage((String)e.getMessage(), (String)VcsBundle.message((String)"message.title.diff", (Object[])new Object[0]));
            }
            return true;
        }
        return false;
    }
}

