/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.configurable;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsRootChecker;
import com.intellij.openapi.vcs.VcsRootError;
import com.intellij.openapi.vcs.configurable.ModuleVcsListener;
import com.intellij.openapi.vcs.configurable.VcsCommitMessageMarginConfigurable;
import com.intellij.openapi.vcs.configurable.VcsConfigurationsDialog;
import com.intellij.openapi.vcs.configurable.VcsContentAnnotationConfigurable;
import com.intellij.openapi.vcs.configurable.VcsLimitHistoryConfigurable;
import com.intellij.openapi.vcs.configurable.VcsMappingConfigurationDialog;
import com.intellij.openapi.vcs.configurable.VcsUpdateInfoScopeFilterConfigurable;
import com.intellij.openapi.vcs.impl.DefaultVcsRootPolicy;
import com.intellij.openapi.vcs.impl.VcsDescriptor;
import com.intellij.openapi.vcs.roots.VcsRootErrorsFinder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.table.TableView;
import com.intellij.util.UriUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.CompoundBorder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsDirectoryConfigurationPanel
extends JPanel
implements Configurable {
    private final Project myProject;
    private final String myProjectMessage;
    private final ProjectLevelVcsManager myVcsManager;
    private final TableView<VcsDirectoryMapping> myDirectoryMappingTable;
    private final ComboboxWithBrowseButton myVcsComboBox = new ComboboxWithBrowseButton();
    private final List<ModuleVcsListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final MyDirectoryRenderer myDirectoryRenderer;
    private final ColumnInfo<VcsDirectoryMapping, VcsDirectoryMapping> DIRECTORY;
    private final JCheckBox myBaseRevisionTexts;
    private ListTableModel<VcsDirectoryMapping> myModel;
    private final Map<String, VcsDescriptor> myAllVcss;
    private VcsContentAnnotationConfigurable myRecentlyChangedConfigurable;
    private final boolean myIsDisabled;
    private final VcsConfiguration myVcsConfiguration;
    @NotNull
    private final Map<String, VcsRootChecker> myCheckers;
    private JCheckBox myShowVcsRootErrorNotification;
    private JCheckBox myShowChangedRecursively;
    private final VcsLimitHistoryConfigurable myLimitHistory;
    private final VcsUpdateInfoScopeFilterConfigurable myScopeFilterConfig;
    private VcsCommitMessageMarginConfigurable myCommitMessageMarginConfigurable;
    private final ColumnInfo<VcsDirectoryMapping, String> VCS_SETTING = new ColumnInfo<VcsDirectoryMapping, String>(VcsBundle.message((String)"column.name.configure.vcses.vcs", (Object[])new Object[0])){

        public String valueOf(VcsDirectoryMapping object) {
            return object.getVcs();
        }

        public boolean isCellEditable(VcsDirectoryMapping o) {
            return true;
        }

        public void setValue(VcsDirectoryMapping o, String aValue) {
            Collection<AbstractVcs> activeVcses = VcsDirectoryConfigurationPanel.this.getActiveVcses();
            o.setVcs(aValue);
            VcsDirectoryConfigurationPanel.this.checkNotifyListeners(activeVcses);
        }

        public TableCellRenderer getRenderer(final VcsDirectoryMapping p0) {
            return new ColoredTableCellRenderer(){

                protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                    VcsDescriptor vcs;
                    String vcsName = p0.getVcs();
                    String text = vcsName.length() == 0 ? VcsBundle.message((String)"none.vcs.presentation", (Object[])new Object[0]) : ((vcs = (VcsDescriptor)VcsDirectoryConfigurationPanel.this.myAllVcss.get(vcsName)) != null ? vcs.getDisplayName() : VcsBundle.message((String)"unknown.vcs.presentation", (Object[])new Object[]{vcsName}));
                    this.append(text, new SimpleTextAttributes(0, table.getForeground()));
                }
            };
        }

        public TableCellEditor getEditor(VcsDirectoryMapping o) {
            return new AbstractTableCellEditor(){

                public Object getCellEditorValue() {
                    VcsDescriptor selectedVcs = (VcsDescriptor)VcsDirectoryConfigurationPanel.this.myVcsComboBox.getComboBox().getSelectedItem();
                    return selectedVcs == null || selectedVcs.isNone() ? "" : selectedVcs.getName();
                }

                public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                    String vcsName = (String)value;
                    VcsDirectoryConfigurationPanel.this.myVcsComboBox.getComboBox().setSelectedItem(VcsDirectoryConfigurationPanel.this.myAllVcss.get(vcsName));
                    return VcsDirectoryConfigurationPanel.this.myVcsComboBox;
                }
            };
        }

        @Nullable
        public String getMaxStringValue() {
            String maxString = null;
            for (String name : VcsDirectoryConfigurationPanel.this.myAllVcss.keySet()) {
                if (maxString != null && maxString.length() >= name.length()) continue;
                maxString = name;
            }
            return maxString;
        }

        public int getAdditionalWidth() {
            return 10;
        }
    };

    public VcsDirectoryConfigurationPanel(final Project project) {
        this.myProject = project;
        this.myVcsConfiguration = VcsConfiguration.getInstance((Project)this.myProject);
        this.myProjectMessage = XmlStringUtil.wrapInHtml((CharSequence)(StringUtil.escapeXml((String)"<Project>") + " - " + DefaultVcsRootPolicy.getInstance(this.myProject).getProjectConfigurationMessage(this.myProject).replace('\n', ' ')));
        this.myIsDisabled = this.myProject.isDefault();
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        VcsDescriptor[] vcsDescriptors = this.myVcsManager.getAllVcss();
        this.myAllVcss = new HashMap<String, VcsDescriptor>();
        for (VcsDescriptor vcsDescriptor : vcsDescriptors) {
            this.myAllVcss.put(vcsDescriptor.getName(), vcsDescriptor);
        }
        this.myDirectoryMappingTable = new TableView();
        this.myBaseRevisionTexts = new JCheckBox("Store on shelf base revision texts for files under DVCS");
        this.myLimitHistory = new VcsLimitHistoryConfigurable(this.myProject);
        this.myScopeFilterConfig = new VcsUpdateInfoScopeFilterConfigurable(this.myProject, this.myVcsConfiguration);
        this.myCheckers = new HashMap<String, VcsRootChecker>();
        this.updateRootCheckers();
        this.setLayout(new BorderLayout());
        this.add(this.createMainComponent());
        this.myDirectoryRenderer = new MyDirectoryRenderer(this.myProject);
        this.DIRECTORY = new ColumnInfo<VcsDirectoryMapping, VcsDirectoryMapping>(VcsBundle.message((String)"column.info.configure.vcses.directory", (Object[])new Object[0])){

            public VcsDirectoryMapping valueOf(VcsDirectoryMapping mapping) {
                return mapping;
            }

            public TableCellRenderer getRenderer(VcsDirectoryMapping vcsDirectoryMapping) {
                return VcsDirectoryConfigurationPanel.this.myDirectoryRenderer;
            }
        };
        this.initializeModel();
        final JComboBox comboBox = this.myVcsComboBox.getComboBox();
        comboBox.setModel(VcsDirectoryConfigurationPanel.buildVcsWrappersModel(this.myProject));
        comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (VcsDirectoryConfigurationPanel.this.myDirectoryMappingTable.isEditing()) {
                    VcsDirectoryConfigurationPanel.this.myDirectoryMappingTable.stopEditing();
                }
            }
        });
        this.myVcsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VcsDescriptor vcsWrapper = (VcsDescriptor)comboBox.getSelectedItem();
                new VcsConfigurationsDialog(project, comboBox, vcsWrapper).show();
            }
        });
        this.myDirectoryMappingTable.setRowHeight(this.myVcsComboBox.getPreferredSize().height);
        if (this.myIsDisabled) {
            this.myDirectoryMappingTable.setEnabled(false);
        }
    }

    private void updateRootCheckers() {
        VcsRootChecker[] checkers;
        this.myCheckers.clear();
        for (VcsRootChecker checker : checkers = (VcsRootChecker[])Extensions.getExtensions((ExtensionPointName)VcsRootChecker.EXTENSION_POINT_NAME)) {
            VcsKey key = checker.getSupportedVcs();
            AbstractVcs vcs = this.myVcsManager.findVcsByName(key.getName());
            if (vcs == null) continue;
            this.myCheckers.put(key.getName(), checker);
        }
    }

    private void initializeModel() {
        ArrayList<VcsDirectoryMapping> mappings = new ArrayList<VcsDirectoryMapping>();
        for (VcsDirectoryMapping mapping : ProjectLevelVcsManager.getInstance((Project)this.myProject).getDirectoryMappings()) {
            mappings.add(new VcsDirectoryMapping(mapping.getDirectory(), mapping.getVcs(), mapping.getRootSettings()));
        }
        this.myModel = new ListTableModel(new ColumnInfo[]{this.DIRECTORY, this.VCS_SETTING}, mappings, 0);
        this.myDirectoryMappingTable.setModelAndUpdateColumns(this.myModel);
        this.myRecentlyChangedConfigurable.reset();
        this.myLimitHistory.reset();
        this.myScopeFilterConfig.reset();
        this.myBaseRevisionTexts.setSelected(this.myVcsConfiguration.INCLUDE_TEXT_INTO_SHELF);
        this.myShowChangedRecursively.setSelected(this.myVcsConfiguration.SHOW_DIRTY_RECURSIVELY);
        this.myCommitMessageMarginConfigurable.reset();
    }

    public static DefaultComboBoxModel buildVcsWrappersModel(Project project) {
        VcsDescriptor[] vcsDescriptors = ProjectLevelVcsManager.getInstance((Project)project).getAllVcss();
        VcsDescriptor[] result = new VcsDescriptor[vcsDescriptors.length + 1];
        result[0] = VcsDescriptor.createFictive();
        System.arraycopy(vcsDescriptors, 0, result, 1, vcsDescriptors.length);
        return new DefaultComboBoxModel<VcsDescriptor>(result);
    }

    private void addMapping() {
        VcsMappingConfigurationDialog dlg = new VcsMappingConfigurationDialog(this.myProject, VcsBundle.message((String)"directory.mapping.add.title", (Object[])new Object[0]));
        dlg.initProjectMessage();
        dlg.show();
        if (dlg.isOK()) {
            VcsDirectoryMapping mapping = new VcsDirectoryMapping();
            dlg.saveToMapping(mapping);
            this.addMapping(mapping);
        }
    }

    private void addMapping(VcsDirectoryMapping mapping) {
        ArrayList<VcsDirectoryMapping> items = new ArrayList<VcsDirectoryMapping>(this.myModel.getItems());
        items.add(mapping);
        this.myModel.setItems(items);
        this.checkNotifyListeners(this.getActiveVcses());
    }

    private void editMapping() {
        Collection<AbstractVcs> activeVcses = this.getActiveVcses();
        VcsMappingConfigurationDialog dlg = new VcsMappingConfigurationDialog(this.myProject, VcsBundle.message((String)"directory.mapping.remove.title", (Object[])new Object[0]));
        VcsDirectoryMapping mapping = (VcsDirectoryMapping)this.myDirectoryMappingTable.getSelectedObject();
        dlg.setMapping(mapping);
        dlg.show();
        if (dlg.isOK()) {
            dlg.saveToMapping(mapping);
            this.myModel.fireTableDataChanged();
            this.checkNotifyListeners(activeVcses);
        }
    }

    private void removeMapping() {
        Collection<AbstractVcs> activeVcses = this.getActiveVcses();
        ArrayList mappings = new ArrayList(this.myModel.getItems());
        int index = this.myDirectoryMappingTable.getSelectionModel().getMinSelectionIndex();
        Collection selection = this.myDirectoryMappingTable.getSelection();
        mappings.removeAll(selection);
        this.myModel.setItems(mappings);
        if (mappings.size() > 0) {
            if (index >= mappings.size()) {
                index = mappings.size() - 1;
            }
            this.myDirectoryMappingTable.getSelectionModel().setSelectionInterval(index, index);
        }
        this.checkNotifyListeners(activeVcses);
    }

    protected JComponent createMainComponent() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBag gb = new GridBag().setDefaultInsets(new Insets(0, 0, 4, 10)).setDefaultWeightX(1.0).setDefaultFill(2);
        panel.add((Component)this.createMappingsTable(), gb.nextLine().next().fillCell().weighty(1.0));
        panel.add((Component)this.createProjectMappingDescription(), gb.nextLine().next());
        panel.add((Component)this.createErrorList(), gb.nextLine().next());
        panel.add((Component)this.myLimitHistory.createComponent(), gb.nextLine().next());
        panel.add((Component)this.createShowRecursivelyDirtyOption(), gb.nextLine().next());
        panel.add((Component)this.createStoreBaseRevisionOption(), gb.nextLine().next());
        panel.add((Component)this.createShowChangedOption(), gb.nextLine().next());
        panel.add((Component)this.createShowVcsRootErrorNotificationOption(), gb.nextLine().next());
        panel.add((Component)this.myScopeFilterConfig.createComponent(), gb.nextLine().next());
        panel.add((Component)this.createUseCommitMessageRightMargin(), gb.nextLine().next().fillCellHorizontally());
        return panel;
    }

    private JComponent createMappingsTable() {
        JPanel panelForTable = ToolbarDecorator.createDecorator(this.myDirectoryMappingTable, null).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                VcsDirectoryConfigurationPanel.this.addMapping();
                VcsDirectoryConfigurationPanel.this.updateRootCheckers();
            }
        }).setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                VcsDirectoryConfigurationPanel.this.editMapping();
                VcsDirectoryConfigurationPanel.this.updateRootCheckers();
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                VcsDirectoryConfigurationPanel.this.removeMapping();
                VcsDirectoryConfigurationPanel.this.updateRootCheckers();
            }
        }).setAddActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(AnActionEvent e) {
                return !VcsDirectoryConfigurationPanel.this.myIsDisabled;
            }
        }).setEditActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(AnActionEvent e) {
                boolean hasSelection = VcsDirectoryConfigurationPanel.this.myDirectoryMappingTable.getSelectedObject() != null;
                return !VcsDirectoryConfigurationPanel.this.myIsDisabled && hasSelection;
            }
        }).setRemoveActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(AnActionEvent e) {
                boolean hasSelection = VcsDirectoryConfigurationPanel.this.myDirectoryMappingTable.getSelectedObject() != null;
                return !VcsDirectoryConfigurationPanel.this.myIsDisabled && hasSelection;
            }
        }).disableUpDownActions().createPanel();
        panelForTable.setPreferredSize(new Dimension(-1, 200));
        return panelForTable;
    }

    private JComponent createErrorList() {
        int DEFAULT_HEIGHT = 200;
        final Box errorPanel = Box.createVerticalBox();
        final JBScrollPane pane = new JBScrollPane((Component)errorPanel);
        Collection<VcsRootError> myErrors = VcsRootErrorsFinder.getInstance(this.myProject).find();
        for (final VcsRootError root : myErrors) {
            if (!VcsRootError.Type.UNREGISTERED_ROOT.equals((Object)root.getType())) continue;
            final VcsKey vcsKey = root.getVcsKey();
            VcsDescriptor vcsDescriptor = this.myAllVcss.get(vcsKey.getName());
            String displayVcsName = vcsDescriptor.getDisplayName();
            String title = "Unregistered " + displayVcsName + " root: " + FileUtil.toSystemDependentName((String)root.getMapping());
            final VcsRootErrorLabel vcsRootErrorLabel = new VcsRootErrorLabel(title);
            vcsRootErrorLabel.setAddRootLinkHandler(new Runnable(){

                @Override
                public void run() {
                    VcsDirectoryConfigurationPanel.this.addMapping(new VcsDirectoryMapping(root.getMapping(), vcsKey.getName()));
                    errorPanel.remove(vcsRootErrorLabel);
                    if (errorPanel.getComponentCount() == 0) {
                        pane.setVisible(false);
                    }
                    pane.setMinimumSize(new Dimension(-1, VcsDirectoryConfigurationPanel.calcMinHeight(errorPanel, 200)));
                    VcsDirectoryConfigurationPanel.this.validate();
                }
            });
            errorPanel.add(vcsRootErrorLabel);
        }
        if (errorPanel.getComponentCount() == 0) {
            pane.setVisible(false);
        }
        pane.setMinimumSize(new Dimension(-1, VcsDirectoryConfigurationPanel.calcMinHeight(errorPanel, 200)));
        pane.setMaximumSize(new Dimension(-1, 200));
        return pane;
    }

    private static int calcMinHeight(@NotNull JComponent errorPanel, int defaultHeight) {
        if (errorPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorPanel", "com/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel", "calcMinHeight"));
        }
        int height = errorPanel.getPreferredSize().height;
        return height > defaultHeight ? defaultHeight : height;
    }

    private JComponent createProjectMappingDescription() {
        JBLabel label = new JBLabel(this.myProjectMessage);
        label.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        label.setFontColor(UIUtil.FontColor.BRIGHTER);
        label.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 0));
        return label;
    }

    private JComponent createStoreBaseRevisionOption() {
        JBLabel noteLabel = new JBLabel("File texts bigger than 500K are not stored");
        noteLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        noteLabel.setFontColor(UIUtil.FontColor.BRIGHTER);
        noteLabel.setBorder(BorderFactory.createEmptyBorder(2, 25, 5, 0));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.myBaseRevisionTexts, "North");
        panel.add((Component)noteLabel, "South");
        return panel;
    }

    private JComponent createShowChangedOption() {
        this.myRecentlyChangedConfigurable = new VcsContentAnnotationConfigurable(this.myProject);
        JComponent component = this.myRecentlyChangedConfigurable.createComponent();
        assert (component != null);
        return component;
    }

    private JComponent createShowVcsRootErrorNotificationOption() {
        this.myShowVcsRootErrorNotification = new JCheckBox("Notify about VCS root errors", this.myVcsConfiguration.SHOW_VCS_ERROR_NOTIFICATIONS);
        this.myShowVcsRootErrorNotification.setVisible(!this.myCheckers.isEmpty());
        return this.myShowVcsRootErrorNotification;
    }

    private JComponent createUseCommitMessageRightMargin() {
        this.myCommitMessageMarginConfigurable = new VcsCommitMessageMarginConfigurable(this.myProject, this.myVcsConfiguration);
        return this.myCommitMessageMarginConfigurable.createComponent();
    }

    private JComponent createShowRecursivelyDirtyOption() {
        this.myShowChangedRecursively = new JCheckBox("Show directories with changed descendants", this.myVcsConfiguration.SHOW_DIRTY_RECURSIVELY);
        return this.myShowChangedRecursively;
    }

    public void reset() {
        this.initializeModel();
    }

    public void apply() throws ConfigurationException {
        this.myVcsManager.setDirectoryMappings(this.myModel.getItems());
        this.myRecentlyChangedConfigurable.apply();
        this.myLimitHistory.apply();
        this.myScopeFilterConfig.apply();
        this.myVcsConfiguration.INCLUDE_TEXT_INTO_SHELF = this.myBaseRevisionTexts.isSelected();
        this.myVcsConfiguration.SHOW_VCS_ERROR_NOTIFICATIONS = this.myShowVcsRootErrorNotification.isSelected();
        this.myVcsConfiguration.SHOW_DIRTY_RECURSIVELY = this.myShowChangedRecursively.isSelected();
        this.myCommitMessageMarginConfigurable.apply();
        this.initializeModel();
    }

    public boolean isModified() {
        if (this.myRecentlyChangedConfigurable.isModified()) {
            return true;
        }
        if (this.myLimitHistory.isModified()) {
            return true;
        }
        if (this.myScopeFilterConfig.isModified()) {
            return true;
        }
        if (this.myVcsConfiguration.INCLUDE_TEXT_INTO_SHELF != this.myBaseRevisionTexts.isSelected()) {
            return true;
        }
        if (this.myVcsConfiguration.SHOW_VCS_ERROR_NOTIFICATIONS != this.myShowVcsRootErrorNotification.isSelected()) {
            return true;
        }
        if (this.myVcsConfiguration.SHOW_DIRTY_RECURSIVELY != this.myShowChangedRecursively.isSelected()) {
            return true;
        }
        if (this.myCommitMessageMarginConfigurable.isModified()) {
            return true;
        }
        return !((Object)this.myModel.getItems()).equals(this.myVcsManager.getDirectoryMappings());
    }

    public void addVcsListener(ModuleVcsListener moduleVcsListener) {
        this.myListeners.add(moduleVcsListener);
    }

    public void removeVcsListener(ModuleVcsListener moduleVcsListener) {
        this.myListeners.remove(moduleVcsListener);
    }

    private void checkNotifyListeners(Collection<AbstractVcs> oldVcses) {
        Collection<AbstractVcs> vcses = this.getActiveVcses();
        if (!((Object)vcses).equals(oldVcses)) {
            for (ModuleVcsListener listener : this.myListeners) {
                listener.activeVcsSetChanged(vcses);
            }
        }
    }

    public Collection<AbstractVcs> getActiveVcses() {
        HashSet<AbstractVcs> vcses = new HashSet<AbstractVcs>();
        for (VcsDirectoryMapping mapping : this.myModel.getItems()) {
            if (mapping.getVcs().length() <= 0) continue;
            vcses.add(this.myVcsManager.findVcsByName(mapping.getVcs()));
        }
        return vcses;
    }

    @Nls
    public String getDisplayName() {
        return "Mappings";
    }

    public String getHelpTopic() {
        return null;
    }

    public JComponent createComponent() {
        return this;
    }

    public void disposeUIResources() {
        this.myLimitHistory.disposeUIResources();
        this.myScopeFilterConfig.disposeUIResources();
    }

    private static class VcsRootErrorLabel
    extends JPanel {
        private final LinkLabel myAddLabel;

        VcsRootErrorLabel(String title) {
            super(new BorderLayout(10, 4));
            CompoundBorder outsideBorder = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(5, 0, 5, 0, UIUtil.getPanelBackground()), BorderFactory.createLineBorder(UIUtil.getPanelBackground().darker()));
            this.setBorder(BorderFactory.createCompoundBorder(outsideBorder, BorderFactory.createEmptyBorder(4, 10, 4, 10)));
            this.setOpaque(true);
            this.setBackground(new Color(255, 186, 192));
            JBLabel label = new JBLabel(title);
            if (UIUtil.isUnderDarcula()) {
                label.setForeground(UIUtil.getPanelBackground());
            }
            this.myAddLabel = new LinkLabel("Add root", null);
            this.myAddLabel.setOpaque(false);
            JPanel actionsPanel = new JPanel(new BorderLayout(10, 4));
            actionsPanel.setOpaque(false);
            actionsPanel.add((Component)this.myAddLabel, "Center");
            this.add((Component)label, "Center");
            this.add((Component)actionsPanel, "East");
        }

        void setAddRootLinkHandler(final Runnable handler) {
            this.myAddLabel.setListener(new LinkListener(){

                public void linkSelected(LinkLabel aSource, Object aLinkData) {
                    handler.run();
                }
            }, null);
        }
    }

    private class MyDirectoryRenderer
    extends ColoredTableCellRenderer {
        private final Project myProject;

        public MyDirectoryRenderer(Project project) {
            this.myProject = project;
        }

        protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
            if (value instanceof VcsDirectoryMapping) {
                VcsDirectoryMapping mapping = (VcsDirectoryMapping)value;
                if (this.mappingIsError(mapping)) {
                    this.setForeground(Color.RED);
                }
                if (mapping.isDefaultMapping()) {
                    this.append("<Project>");
                    return;
                }
                String directory = mapping.getDirectory();
                VirtualFile baseDir = this.myProject.getBaseDir();
                if (baseDir != null) {
                    File directoryFile = new File(StringUtil.trimEnd((String)UriUtil.trimTrailingSlashes(directory), (String)"\\") + "/");
                    File ioBase = new File(baseDir.getPath());
                    if (directoryFile.isAbsolute() && !FileUtil.isAncestor((File)ioBase, (File)directoryFile, (boolean)false)) {
                        this.append(new File(directory).getPath());
                        return;
                    }
                    String relativePath = FileUtil.getRelativePath((File)ioBase, (File)directoryFile);
                    if (".".equals(relativePath) || relativePath == null) {
                        this.append(ioBase.getPath());
                    } else {
                        this.append(relativePath);
                        this.append(" (" + ioBase + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    }
                }
            }
        }

        private boolean mappingIsError(VcsDirectoryMapping mapping) {
            String vcs = mapping.getVcs();
            VcsRootChecker checker = (VcsRootChecker)VcsDirectoryConfigurationPanel.this.myCheckers.get(vcs);
            return checker != null && (mapping.isDefaultMapping() ? !checker.isRoot(this.myProject.getBasePath()) : !checker.isRoot(mapping.getDirectory()));
        }
    }
}

