/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.roots;

import com.intellij.idea.ActionsBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.VcsRootError;
import com.intellij.openapi.vcs.roots.VcsRootErrorsFinder;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsRootProblemNotifier {
    @NotNull
    private final Project myProject;
    @NotNull
    private final VcsConfiguration mySettings;
    @NotNull
    private final Set<VcsRootError> myReportedUnregisteredRoots;
    @Nullable
    private Notification myNotification;
    @NotNull
    private final Object NOTIFICATION_LOCK;

    public static VcsRootProblemNotifier getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/roots/VcsRootProblemNotifier", "getInstance"));
        }
        return new VcsRootProblemNotifier(project);
    }

    private VcsRootProblemNotifier(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/roots/VcsRootProblemNotifier", "<init>"));
        }
        this.myReportedUnregisteredRoots = ContainerUtil.newHashSet();
        this.NOTIFICATION_LOCK = new Object();
        this.myProject = project;
        this.mySettings = VcsConfiguration.getInstance((Project)this.myProject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rescanAndNotifyIfNeeded() {
        if (!this.mySettings.SHOW_VCS_ERROR_NOTIFICATIONS) {
            return;
        }
        Collection<VcsRootError> errors = this.scan();
        if (errors.isEmpty()) {
            Object object = this.NOTIFICATION_LOCK;
            synchronized (object) {
                this.expireNotification();
            }
            return;
        }
        Collection<VcsRootError> unregisteredRoots = VcsRootProblemNotifier.getUnregisteredRoots(errors);
        Collection<VcsRootError> invalidRoots = VcsRootProblemNotifier.getInvalidRoots(errors);
        String title = VcsRootProblemNotifier.makeTitle(unregisteredRoots, invalidRoots);
        String description = VcsRootProblemNotifier.makeDescription(unregisteredRoots, invalidRoots);
        if (this.myReportedUnregisteredRoots.containsAll(unregisteredRoots) && invalidRoots.isEmpty()) {
            return;
        }
        this.myReportedUnregisteredRoots.addAll(unregisteredRoots);
        Object object = this.NOTIFICATION_LOCK;
        synchronized (object) {
            this.expireNotification();
            MyNotificationListener listener = new MyNotificationListener(this.myProject, this.mySettings);
            VcsNotifier notifier = VcsNotifier.getInstance(this.myProject);
            this.myNotification = invalidRoots.isEmpty() ? notifier.notifyMinorInfo(title, description, listener) : notifier.notifyError(title, description, listener);
        }
    }

    private void expireNotification() {
        if (this.myNotification != null) {
            final Notification notification = this.myNotification;
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    notification.expire();
                }
            });
            this.myNotification = null;
        }
    }

    @NotNull
    private Collection<VcsRootError> scan() {
        Collection<VcsRootError> collection = new VcsRootErrorsFinder(this.myProject).find();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/roots/VcsRootProblemNotifier", "scan"));
        }
        return collection;
    }

    @NotNull
    private static String makeDescription(@NotNull Collection<VcsRootError> unregisteredRoots, @NotNull Collection<VcsRootError> invalidRoots) {
        if (unregisteredRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unregisteredRoots", "com/intellij/openapi/vcs/roots/VcsRootProblemNotifier", "makeDescription"));
        }
        if (invalidRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "invalidRoots", "com/intellij/openapi/vcs/roots/VcsRootProblemNotifier", "makeDescription"));
        }
        Function<VcsRootError, String> rootToDisplayableString = new Function<VcsRootError, String>(){

            public String fun(VcsRootError rootError) {
                if (rootError.getMapping().equals("<Project>")) {
                    return StringUtil.escapeXml((String)rootError.getMapping());
                }
                return FileUtil.toSystemDependentName((String)rootError.getMapping());
            }
        };
        StringBuilder description = new StringBuilder();
        if (!invalidRoots.isEmpty()) {
            if (invalidRoots.size() == 1) {
                VcsRootError rootError = invalidRoots.iterator().next();
                description.append("The directory " + (String)rootToDisplayableString.fun((Object)rootError) + " is registered as a " + rootError.getVcsKey().getName() + " root, " + "but no " + rootError.getVcsKey().getName() + " repositories were found there.");
            } else {
                description.append("The following directories are registered as Vcs roots, but they are not: <br/>" + StringUtil.join(invalidRoots, (Function)rootToDisplayableString, (String)", "));
            }
            description.append("<br/>");
        }
        if (!unregisteredRoots.isEmpty()) {
            if (unregisteredRoots.size() == 1) {
                VcsRootError unregisteredRoot = unregisteredRoots.iterator().next();
                description.append("The directory " + (String)rootToDisplayableString.fun((Object)unregisteredRoot) + " is under " + unregisteredRoot.getVcsKey().getName() + ", " + "but is not registered in the Settings.");
            } else {
                description.append("The following directories are roots of Vcs repositories, but they are not registered in the Settings: <br/>" + StringUtil.join(unregisteredRoots, (Function)rootToDisplayableString, (String)", "));
            }
            description.append("<br/>");
        }
        description.append("<a href='configure'>Configure</a>&nbsp;&nbsp;<a href='ignore'>Ignore VCS root errors</a>");
        String string = description.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/roots/VcsRootProblemNotifier", "makeDescription"));
        }
        return string;
    }

    @NotNull
    private static String makeTitle(@NotNull Collection<VcsRootError> unregisteredRoots, @NotNull Collection<VcsRootError> invalidRoots) {
        if (unregisteredRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unregisteredRoots", "com/intellij/openapi/vcs/roots/VcsRootProblemNotifier", "makeTitle"));
        }
        if (invalidRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "invalidRoots", "com/intellij/openapi/vcs/roots/VcsRootProblemNotifier", "makeTitle"));
        }
        String title = unregisteredRoots.isEmpty() ? "Invalid Vcs root " + StringUtil.pluralize((String)"mapping", (int)invalidRoots.size()) : (invalidRoots.isEmpty() ? "Unregistered Vcs " + StringUtil.pluralize((String)"root", (int)unregisteredRoots.size()) + " detected" : "Vcs root configuration problems");
        String string = title;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/roots/VcsRootProblemNotifier", "makeTitle"));
        }
        return string;
    }

    @NotNull
    private static Collection<VcsRootError> getUnregisteredRoots(@NotNull Collection<VcsRootError> errors) {
        if (errors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "com/intellij/openapi/vcs/roots/VcsRootProblemNotifier", "getUnregisteredRoots"));
        }
        Collection<VcsRootError> collection = VcsRootProblemNotifier.filterErrorsByType(errors, VcsRootError.Type.UNREGISTERED_ROOT);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/roots/VcsRootProblemNotifier", "getUnregisteredRoots"));
        }
        return collection;
    }

    @NotNull
    private static Collection<VcsRootError> getInvalidRoots(@NotNull Collection<VcsRootError> errors) {
        if (errors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "com/intellij/openapi/vcs/roots/VcsRootProblemNotifier", "getInvalidRoots"));
        }
        Collection<VcsRootError> collection = VcsRootProblemNotifier.filterErrorsByType(errors, VcsRootError.Type.EXTRA_MAPPING);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/roots/VcsRootProblemNotifier", "getInvalidRoots"));
        }
        return collection;
    }

    @NotNull
    private static Collection<VcsRootError> filterErrorsByType(@NotNull Collection<VcsRootError> errors, @NotNull VcsRootError.Type type) {
        if (errors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "com/intellij/openapi/vcs/roots/VcsRootProblemNotifier", "filterErrorsByType"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/vcs/roots/VcsRootProblemNotifier", "filterErrorsByType"));
        }
        ArrayList<VcsRootError> roots = new ArrayList<VcsRootError>();
        for (VcsRootError error : errors) {
            if (error.getType() != type) continue;
            roots.add(error);
        }
        ArrayList<VcsRootError> arrayList = roots;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/roots/VcsRootProblemNotifier", "filterErrorsByType"));
        }
        return arrayList;
    }

    private static class MyNotificationListener
    implements NotificationListener {
        @NotNull
        private final Project myProject;
        @NotNull
        private final VcsConfiguration mySettings;

        private MyNotificationListener(@NotNull Project project, @NotNull VcsConfiguration settings) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/roots/VcsRootProblemNotifier$MyNotificationListener", "<init>"));
            }
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/openapi/vcs/roots/VcsRootProblemNotifier$MyNotificationListener", "<init>"));
            }
            this.myProject = project;
            this.mySettings = settings;
        }

        public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
            if (notification == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/openapi/vcs/roots/VcsRootProblemNotifier$MyNotificationListener", "hyperlinkUpdate"));
            }
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vcs/roots/VcsRootProblemNotifier$MyNotificationListener", "hyperlinkUpdate"));
            }
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                if (event.getDescription().equals("configure") && !this.myProject.isDisposed()) {
                    ShowSettingsUtil.getInstance().showSettingsDialog(this.myProject, ActionsBundle.message((String)"group.VcsGroup.text", (Object[])new Object[0]));
                    Collection errorsAfterPossibleFix = VcsRootProblemNotifier.getInstance(this.myProject).scan();
                    if (errorsAfterPossibleFix.isEmpty() && !notification.isExpired()) {
                        notification.expire();
                    }
                } else if (event.getDescription().equals("ignore")) {
                    this.mySettings.SHOW_VCS_ERROR_NOTIFICATIONS = false;
                    notification.expire();
                }
            }
        }
    }
}

