/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.http;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsBundle;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.RemoteContentProvider;
import com.intellij.openapi.vfs.impl.http.RemoteFileUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.Url;
import com.intellij.util.io.UrlConnectionUtil;
import com.intellij.util.net.ssl.CertificateManager;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.io.Responses;

public class DefaultRemoteContentProvider
extends RemoteContentProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.impl.http.DefaultRemoteContentProvider");
    private static final int CONNECT_TIMEOUT = 60000;
    private static final int READ_TIMEOUT = 60000;

    @Override
    public boolean canProvideContent(@NotNull Url url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/vfs/impl/http/DefaultRemoteContentProvider", "canProvideContent"));
        }
        return true;
    }

    @Override
    public void saveContent(final @NotNull Url url, final @NotNull File file, final @NotNull RemoteContentProvider.DownloadingCallback callback) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/vfs/impl/http/DefaultRemoteContentProvider", "saveContent"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/http/DefaultRemoteContentProvider", "saveContent"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/openapi/vfs/impl/http/DefaultRemoteContentProvider", "saveContent"));
        }
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                DefaultRemoteContentProvider.downloadContent(url, file, callback);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void downloadContent(@NotNull Url url, File file, RemoteContentProvider.DownloadingCallback callback) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/vfs/impl/http/DefaultRemoteContentProvider", "downloadContent"));
        }
        LOG.debug("Downloading started: " + url);
        InputStream input = null;
        OutputStream output = null;
        try {
            int len;
            FileType fileTypeByFileName;
            FileType fileType;
            String presentableUrl = StringUtil.trimMiddle((String)url.trimParameters().toDecodedForm(), (int)40);
            callback.setProgressText(VfsBundle.message((String)"download.progress.connecting", (Object[])new Object[]{presentableUrl}), true);
            HttpURLConnection connection = (HttpURLConnection)new URL(url.toExternalForm()).openConnection();
            connection.setRequestProperty("User-Agent", Responses.getServerHeaderValue());
            connection.setConnectTimeout(60000);
            connection.setReadTimeout(60000);
            if (connection instanceof HttpsURLConnection) {
                try {
                    HttpsURLConnection httpsConnection = (HttpsURLConnection)connection;
                    httpsConnection.setHostnameVerifier(new HostnameVerifier(){

                        @Override
                        public boolean verify(String hostname, SSLSession session) {
                            return true;
                        }
                    });
                    httpsConnection.setSSLSocketFactory(CertificateManager.getInstance().getSslContext().getSocketFactory());
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e);
                }
            }
            input = UrlConnectionUtil.getConnectionInputStreamWithException(connection, (ProgressIndicator)new EmptyProgressIndicator());
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                throw new IOException(IdeBundle.message((String)"error.connection.failed.with.http.code.N", (Object[])new Object[]{responseCode}));
            }
            int size = connection.getContentLength();
            output = new BufferedOutputStream(new FileOutputStream(file));
            callback.setProgressText(VfsBundle.message((String)"download.progress.downloading", (Object[])new Object[]{presentableUrl}), size == -1);
            if (size != -1) {
                callback.setProgressFraction(0.0);
            }
            if ((fileType = RemoteFileUtil.getFileType(connection.getContentType())) == FileTypes.PLAIN_TEXT && (fileTypeByFileName = FileTypeRegistry.getInstance().getFileTypeByFileName(PathUtilRt.getFileName((String)url.getPath()))) != FileTypes.UNKNOWN) {
                fileType = fileTypeByFileName;
            }
            byte[] buf = new byte[1024];
            int count = 0;
            while ((len = input.read(buf)) > 0) {
                if (callback.isCancelled()) {
                    return;
                }
                count += len;
                if (size > 0) {
                    callback.setProgressFraction((double)count / (double)size);
                }
                output.write(buf, 0, len);
            }
            output.close();
            output = null;
            LOG.debug("Downloading finished, " + size + " bytes downloaded");
            callback.finished(fileType);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            callback.errorOccurred(VfsBundle.message((String)"cannot.load.remote.file", (Object[])new Object[]{url, e.getMessage()}), false);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                }
            }
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                }
            }
        }
    }

    @Override
    public boolean isUpToDate(@NotNull Url url, @NotNull VirtualFile local) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/vfs/impl/http/DefaultRemoteContentProvider", "isUpToDate"));
        }
        if (local == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "local", "com/intellij/openapi/vfs/impl/http/DefaultRemoteContentProvider", "isUpToDate"));
        }
        return false;
    }
}

