/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.xml.XmlAttributeImpl;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.impl.XmlAttributeDescriptorEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlAttributeReference
implements PsiReference {
    private final NullableLazyValue<XmlAttributeDescriptor> myDescriptor = new NullableLazyValue<XmlAttributeDescriptor>(){

        protected XmlAttributeDescriptor compute() {
            return XmlAttributeReference.this.myAttribute.getDescriptor();
        }
    };
    private final XmlAttributeImpl myAttribute;

    public XmlAttributeReference(XmlAttributeImpl attribute) {
        this.myAttribute = attribute;
    }

    public XmlAttribute getElement() {
        return this.myAttribute;
    }

    public TextRange getRangeInElement() {
        int nsLen;
        int parentOffset = this.myAttribute.getNameElement().getStartOffsetInParent();
        return new TextRange(parentOffset + (nsLen += (nsLen = this.myAttribute.getNamespacePrefix().length()) > 0 && !this.myAttribute.getRealLocalName().isEmpty() ? 1 : -nsLen), parentOffset + this.myAttribute.getNameElement().getTextLength());
    }

    public PsiElement resolve() {
        XmlAttributeDescriptor descriptor = this.getDescriptor();
        return descriptor != null ? descriptor.getDeclaration() : null;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myAttribute.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/xml/XmlAttributeReference", "getCanonicalText"));
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        XmlAttributeDescriptorEx xmlAttributeDescriptorEx;
        String s;
        String newName = newElementName;
        if (this.getDescriptor() instanceof XmlAttributeDescriptorEx && (s = (xmlAttributeDescriptorEx = (XmlAttributeDescriptorEx)this.getDescriptor()).handleTargetRename(newElementName)) != null) {
            String prefix = this.myAttribute.getNamespacePrefix();
            newName = StringUtil.isEmpty((String)prefix) ? s : prefix + ":" + s;
        }
        return this.myAttribute.setName(newName);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        PsiMetaOwner owner;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/xml/XmlAttributeReference", "bindToElement"));
        }
        if (element instanceof PsiMetaOwner && (owner = (PsiMetaOwner)element).getMetaData() instanceof XmlElementDescriptor) {
            this.myAttribute.setName(owner.getMetaData().getName());
        }
        throw new IncorrectOperationException("Cant bind to not a xml element definition!");
    }

    public boolean isReferenceTo(PsiElement element) {
        return this.myAttribute.getManager().areElementsEquivalent(element, this.resolve());
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/xml/XmlAttributeReference", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean isSoft() {
        return this.getDescriptor() == null;
    }

    @Nullable
    private XmlAttributeDescriptor getDescriptor() {
        return (XmlAttributeDescriptor)this.myDescriptor.getValue();
    }
}

