/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceField;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduce.inplace.AbstractInplaceIntroducer;
import com.intellij.refactoring.introduceField.BaseExpressionToFieldHandler;
import com.intellij.refactoring.introduceField.ElementToWorkOn;
import com.intellij.refactoring.introduceField.InplaceIntroduceFieldPopup;
import com.intellij.refactoring.introduceField.IntroduceFieldDialog;
import com.intellij.refactoring.introduceField.LocalToFieldHandler;
import com.intellij.refactoring.introduceParameter.AbstractJavaInplaceIntroducer;
import com.intellij.refactoring.ui.TypeSelectorManagerImpl;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.occurrences.ExpressionOccurrenceManager;
import com.intellij.refactoring.util.occurrences.NotInSuperCallOccurrenceFilter;
import com.intellij.refactoring.util.occurrences.NotInThisCallFilter;
import com.intellij.refactoring.util.occurrences.OccurrenceFilter;
import com.intellij.refactoring.util.occurrences.OccurrenceManager;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class IntroduceFieldHandler
extends BaseExpressionToFieldHandler {
    public static final String REFACTORING_NAME = RefactoringBundle.message((String)"introduce.field.title");
    private static final MyOccurrenceFilter MY_OCCURRENCE_FILTER = new MyOccurrenceFilter();
    private InplaceIntroduceFieldPopup myInplaceIntroduceFieldPopup;

    public IntroduceFieldHandler() {
        super(false);
    }

    @Override
    protected String getRefactoringName() {
        return REFACTORING_NAME;
    }

    @Override
    protected boolean validClass(PsiClass parentClass, Editor editor) {
        if (parentClass.isInterface()) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"cannot.introduce.field.in.interface"));
            CommonRefactoringUtil.showErrorHint((Project)parentClass.getProject(), (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)this.getHelpID());
            return false;
        }
        return true;
    }

    @Override
    protected String getHelpID() {
        return "refactoring.introduceField";
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/introduceField/IntroduceFieldHandler", "invoke"));
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)file)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        ElementToWorkOn.processElementToWorkOn(editor, file, REFACTORING_NAME, "refactoring.introduceField", project, this.getElementProcessor(project, editor));
    }

    @Override
    protected BaseExpressionToFieldHandler.Settings showRefactoringDialog(Project project, Editor editor, PsiClass parentClass, PsiExpression expr, PsiType type, PsiExpression[] occurrences, PsiElement anchorElement, PsiElement anchorElementIfAll) {
        boolean allowInitInMethodIfAll;
        PsiElement ref;
        AbstractInplaceIntroducer activeIntroducer = AbstractInplaceIntroducer.getActiveIntroducer(editor);
        PsiLocalVariable localVariable = null;
        if (anchorElement instanceof PsiLocalVariable) {
            localVariable = (PsiLocalVariable)anchorElement;
        } else if (expr instanceof PsiReferenceExpression && (ref = ((PsiReferenceExpression)expr).resolve()) instanceof PsiLocalVariable) {
            localVariable = (PsiLocalVariable)ref;
        }
        String enteredName = null;
        boolean replaceAll = false;
        if (activeIntroducer != null) {
            activeIntroducer.stopIntroduce(editor);
            expr = (PsiExpression)activeIntroducer.getExpr();
            localVariable = (PsiLocalVariable)activeIntroducer.getLocalVariable();
            occurrences = (PsiExpression[])activeIntroducer.getOccurrences();
            enteredName = activeIntroducer.getInputName();
            replaceAll = activeIntroducer.isReplaceAllOccurrences();
            type = ((AbstractJavaInplaceIntroducer)activeIntroducer).getType();
            IntroduceFieldDialog.ourLastInitializerPlace = ((InplaceIntroduceFieldPopup)activeIntroducer).getInitializerPlace();
        }
        PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)(expr != null ? expr : anchorElement), PsiMethod.class);
        PsiModifierListOwner staticParentElement = PsiUtil.getEnclosingStaticElement((PsiElement)IntroduceFieldHandler.getElement(expr, anchorElement), (PsiClass)parentClass);
        boolean declareStatic = staticParentElement != null;
        boolean isInSuperOrThis = false;
        if (!declareStatic) {
            for (int i = 0; !declareStatic && i < occurrences.length; ++i) {
                PsiExpression occurrence = occurrences[i];
                declareStatic = isInSuperOrThis = IntroduceFieldHandler.isInSuperOrThis(occurrence);
            }
        }
        int occurrencesNumber = occurrences.length;
        boolean currentMethodConstructor = containingMethod != null && containingMethod.isConstructor();
        boolean allowInitInMethod = !(currentMethodConstructor && isInSuperOrThis || !(anchorElement instanceof PsiLocalVariable) && !(anchorElement instanceof PsiStatement));
        boolean bl = allowInitInMethodIfAll = (!currentMethodConstructor || !isInSuperOrThis) && anchorElementIfAll instanceof PsiStatement;
        if (editor != null && editor.getSettings().isVariableInplaceRenameEnabled() && (expr == null || expr.isPhysical()) && activeIntroducer == null) {
            this.myInplaceIntroduceFieldPopup = new InplaceIntroduceFieldPopup(localVariable, parentClass, declareStatic, currentMethodConstructor, occurrences, expr, new TypeSelectorManagerImpl(project, type, containingMethod, expr, occurrences), editor, allowInitInMethod, allowInitInMethodIfAll, anchorElement, anchorElementIfAll, expr != null ? this.createOccurrenceManager(expr, parentClass) : null, project);
            if (this.myInplaceIntroduceFieldPopup.startInplaceIntroduceTemplate()) {
                return null;
            }
        }
        IntroduceFieldDialog dialog = new IntroduceFieldDialog(project, parentClass, expr, localVariable, currentMethodConstructor, localVariable != null, declareStatic, occurrences, allowInitInMethod, allowInitInMethodIfAll, new TypeSelectorManagerImpl(project, type, containingMethod, expr, occurrences), enteredName);
        dialog.setReplaceAllOccurrences(replaceAll);
        dialog.show();
        if (!dialog.isOK()) {
            if (occurrencesNumber > 1) {
                WindowManager.getInstance().getStatusBar(project).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
            }
            return null;
        }
        if (!dialog.isDeleteVariable()) {
            localVariable = null;
        }
        return new BaseExpressionToFieldHandler.Settings(dialog.getEnteredName(), expr, occurrences, dialog.isReplaceAllOccurrences(), declareStatic, dialog.isDeclareFinal(), dialog.getInitializerPlace(), dialog.getFieldVisibility(), localVariable, dialog.getFieldType(), localVariable != null, (BaseExpressionToFieldHandler.TargetDestination)null, false, false);
    }

    @Override
    protected boolean accept(ElementToWorkOn elementToWorkOn) {
        return true;
    }

    private static PsiElement getElement(PsiExpression expr, PsiElement anchorElement) {
        PsiElement element = null;
        if (expr != null && (element = (PsiElement)expr.getUserData(ElementToWorkOn.PARENT)) == null) {
            element = expr;
        }
        if (element == null) {
            element = anchorElement;
        }
        return element;
    }

    @Override
    public AbstractInplaceIntroducer getInplaceIntroducer() {
        return this.myInplaceIntroduceFieldPopup;
    }

    private static boolean isInSuperOrThis(PsiExpression occurrence) {
        return !NotInSuperCallOccurrenceFilter.INSTANCE.isOK(occurrence) || !NotInThisCallFilter.INSTANCE.isOK(occurrence);
    }

    @Override
    protected OccurrenceManager createOccurrenceManager(PsiExpression selectedExpr, PsiClass parentClass) {
        MyOccurrenceFilter occurrenceFilter = IntroduceFieldHandler.isInSuperOrThis(selectedExpr) ? null : MY_OCCURRENCE_FILTER;
        return new ExpressionOccurrenceManager(selectedExpr, (PsiElement)parentClass, occurrenceFilter, true);
    }

    @Override
    protected boolean invokeImpl(final Project project, PsiLocalVariable localVariable, final Editor editor) {
        PsiElement parent = localVariable.getParent();
        if (!(parent instanceof PsiDeclarationStatement)) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.local.or.expression.name"));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)this.getHelpID());
            return false;
        }
        LocalToFieldHandler localToFieldHandler = new LocalToFieldHandler(project, false){

            @Override
            protected BaseExpressionToFieldHandler.Settings showRefactoringDialog(PsiClass aClass, PsiLocalVariable local, PsiExpression[] occurences, boolean isStatic) {
                PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)local, PsiStatement.class);
                return IntroduceFieldHandler.this.showRefactoringDialog(project, editor, aClass, local.getInitializer(), local.getType(), occurences, (PsiElement)local, (PsiElement)statement);
            }

            @Override
            protected int getChosenClassIndex(List<PsiClass> classes) {
                return IntroduceFieldHandler.this.getChosenClassIndex(classes);
            }
        };
        return localToFieldHandler.convertLocalToField(localVariable, editor);
    }

    protected int getChosenClassIndex(List<PsiClass> classes) {
        return classes.size() - 1;
    }

    private static class MyOccurrenceFilter
    implements OccurrenceFilter {
        private MyOccurrenceFilter() {
        }

        @Override
        public boolean isOK(PsiExpression occurrence) {
            return !IntroduceFieldHandler.isInSuperOrThis(occurrence);
        }
    }
}

