/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.NonEmptyInputValidator;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceConfiguration;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.SearchConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigurationManager {
    @NonNls
    static final String SEARCH_TAG_NAME = "searchConfiguration";
    @NonNls
    static final String REPLACE_TAG_NAME = "replaceConfiguration";
    @NonNls
    private static final String SAVE_HISTORY_ATTR_NAME = "history";
    private List<Configuration> configurations;
    private LinkedList<Configuration> historyConfigurations;

    public void addHistoryConfigurationToFront(Configuration configuration) {
        if (this.historyConfigurations == null) {
            this.historyConfigurations = new LinkedList();
        }
        if (this.historyConfigurations.indexOf(configuration) == -1) {
            this.historyConfigurations.addFirst(configuration);
        }
    }

    public void removeHistoryConfiguration(Configuration configuration) {
        if (this.historyConfigurations != null) {
            this.historyConfigurations.remove(configuration);
        }
    }

    public void addConfiguration(Configuration configuration) {
        if (this.configurations == null) {
            this.configurations = new ArrayList<Configuration>();
        }
        if (this.configurations.indexOf(configuration) == -1) {
            this.configurations.add(configuration);
        }
    }

    public void removeConfiguration(Configuration configuration) {
        if (this.configurations != null) {
            this.configurations.remove(configuration);
        }
    }

    public void saveConfigurations(Element element) {
        ConfigurationManager.writeConfigurations(element, this.configurations, this.historyConfigurations);
    }

    public static void writeConfigurations(Element element, Collection<Configuration> configurations, Collection<Configuration> historyConfigurations) {
        if (configurations != null) {
            for (Configuration configuration : configurations) {
                ConfigurationManager.saveConfiguration(element, configuration);
            }
        }
        if (historyConfigurations != null) {
            for (Configuration historyConfiguration : historyConfigurations) {
                Element infoElement = ConfigurationManager.saveConfiguration(element, historyConfiguration);
                infoElement.setAttribute(SAVE_HISTORY_ATTR_NAME, "1");
            }
        }
    }

    public static Element saveConfiguration(Element element, Configuration config) {
        Element infoElement = new Element(config instanceof SearchConfiguration ? SEARCH_TAG_NAME : REPLACE_TAG_NAME);
        element.addContent(infoElement);
        config.writeExternal(infoElement);
        return infoElement;
    }

    public void loadConfigurations(Element element) {
        if (this.configurations != null) {
            return;
        }
        ArrayList<Configuration> configurations = new ArrayList<Configuration>();
        ArrayList<Configuration> historyConfigurations = new ArrayList<Configuration>();
        ConfigurationManager.readConfigurations(element, configurations, historyConfigurations);
        for (Configuration configuration : historyConfigurations) {
            this.addHistoryConfigurationToFront(configuration);
        }
        for (Configuration configuration : configurations) {
            this.addConfiguration(configuration);
        }
        if (this.historyConfigurations != null) {
            Collections.reverse(this.historyConfigurations);
        }
    }

    public static void readConfigurations(Element element, @NotNull Collection<Configuration> configurations, @NotNull Collection<Configuration> historyConfigurations) {
        if (configurations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurations", "com/intellij/structuralsearch/plugin/ui/ConfigurationManager", "readConfigurations"));
        }
        if (historyConfigurations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "historyConfigurations", "com/intellij/structuralsearch/plugin/ui/ConfigurationManager", "readConfigurations"));
        }
        List patterns = element.getChildren();
        if (patterns != null && patterns.size() > 0) {
            for (Element pattern : patterns) {
                Configuration config = ConfigurationManager.readConfiguration(pattern);
                if (config == null) continue;
                if (pattern.getAttribute(SAVE_HISTORY_ATTR_NAME) != null) {
                    historyConfigurations.add(config);
                    continue;
                }
                configurations.add(config);
            }
        }
    }

    public static Configuration readConfiguration(Element childElement) {
        SearchConfiguration config;
        String s = childElement.getName();
        Configuration configuration = s.equals(SEARCH_TAG_NAME) ? new SearchConfiguration() : (config = s.equals(REPLACE_TAG_NAME) ? new ReplaceConfiguration() : null);
        if (config != null) {
            ((Configuration)config).readExternal(childElement);
        }
        return config;
    }

    public Collection<Configuration> getConfigurations() {
        return this.configurations;
    }

    public static Configuration findConfigurationByName(Collection<Configuration> configurations, String name) {
        for (Configuration config : configurations) {
            if (!config.getName().equals(name)) continue;
            return config;
        }
        return null;
    }

    public Collection<Configuration> getHistoryConfigurations() {
        return this.historyConfigurations;
    }

    @Nullable
    public static String findAppropriateName(@NotNull Collection<Configuration> configurations, @NotNull String _name, @NotNull Project project) {
        Configuration config;
        if (configurations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurations", "com/intellij/structuralsearch/plugin/ui/ConfigurationManager", "findAppropriateName"));
        }
        if (_name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_name", "com/intellij/structuralsearch/plugin/ui/ConfigurationManager", "findAppropriateName"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/structuralsearch/plugin/ui/ConfigurationManager", "findAppropriateName"));
        }
        String name = _name;
        while ((config = ConfigurationManager.findConfigurationByName(configurations, name)) != null) {
            int i = Messages.showYesNoDialog((Project)project, (String)SSRBundle.message("overwrite.message", new Object[0]), (String)SSRBundle.message("overwrite.title", new Object[0]), (Icon)AllIcons.General.QuestionDialog);
            if (i == 0) {
                configurations.remove(config);
                break;
            }
            if ((name = ConfigurationManager.showSaveTemplateAsDialog(name, project)) != null) continue;
            break;
        }
        return name;
    }

    @Nullable
    public static String showSaveTemplateAsDialog(@NotNull String initial, @NotNull Project project) {
        if (initial == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initial", "com/intellij/structuralsearch/plugin/ui/ConfigurationManager", "showSaveTemplateAsDialog"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/structuralsearch/plugin/ui/ConfigurationManager", "showSaveTemplateAsDialog"));
        }
        return Messages.showInputDialog((Project)project, (String)SSRBundle.message("template.name.button", new Object[0]), (String)SSRBundle.message("save.template.description.button", new Object[0]), (Icon)AllIcons.General.QuestionDialog, (String)initial, (InputValidator)new NonEmptyInputValidator());
    }
}

