/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TempFiles {
    private final Collection<File> myFilesToDelete;

    public TempFiles(@NotNull Collection<File> filesToDelete) {
        if (filesToDelete == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesToDelete", "com/intellij/testFramework/TempFiles", "<init>"));
        }
        this.myFilesToDelete = filesToDelete;
    }

    @Nullable
    public VirtualFile createVFile(@NotNull String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/testFramework/TempFiles", "createVFile"));
        }
        return TempFiles.getVFileByFile(this.createTempFile(prefix));
    }

    @Nullable
    public VirtualFile createVFile(@NotNull String prefix, String postfix) {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/testFramework/TempFiles", "createVFile"));
        }
        return TempFiles.getVFileByFile(this.createTempFile(prefix, postfix));
    }

    @NotNull
    public File createTempFile(@NotNull String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/testFramework/TempFiles", "createTempFile"));
        }
        File file = this.createTempFile(prefix, null);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/TempFiles", "createTempFile"));
        }
        return file;
    }

    @NotNull
    public File createTempFile(@NotNull String prefix, String suffix) {
        File file;
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/testFramework/TempFiles", "createTempFile"));
        }
        try {
            File tempFile = FileUtil.createTempFile((String)prefix, (String)suffix);
            this.tempFileCreated(tempFile);
            TempFiles.getVFileByFile(tempFile);
            file = tempFile;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/TempFiles", "createTempFile"));
        }
        return file;
    }

    private void tempFileCreated(@NotNull File tempFile) {
        if (tempFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tempFile", "com/intellij/testFramework/TempFiles", "tempFileCreated"));
        }
        this.myFilesToDelete.add(tempFile);
    }

    @Nullable
    public static VirtualFile getVFileByFile(@NotNull File tempFile) {
        if (tempFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tempFile", "com/intellij/testFramework/TempFiles", "getVFileByFile"));
        }
        return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(tempFile);
    }

    @NotNull
    public File createTempDir() {
        File file = this.createTempDir("dir");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/TempFiles", "createTempDir"));
        }
        return file;
    }

    @NotNull
    private File createTempDir(@NotNull String prefix) {
        File file;
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/testFramework/TempFiles", "createTempDir"));
        }
        try {
            File dir = FileUtil.createTempDirectory((String)prefix, (String)"test", (boolean)false);
            this.tempFileCreated(dir);
            TempFiles.getVFileByFile(dir);
            file = dir;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/TempFiles", "createTempDir"));
        }
        return file;
    }

    @Nullable
    public VirtualFile createTempVDir() {
        return this.createTempVDir("dir");
    }

    @Nullable
    public VirtualFile createTempVDir(@NotNull String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/testFramework/TempFiles", "createTempVDir"));
        }
        return TempFiles.getVFileByFile(this.createTempDir(prefix));
    }

    public void deleteAll() {
        for (File file : this.myFilesToDelete) {
            if (FileUtil.delete((File)file)) continue;
            file.deleteOnExit();
        }
    }

    public VirtualFile createVFile(@NotNull VirtualFile parentDir, @NotNull String name, @NotNull String text) {
        if (parentDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDir", "com/intellij/testFramework/TempFiles", "createVFile"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/testFramework/TempFiles", "createVFile"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/testFramework/TempFiles", "createVFile"));
        }
        try {
            VirtualFile virtualFile = parentDir.createChildData((Object)this, name);
            VfsUtil.saveText((VirtualFile)virtualFile, (String)(text + "\n"));
            return virtualFile;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

