/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.testFramework.builders.ModuleFixtureBuilder;
import com.intellij.testFramework.fixtures.HeavyIdeaTestFixture;
import com.intellij.testFramework.fixtures.IdeaProjectTestFixture;
import com.intellij.testFramework.fixtures.TestFixtureBuilder;
import com.intellij.testFramework.fixtures.impl.HeavyIdeaTestFixtureImpl;
import com.intellij.util.pico.ConstructorInjectionComponentAdapter;
import com.intellij.util.pico.IdeaPicoContainer;
import java.lang.reflect.Field;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;

class HeavyTestFixtureBuilderImpl
implements TestFixtureBuilder<IdeaProjectTestFixture> {
    private final HeavyIdeaTestFixtureImpl myFixture;
    private final Map<Class<? extends ModuleFixtureBuilder>, Class<? extends ModuleFixtureBuilder>> myProviders;
    private final MutablePicoContainer myContainer;

    public HeavyTestFixtureBuilderImpl(HeavyIdeaTestFixtureImpl fixture, Map<Class<? extends ModuleFixtureBuilder>, Class<? extends ModuleFixtureBuilder>> providers) {
        this.myFixture = fixture;
        this.myProviders = providers;
        this.myContainer = new IdeaPicoContainer();
        this.myContainer.registerComponentInstance((Object)this);
    }

    private <M extends ModuleFixtureBuilder> M createModuleBuilder(Class<M> key) {
        Class<? extends ModuleFixtureBuilder> implClass = this.myProviders.get(key);
        assert (implClass != null) : key;
        ConstructorInjectionComponentAdapter adapter = new ConstructorInjectionComponentAdapter(implClass, implClass);
        return (M)((ModuleFixtureBuilder)adapter.getComponentInstance((PicoContainer)this.myContainer));
    }

    @Override
    @NotNull
    public HeavyIdeaTestFixture getFixture() {
        HeavyIdeaTestFixtureImpl heavyIdeaTestFixtureImpl = this.myFixture;
        if (heavyIdeaTestFixtureImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/HeavyTestFixtureBuilderImpl", "getFixture"));
        }
        return heavyIdeaTestFixtureImpl;
    }

    @Override
    public <M extends ModuleFixtureBuilder> M addModule(Class<M> builderClass) {
        HeavyTestFixtureBuilderImpl.loadClassConstants(builderClass);
        M builder = this.createModuleBuilder(builderClass);
        this.myFixture.addModuleFixtureBuilder((ModuleFixtureBuilder)builder);
        return builder;
    }

    private static void loadClassConstants(Class builderClass) {
        try {
            for (Field field : builderClass.getFields()) {
                field.get(null);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

