/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tokenindex;

import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class TokenIndexKey {
    private final Set<String> myLanguages;
    private final int myBlockId;

    public TokenIndexKey(@NotNull Set<String> languages, int blockId) {
        if (languages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languages", "com/intellij/tokenindex/TokenIndexKey", "<init>"));
        }
        this.myLanguages = languages;
        this.myBlockId = blockId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TokenIndexKey that = (TokenIndexKey)o;
        if (this.myBlockId != that.myBlockId) {
            return false;
        }
        return ((Object)this.myLanguages).equals(that.myLanguages);
    }

    public int hashCode() {
        int result = ((Object)this.myLanguages).hashCode();
        result = 31 * result + this.myBlockId;
        return result;
    }

    public String toString() {
        return this.myLanguages + ": " + this.myBlockId;
    }

    public Set<String> getLanguages() {
        return this.myLanguages;
    }

    public boolean containsLanguage(String languageId) {
        for (String language : this.myLanguages) {
            if (!language.contains(languageId)) continue;
            return true;
        }
        return false;
    }

    public int getBlockId() {
        return this.myBlockId;
    }
}

