/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.visible;

import com.intellij.openapi.util.Condition;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.graph.api.LinearGraphWithHiddenNodes;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphNode;
import com.intellij.vcs.log.graph.impl.visible.DottedEdges;
import com.intellij.vcs.log.graph.impl.visible.DottedEdgesComputer;
import com.intellij.vcs.log.graph.utils.Flags;
import com.intellij.vcs.log.graph.utils.ListenerController;
import com.intellij.vcs.log.graph.utils.impl.BitSetFlags;
import com.intellij.vcs.log.graph.utils.impl.SetListenerController;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FilterGraphWithHiddenNodes
implements LinearGraphWithHiddenNodes {
    @NotNull
    private final LinearGraphWithHiddenNodes myDelegateGraph;
    @NotNull
    private final Flags myVisibleNodes;
    @NotNull
    private final DottedEdges myDottedEdges;
    @NotNull
    private final SetListenerController<LinearGraphWithHiddenNodes.UpdateListener> myListenerController;

    public FilterGraphWithHiddenNodes(@NotNull LinearGraphWithHiddenNodes delegateGraph, @NotNull Condition<Integer> isVisibleNode) {
        if (delegateGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateGraph", "com/intellij/vcs/log/graph/impl/visible/FilterGraphWithHiddenNodes", "<init>"));
        }
        if (isVisibleNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isVisibleNode", "com/intellij/vcs/log/graph/impl/visible/FilterGraphWithHiddenNodes", "<init>"));
        }
        this.myListenerController = new SetListenerController();
        this.myDelegateGraph = delegateGraph;
        this.myVisibleNodes = new BitSetFlags(delegateGraph.nodesCount());
        for (int i = 0; i < delegateGraph.nodesCount(); ++i) {
            this.myVisibleNodes.set(i, delegateGraph.nodeIsVisible(i) && isVisibleNode.value((Object)i));
        }
        MultiMap<Integer, Integer> edges = DottedEdgesComputer.compute(this.myDelegateGraph, this.myVisibleNodes);
        this.myDottedEdges = DottedEdges.newInstance(edges);
        this.addUpdateListener();
    }

    private void addUpdateListener() {
        this.myDelegateGraph.getListenerController().addListener(new LinearGraphWithHiddenNodes.UpdateListener(){

            @Override
            public void update(final int upNodeIndex, final int downNodeIndex) {
                FilterGraphWithHiddenNodes.this.myListenerController.callListeners(new Consumer<LinearGraphWithHiddenNodes.UpdateListener>(){

                    public void consume(LinearGraphWithHiddenNodes.UpdateListener updateListener) {
                        updateListener.update(upNodeIndex, downNodeIndex);
                    }
                });
            }
        });
    }

    @Override
    public boolean nodeIsVisible(int nodeIndex) {
        return this.myVisibleNodes.get(nodeIndex);
    }

    @Override
    @NotNull
    public GraphNode.Type getNodeType(int nodeIndex) {
        GraphNode.Type type = GraphNode.Type.USUAL;
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/visible/FilterGraphWithHiddenNodes", "getNodeType"));
        }
        return type;
    }

    @Override
    @NotNull
    public GraphEdge.Type getEdgeType(int upNodeIndex, int downNodeIndex) {
        if (this.myDottedEdges.getAdjacentNodes(upNodeIndex).contains(downNodeIndex)) {
            GraphEdge.Type type = GraphEdge.Type.HIDE;
            if (type == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/visible/FilterGraphWithHiddenNodes", "getEdgeType"));
            }
            return type;
        }
        GraphEdge.Type type = GraphEdge.Type.USUAL;
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/visible/FilterGraphWithHiddenNodes", "getEdgeType"));
        }
        return type;
    }

    @Override
    @NotNull
    public ListenerController<LinearGraphWithHiddenNodes.UpdateListener> getListenerController() {
        SetListenerController<LinearGraphWithHiddenNodes.UpdateListener> setListenerController = this.myListenerController;
        if (setListenerController == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/visible/FilterGraphWithHiddenNodes", "getListenerController"));
        }
        return setListenerController;
    }

    @Override
    public int nodesCount() {
        return this.myDelegateGraph.nodesCount();
    }

    @Override
    @NotNull
    public List<Integer> getUpNodes(int nodeIndex) {
        SmartList upNodes = new SmartList();
        for (int upNode : this.myDelegateGraph.getUpNodes(nodeIndex)) {
            if (!this.nodeIsVisible(upNode)) continue;
            upNodes.add(upNode);
        }
        for (int adjNode : this.myDottedEdges.getAdjacentNodes(nodeIndex)) {
            if (adjNode >= nodeIndex) continue;
            upNodes.add(adjNode);
        }
        SmartList smartList = upNodes;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/visible/FilterGraphWithHiddenNodes", "getUpNodes"));
        }
        return smartList;
    }

    @Override
    @NotNull
    public List<Integer> getDownNodes(int nodeIndex) {
        SmartList downNodes = new SmartList();
        for (int downNode : this.myDelegateGraph.getDownNodes(nodeIndex)) {
            if (downNode == Integer.MAX_VALUE || !this.nodeIsVisible(downNode)) continue;
            downNodes.add(downNode);
        }
        for (int adjNode : this.myDottedEdges.getAdjacentNodes(nodeIndex)) {
            if (adjNode <= nodeIndex) continue;
            downNodes.add(adjNode);
        }
        SmartList smartList = downNodes;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/visible/FilterGraphWithHiddenNodes", "getDownNodes"));
        }
        return smartList;
    }
}

