/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.VcsLogDataHolder;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.ui.frame.VcsLogGraphTable;
import com.intellij.vcs.log.ui.tables.GraphTableModel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogImpl
implements VcsLog {
    @NotNull
    private final VcsLogDataHolder myDataHolder;
    @NotNull
    private final VcsLogUiImpl myUi;

    public VcsLogImpl(@NotNull VcsLogDataHolder holder, @NotNull VcsLogUiImpl ui) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/vcs/log/impl/VcsLogImpl", "<init>"));
        }
        if (ui == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "com/intellij/vcs/log/impl/VcsLogImpl", "<init>"));
        }
        this.myDataHolder = holder;
        this.myUi = ui;
    }

    @NotNull
    public List<Hash> getSelectedCommits() {
        ArrayList hashes = ContainerUtil.newArrayList();
        VcsLogGraphTable table = this.myUi.getTable();
        for (int row : table.getSelectedRows()) {
            Hash hash = ((GraphTableModel)table.getModel()).getHashAtRow(row);
            if (hash == null) continue;
            hashes.add(hash);
        }
        ArrayList arrayList = hashes;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogImpl", "getSelectedCommits"));
        }
        return arrayList;
    }

    @NotNull
    public List<VcsFullCommitDetails> getSelectedDetails() {
        ArrayList details = ContainerUtil.newArrayList();
        VcsLogGraphTable table = this.myUi.getTable();
        for (int row : table.getSelectedRows()) {
            GraphTableModel model = (GraphTableModel)table.getModel();
            VcsFullCommitDetails commitDetails = model.getFullCommitDetails(row);
            if (commitDetails == null) {
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogImpl", "getSelectedDetails"));
                }
                return list;
            }
            details.add(commitDetails);
        }
        ArrayList arrayList = details;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogImpl", "getSelectedDetails"));
        }
        return arrayList;
    }

    @Nullable
    public VcsFullCommitDetails getDetailsIfAvailable(@NotNull Hash hash) {
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/vcs/log/impl/VcsLogImpl", "getDetailsIfAvailable"));
        }
        return (VcsFullCommitDetails)this.myDataHolder.getCommitDetailsGetter().getCommitDataIfAvailable(hash);
    }

    @Nullable
    public Collection<String> getContainingBranches(@NotNull Hash commitHash) {
        if (commitHash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitHash", "com/intellij/vcs/log/impl/VcsLogImpl", "getContainingBranches"));
        }
        return null;
    }

    @NotNull
    public Collection<VcsRef> getAllReferences() {
        Collection<VcsRef> collection = this.myUi.getDataPack().getRefsModel().getAllRefs();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogImpl", "getAllReferences"));
        }
        return collection;
    }

    public void jumpToReference(final String reference) {
        Collection<VcsRef> references = this.getAllReferences();
        VcsRef ref = (VcsRef)ContainerUtil.find(references, (Condition)new Condition<VcsRef>(){

            public boolean value(VcsRef ref) {
                return ref.getName().startsWith(reference);
            }
        });
        if (ref != null) {
            this.myUi.jumpToCommit(ref.getCommitHash());
        } else {
            this.myUi.jumpToCommitByPartOfHash(reference);
        }
    }

    @NotNull
    public Component getToolbar() {
        Component component = this.myUi.getToolbar();
        if (component == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogImpl", "getToolbar"));
        }
        return component;
    }

    @NotNull
    public Collection<VcsLogProvider> getLogProviders() {
        Collection<VcsLogProvider> collection = this.myDataHolder.getLogProviders();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogImpl", "getLogProviders"));
        }
        return collection;
    }
}

