/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.data.VcsLogDataHolder;
import com.intellij.vcs.log.data.VcsLogUiProperties;
import com.intellij.vcs.log.ui.filter.MultipleValueFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.VcsLogClassicFilterUi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class UserFilterPopupComponent
extends MultipleValueFilterPopupComponent<VcsLogUserFilter> {
    private static final String ME = "me";
    private final VcsLogDataHolder myDataHolder;
    private final VcsLogUiProperties myUiProperties;

    UserFilterPopupComponent(@NotNull VcsLogClassicFilterUi filterUi, @NotNull VcsLogDataHolder dataHolder, @NotNull VcsLogUiProperties uiProperties) {
        if (filterUi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterUi", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent", "<init>"));
        }
        if (dataHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataHolder", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent", "<init>"));
        }
        if (uiProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiProperties", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent", "<init>"));
        }
        super(filterUi, "User");
        this.myDataHolder = dataHolder;
        this.myUiProperties = uiProperties;
    }

    @Override
    protected ActionGroup createActionGroup() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add(this.createAllAction());
        group.add(this.createSelectMultipleValuesAction());
        if (!this.myDataHolder.getCurrentUser().isEmpty()) {
            group.add(this.createPredefinedValueAction(Collections.singleton(ME)));
        }
        group.addAll(this.createRecentItemsActionGroup());
        return group;
    }

    @Override
    @NotNull
    protected List<List<String>> getRecentValuesFromSettings() {
        List<List<String>> list = this.myUiProperties.getRecentlyFilteredUserGroups();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent", "getRecentValuesFromSettings"));
        }
        return list;
    }

    @Override
    @Nullable
    protected VcsLogUserFilter getFilter() {
        if (this.getSelectedValues() == null) {
            return null;
        }
        return new VcsLogUserFilterImpl(this.getSelectedValues(), this.myDataHolder.getCurrentUser());
    }

    @Override
    protected void rememberValuesInSettings(@NotNull Collection<String> values) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent", "rememberValuesInSettings"));
        }
        this.myUiProperties.addRecentlyFilteredUserGroup(new ArrayList<String>(values));
    }

    @Override
    @NotNull
    protected List<String> getAllValues() {
        List list = ContainerUtil.map(this.myDataHolder.getAllUsers(), (Function)new Function<VcsUser, String>(){

            public String fun(VcsUser user) {
                return user.getName();
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent", "getAllValues"));
        }
        return list;
    }

    private static class VcsLogUserFilterImpl
    implements VcsLogUserFilter {
        @NotNull
        private final Collection<String> myUsers;
        @NotNull
        private final Map<VirtualFile, VcsUser> myData;

        public VcsLogUserFilterImpl(@NotNull Collection<String> users, @NotNull Map<VirtualFile, VcsUser> meData) {
            if (users == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "users", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent$VcsLogUserFilterImpl", "<init>"));
            }
            if (meData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meData", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent$VcsLogUserFilterImpl", "<init>"));
            }
            this.myUsers = users;
            this.myData = meData;
        }

        @NotNull
        public Collection<String> getUserNames(final @NotNull VirtualFile root) {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent$VcsLogUserFilterImpl", "getUserNames"));
            }
            List list = ContainerUtil.mapNotNull(this.myUsers, (Function)new Function<String, String>(){

                public String fun(String user) {
                    if (UserFilterPopupComponent.ME.equals(user)) {
                        VcsUser vcsUser = (VcsUser)VcsLogUserFilterImpl.this.myData.get(root);
                        return vcsUser == null ? null : vcsUser.getName();
                    }
                    return user;
                }
            });
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent$VcsLogUserFilterImpl", "getUserNames"));
            }
            return list;
        }

        public boolean matches(final @NotNull VcsCommitMetadata commit) {
            if (commit == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent$VcsLogUserFilterImpl", "matches"));
            }
            return ContainerUtil.exists(this.getUserNames(commit.getRoot()), (Condition)new Condition<String>(){

                public boolean value(String user) {
                    String lowerUser = user.toLowerCase();
                    return commit.getAuthor().getName().toLowerCase().contains(lowerUser) || commit.getAuthor().getEmail().toLowerCase().contains(lowerUser);
                }
            });
        }
    }
}

