/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.index;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.NullableFunction;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.xml.index.IndexedRelevantResource;
import com.intellij.xml.index.XmlIndex;
import com.intellij.xml.index.XsdNamespaceBuilder;
import com.intellij.xml.util.XmlUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlNamespaceIndex
extends XmlIndex<XsdNamespaceBuilder> {
    public static final ID<String, XsdNamespaceBuilder> NAME = ID.create((String)"XmlNamespaces");

    @Nullable
    public static String getNamespace(@NotNull VirtualFile file, Project project, PsiFile context) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xml/index/XmlNamespaceIndex", "getNamespace"));
        }
        if (DumbService.isDumb((Project)project) || context != null && XmlUtil.isStubBuilding()) {
            try {
                return XsdNamespaceBuilder.computeNamespace(file.getInputStream());
            }
            catch (IOException e) {
                return null;
            }
        }
        List list = FileBasedIndex.getInstance().getValues(NAME, (Object)file.getUrl(), XmlNamespaceIndex.createFilter(project));
        return list.size() == 0 ? null : ((XsdNamespaceBuilder)list.get(0)).getNamespace();
    }

    public static List<IndexedRelevantResource<String, XsdNamespaceBuilder>> getResourcesByNamespace(String namespace, @NotNull Project project, @Nullable Module module) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xml/index/XmlNamespaceIndex", "getResourcesByNamespace"));
        }
        List<IndexedRelevantResource<String, XsdNamespaceBuilder>> resources = IndexedRelevantResource.getResources(NAME, namespace, module, project, null);
        Collections.sort(resources);
        return resources;
    }

    public static List<IndexedRelevantResource<String, XsdNamespaceBuilder>> getAllResources(@Nullable Module module, @NotNull Project project, @Nullable NullableFunction<List<IndexedRelevantResource<String, XsdNamespaceBuilder>>, IndexedRelevantResource<String, XsdNamespaceBuilder>> chooser) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xml/index/XmlNamespaceIndex", "getAllResources"));
        }
        return IndexedRelevantResource.getAllResources(NAME, module, project, chooser);
    }

    @NotNull
    public ID<String, XsdNamespaceBuilder> getName() {
        ID<String, XsdNamespaceBuilder> iD = NAME;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/index/XmlNamespaceIndex", "getName"));
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, XsdNamespaceBuilder, FileContent> getIndexer() {
        DataIndexer<String, XsdNamespaceBuilder, FileContent> dataIndexer = new DataIndexer<String, XsdNamespaceBuilder, FileContent>(){

            @NotNull
            public Map<String, XsdNamespaceBuilder> map(@NotNull FileContent inputData) {
                if (inputData == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "com/intellij/xml/index/XmlNamespaceIndex$1", "map"));
                }
                XsdNamespaceBuilder builder = "dtd".equals(inputData.getFile().getExtension()) ? new XsdNamespaceBuilder(inputData.getFileName(), "", Collections.<String>emptyList()) : XsdNamespaceBuilder.computeNamespace(CharArrayUtil.readerFromCharSequence((CharSequence)inputData.getContentAsText()));
                HashMap<String, XsdNamespaceBuilder> map = new HashMap<String, XsdNamespaceBuilder>(2);
                String namespace = builder.getNamespace();
                if (namespace != null) {
                    map.put(namespace, builder);
                }
                map.put(inputData.getFile().getUrl(), builder);
                HashMap<String, XsdNamespaceBuilder> hashMap = map;
                if (hashMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/index/XmlNamespaceIndex$1", "map"));
                }
                return hashMap;
            }
        };
        if (dataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/index/XmlNamespaceIndex", "getIndexer"));
        }
        return dataIndexer;
    }

    @NotNull
    public DataExternalizer<XsdNamespaceBuilder> getValueExternalizer() {
        DataExternalizer<XsdNamespaceBuilder> dataExternalizer = new DataExternalizer<XsdNamespaceBuilder>(){

            public void save(@NotNull DataOutput out, XsdNamespaceBuilder value) throws IOException {
                if (out == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/xml/index/XmlNamespaceIndex$2", "save"));
                }
                out.writeUTF(value.getNamespace() == null ? "" : value.getNamespace());
                out.writeUTF(value.getVersion() == null ? "" : value.getVersion());
                out.writeInt(value.getTags().size());
                for (String s : value.getTags()) {
                    out.writeUTF(s);
                }
            }

            public XsdNamespaceBuilder read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/xml/index/XmlNamespaceIndex$2", "read"));
                }
                int count = in.readInt();
                XsdNamespaceBuilder builder = new XsdNamespaceBuilder(in.readUTF(), in.readUTF(), new ArrayList<String>(count));
                for (int i = 0; i < count; ++i) {
                    builder.getTags().add(in.readUTF());
                }
                return builder;
            }
        };
        if (dataExternalizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/index/XmlNamespaceIndex", "getValueExternalizer"));
        }
        return dataExternalizer;
    }

    @Override
    public int getVersion() {
        return 2;
    }

    @Nullable
    public static IndexedRelevantResource<String, XsdNamespaceBuilder> guessSchema(String namespace, final @Nullable String tagName, final @Nullable String version, @Nullable Module module, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xml/index/XmlNamespaceIndex", "guessSchema"));
        }
        List<IndexedRelevantResource<String, XsdNamespaceBuilder>> resources = XmlNamespaceIndex.getResourcesByNamespace(namespace, project, module);
        if (resources.isEmpty()) {
            return null;
        }
        return Collections.max(resources, new Comparator<IndexedRelevantResource<String, XsdNamespaceBuilder>>(){

            @Override
            public int compare(IndexedRelevantResource<String, XsdNamespaceBuilder> o1, IndexedRelevantResource<String, XsdNamespaceBuilder> o2) {
                int i = o1.compareTo(o2);
                return i == 0 ? o1.getValue().getRating(tagName, version) - o2.getValue().getRating(tagName, version) : i;
            }
        });
    }

    @Nullable
    public static XmlFile guessSchema(String namespace, @Nullable String tagName, @Nullable String version, @NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xml/index/XmlNamespaceIndex", "guessSchema"));
        }
        if (DumbService.isDumb((Project)file.getProject()) || XmlUtil.isStubBuilding()) {
            return null;
        }
        IndexedRelevantResource<String, XsdNamespaceBuilder> resource = XmlNamespaceIndex.guessSchema(namespace, tagName, version, ModuleUtilCore.findModuleForPsiElement((PsiElement)file), file.getProject());
        if (resource == null) {
            return null;
        }
        return XmlNamespaceIndex.findSchemaFile(resource.getFile(), file);
    }

    @Nullable
    private static XmlFile findSchemaFile(VirtualFile resourceFile, PsiFile baseFile) {
        PsiFile psiFile = baseFile.getManager().findFile(resourceFile);
        return psiFile instanceof XmlFile ? (XmlFile)psiFile : null;
    }

    @Nullable
    public static XmlFile guessDtd(String dtdUri, @NotNull PsiFile baseFile) {
        IndexedRelevantResource<String, XsdNamespaceBuilder> resource;
        if (baseFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseFile", "com/intellij/xml/index/XmlNamespaceIndex", "guessDtd"));
        }
        if (!dtdUri.endsWith(".dtd") || DumbService.isDumb((Project)baseFile.getProject()) || XmlUtil.isStubBuilding()) {
            return null;
        }
        String dtdFileName = new File(dtdUri).getName();
        List<IndexedRelevantResource<String, XsdNamespaceBuilder>> list = XmlNamespaceIndex.getResourcesByNamespace(dtdFileName, baseFile.getProject(), ModuleUtilCore.findModuleForPsiElement((PsiElement)baseFile));
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() > 1) {
            final String[] split = dtdUri.split("/");
            resource = Collections.max(list, new Comparator<IndexedRelevantResource<String, XsdNamespaceBuilder>>(){

                @Override
                public int compare(IndexedRelevantResource<String, XsdNamespaceBuilder> o1, IndexedRelevantResource<String, XsdNamespaceBuilder> o2) {
                    return this.weight(o1) - this.weight(o2);
                }

                int weight(IndexedRelevantResource<String, XsdNamespaceBuilder> o1) {
                    VirtualFile file = o1.getFile();
                    for (int i = split.length - 1; i >= 0 && file != null; file = file.getParent(), --i) {
                        String s = split[i];
                        if (s.equals(file.getName())) continue;
                        return split.length - i;
                    }
                    return 0;
                }
            });
        } else {
            resource = list.get(0);
        }
        return XmlNamespaceIndex.findSchemaFile(resource.getFile(), baseFile);
    }
}

