/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.NotNull;

public class NoopMethodInAbstractClassInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("noop.method.in.abstract.class.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/NoopMethodInAbstractClassInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("noop.method.in.abstract.class.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/NoopMethodInAbstractClassInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NoopMethodInAbstractClassVisitor();
    }

    private static class NoopMethodInAbstractClassVisitor
    extends BaseInspectionVisitor {
        private NoopMethodInAbstractClassVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/classlayout/NoopMethodInAbstractClassInspection$NoopMethodInAbstractClassVisitor", "visitMethod"));
            }
            if (method.isConstructor()) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (containingClass.isInterface() || containingClass.isAnnotationType()) {
                return;
            }
            if (!containingClass.hasModifierProperty("abstract")) {
                return;
            }
            if (method.hasModifierProperty("abstract") || method.hasModifierProperty("native") || method.hasModifierProperty("final")) {
                return;
            }
            if (!MethodUtils.isEmpty(method)) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }
    }
}

