/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;

public class SubstringZeroInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("substring.zero.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/SubstringZeroInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("substring.zero.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/SubstringZeroInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new SubstringZeroFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SubstringZeroVisitor();
    }

    private static class SubstringZeroVisitor
    extends BaseInspectionVisitor {
        private SubstringZeroVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/performance/SubstringZeroInspection$SubstringZeroVisitor", "visitMethodCallExpression"));
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"substring".equals(methodName)) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression argument = arguments[0];
            if (argument == null) {
                return;
            }
            if (!ExpressionUtils.isZero(argument)) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            String className = aClass.getQualifiedName();
            if (!"java.lang.String".equals(className)) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }
    }

    private static class SubstringZeroFix
    extends InspectionGadgetsFix {
        private SubstringZeroFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("constant.conditional.expression.simplify.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/SubstringZeroInspection$SubstringZeroFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/SubstringZeroInspection$SubstringZeroFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiMethodCallExpression call = (PsiMethodCallExpression)descriptor.getPsiElement();
            PsiReferenceExpression expression = call.getMethodExpression();
            PsiExpression qualifier = expression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            String qualifierText = qualifier.getText();
            PsiReplacementUtil.replaceExpression((PsiExpression)call, qualifierText);
        }
    }
}

