/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.options.impl;

import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMExternalizer;
import java.beans.PropertyChangeSupport;
import org.intellij.images.options.ExternalEditorOptions;
import org.jdom.Element;

final class ExternalEditorOptionsImpl
implements ExternalEditorOptions,
JDOMExternalizable {
    private final PropertyChangeSupport propertyChangeSupport;
    private String executablePath;

    public ExternalEditorOptionsImpl(PropertyChangeSupport propertyChangeSupport) {
        this.propertyChangeSupport = propertyChangeSupport;
    }

    @Override
    public String getExecutablePath() {
        return this.executablePath;
    }

    void setExecutablePath(String executablePath) {
        String oldValue = this.executablePath;
        if (oldValue != null && !oldValue.equals(executablePath) || oldValue == null && executablePath != null) {
            this.executablePath = executablePath;
            this.propertyChangeSupport.firePropertyChange("ExternalEditor.executablePath", oldValue, this.executablePath);
        }
    }

    public ExternalEditorOptions clone() throws CloneNotSupportedException {
        return (ExternalEditorOptions)super.clone();
    }

    @Override
    public void inject(ExternalEditorOptions options) {
        this.setExecutablePath(options.getExecutablePath());
    }

    @Override
    public boolean setOption(String name, Object value) {
        if (!"ExternalEditor.executablePath".equals(name)) {
            return false;
        }
        this.setExecutablePath((String)value);
        return true;
    }

    public void readExternal(Element element) {
        this.executablePath = JDOMExternalizer.readString((Element)element, (String)"ExternalEditor.executablePath");
    }

    public void writeExternal(Element element) {
        JDOMExternalizer.write((Element)element, (String)"ExternalEditor.executablePath", (String)this.executablePath);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExternalEditorOptions)) {
            return false;
        }
        ExternalEditorOptions otherOptions = (ExternalEditorOptions)o;
        return this.executablePath != null ? this.executablePath.equals(otherOptions.getExecutablePath()) : otherOptions.getExecutablePath() == null;
    }

    public int hashCode() {
        return this.executablePath != null ? this.executablePath.hashCode() : 0;
    }
}

