/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.lang.manifest.header;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.LevenshteinDistance;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.lang.manifest.header.HeaderNameMatch;
import org.jetbrains.lang.manifest.header.HeaderParser;
import org.jetbrains.lang.manifest.header.HeaderParserProvider;
import org.jetbrains.lang.manifest.psi.Header;
import org.jetbrains.lang.manifest.psi.HeaderValuePart;

public class HeaderParserRepository {
    private final NotNullLazyValue<Map<String, HeaderParser>> myParsers = new NotNullLazyValue<Map<String, HeaderParser>>(){

        @NotNull
        protected Map<String, HeaderParser> compute() {
            HashMap map = ContainerUtil.newHashMap();
            for (HeaderParserProvider provider : (HeaderParserProvider[])Extensions.getExtensions(HeaderParserProvider.EP_NAME)) {
                map.putAll(provider.getHeaderParsers());
            }
            HashMap hashMap = map;
            if (hashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/lang/manifest/header/HeaderParserRepository$1", "compute"));
            }
            return hashMap;
        }
    };

    public static HeaderParserRepository getInstance() {
        return (HeaderParserRepository)ServiceManager.getService(HeaderParserRepository.class);
    }

    @Nullable
    public HeaderParser getHeaderParser(@Nullable String headerName) {
        return (HeaderParser)((Map)this.myParsers.getValue()).get(headerName);
    }

    @NotNull
    public Collection<HeaderNameMatch> getMatches(@NotNull String headerName) {
        if (headerName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headerName", "org/jetbrains/lang/manifest/header/HeaderParserRepository", "getMatches"));
        }
        HeaderParser parser = (HeaderParser)((Map)this.myParsers.getValue()).get(headerName);
        if (parser != null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/lang/manifest/header/HeaderParserRepository", "getMatches"));
            }
            return list;
        }
        LevenshteinDistance distance = new LevenshteinDistance();
        TreeSet<HeaderNameMatch> result = new TreeSet<HeaderNameMatch>();
        for (Map.Entry entry : ((Map)this.myParsers.getValue()).entrySet()) {
            String otherName = (String)entry.getKey();
            int dist = distance.calculateMetrics((CharSequence)headerName, (CharSequence)otherName);
            result.add(new HeaderNameMatch(dist, otherName));
        }
        TreeSet<HeaderNameMatch> treeSet = result;
        if (treeSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/lang/manifest/header/HeaderParserRepository", "getMatches"));
        }
        return treeSet;
    }

    @NotNull
    public Set<String> getAllHeaderNames() {
        Set<String> set = ((Map)this.myParsers.getValue()).keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/lang/manifest/header/HeaderParserRepository", "getAllHeaderNames"));
        }
        return set;
    }

    @Nullable
    public Object getConvertedValue(@NotNull Header header) {
        if (header == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "header", "org/jetbrains/lang/manifest/header/HeaderParserRepository", "getConvertedValue"));
        }
        HeaderParser parser = this.getHeaderParser(header.getName());
        return parser != null ? parser.getConvertedValue(header) : null;
    }

    @NotNull
    public PsiReference[] getReferences(@NotNull HeaderValuePart headerValuePart) {
        HeaderParser parser;
        if (headerValuePart == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headerValuePart", "org/jetbrains/lang/manifest/header/HeaderParserRepository", "getReferences"));
        }
        Header header = (Header)PsiTreeUtil.getParentOfType((PsiElement)headerValuePart, Header.class);
        if (header != null && (parser = this.getHeaderParser(header.getName())) != null) {
            PsiReference[] psiReferenceArray = parser.getReferences(headerValuePart);
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/lang/manifest/header/HeaderParserRepository", "getReferences"));
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/lang/manifest/header/HeaderParserRepository", "getReferences"));
        }
        return PsiReference.EMPTY_ARRAY;
    }
}

