/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.ide.common.resources.LocaleManager;
import com.android.resources.ResourceFolderType;
import com.android.tools.lint.checks.UnusedResourceDetector;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TranslationDetector
extends ResourceXmlDetector {
    static boolean sCompleteRegions = System.getenv("ANDROID_LINT_COMPLETE_REGIONS") != null;
    private static final Pattern LANGUAGE_PATTERN = Pattern.compile("^[a-z]{2}$");
    private static final Pattern REGION_PATTERN = Pattern.compile("^r([A-Z]{2})$");
    private static final Implementation IMPLEMENTATION = new Implementation(TranslationDetector.class, Scope.ALL_RESOURCES_SCOPE);
    public static final Issue MISSING = Issue.create("MissingTranslation", "Incomplete translation", "If an application has more than one locale, then all the strings declared in one language should also be translated in all other languages.\n\nIf the string should *not* be translated, you can add the attribute `translatable=\"false\"` on the `<string>` element, or you can define all your non-translatable strings in a resource file called `donottranslate.xml`. Or, you can ignore the issue with a `tools:ignore=\"MissingTranslation\"` attribute.\n\nBy default this detector allows regions of a language to just provide a subset of the strings and fall back to the standard language strings. You can require all regions to provide a full translation by setting the environment variable `ANDROID_LINT_COMPLETE_REGIONS`.\n\nYou can tell lint (and other tools) which language is the default language in your `res/values/` folder by specifying `tools:locale=\"languageCode\"` for the root `<resources>` element in your resource file. (The `tools` prefix refers to the namespace declaration `http://schemas.android.com/tools`.)", Category.MESSAGES, 8, Severity.FATAL, IMPLEMENTATION);
    public static final Issue EXTRA = Issue.create("ExtraTranslation", "Extra translation", "If a string appears in a specific language translation file, but there is no corresponding string in the default locale, then this string is probably unused. (It's technically possible that your application is only intended to run in a specific locale, but it's still a good idea to provide a fallback.).\n\nNote that these strings can lead to crashes if the string is looked up on any locale not providing a translation, so it's important to clean them up.", Category.MESSAGES, 6, Severity.FATAL, IMPLEMENTATION);
    private Set<String> mNames;
    private Set<String> mTranslatedArrays;
    private Set<String> mNonTranslatable;
    private boolean mIgnoreFile;
    private Map<File, Set<String>> mFileToNames;
    private Map<File, String> mFileToLocale;
    private Map<String, Location> mMissingLocations;
    private Map<String, Location> mExtraLocations;
    private Map<String, String> mDescriptions;

    @Override
    public boolean appliesTo(@NonNull ResourceFolderType folderType) {
        return folderType == ResourceFolderType.VALUES;
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Arrays.asList("string", "string-array");
    }

    @Override
    public void beforeCheckProject(@NonNull Context context) {
        if (context.getDriver().getPhase() == 1) {
            this.mFileToNames = new HashMap<File, Set<String>>();
        }
    }

    @Override
    public void beforeCheckFile(@NonNull Context context) {
        if (context.getPhase() == 1) {
            this.mNames = new HashSet<String>();
        }
        boolean bl = this.mIgnoreFile = context.file.getName().startsWith("donottranslate") || UnusedResourceDetector.isAnalyticsFile(context);
        if (!context.getProject().getReportIssues()) {
            this.mIgnoreFile = true;
        }
    }

    @Override
    public void afterCheckFile(@NonNull Context context) {
        if (context.getPhase() == 1) {
            if (context.getProject().getReportIssues() && this.mNames != null && !this.mNames.isEmpty()) {
                String locale;
                this.mFileToNames.put(context.file, this.mNames);
                Element root = ((XmlContext)context).document.getDocumentElement();
                if (root != null && (locale = root.getAttributeNS("http://schemas.android.com/tools", "locale")) != null && !locale.isEmpty()) {
                    if (this.mFileToLocale == null) {
                        this.mFileToLocale = Maps.newHashMap();
                    }
                    this.mFileToLocale.put(context.file, locale);
                }
            }
            this.mNames = null;
        }
    }

    @Override
    public void afterCheckProject(@NonNull Context context) {
        if (context.getPhase() == 1) {
            this.checkTranslations(context);
            this.mFileToNames = null;
            if (this.mMissingLocations != null || this.mExtraLocations != null) {
                context.getDriver().requestRepeat(this, Scope.ALL_RESOURCES_SCOPE);
            }
        } else {
            assert (context.getPhase() == 2);
            this.reportMap(context, MISSING, this.mMissingLocations);
            this.reportMap(context, EXTRA, this.mExtraLocations);
            this.mMissingLocations = null;
            this.mExtraLocations = null;
            this.mDescriptions = null;
        }
    }

    private void reportMap(Context context, Issue issue, Map<String, Location> map) {
        if (map != null) {
            for (Map.Entry<String, Location> entry : map.entrySet()) {
                Location location = entry.getValue();
                String name = entry.getKey();
                String message = this.mDescriptions.get(name);
                if (location == null) {
                    location = Location.create(context.getProject().getDir());
                }
                location = Location.reverse(location);
                context.report(issue, location, message);
            }
        }
    }

    private void checkTranslations(Context context) {
        Set<File> files = this.mFileToNames.keySet();
        if (files.size() == 1) {
            return;
        }
        HashSet<File> parentFolders = new HashSet<File>();
        for (File file : files) {
            parentFolders.add(file.getParentFile());
        }
        if (parentFolders.size() == 1) {
            return;
        }
        boolean reportMissing = context.isEnabled(MISSING);
        boolean reportExtra = context.isEnabled(EXTRA);
        String defaultLanguage = "Default";
        HashMap<File, String> parentFolderToLanguage = new HashMap<File, String>();
        for (File parent : parentFolders) {
            String name = parent.getName();
            String language = TranslationDetector.getLanguage(name);
            if (language == null) {
                language = defaultLanguage;
            }
            parentFolderToLanguage.put(parent, language);
        }
        int languageCount = parentFolderToLanguage.values().size();
        if (languageCount <= 1) {
            return;
        }
        HashMap<String, Set<String>> languageToStrings = new HashMap<String, Set<String>>(languageCount);
        HashSet<String> allStrings = new HashSet<String>(200);
        for (File file : files) {
            String locale;
            String language = null;
            if (this.mFileToLocale != null && (locale = this.mFileToLocale.get(file)) != null) {
                int index = locale.indexOf(45);
                if (index != -1) {
                    locale = locale.substring(0, index);
                }
                language = locale;
            }
            if (language == null) {
                language = (String)parentFolderToLanguage.get(file.getParentFile());
            }
            assert (language != null) : file.getParent();
            Set<String> fileStrings = this.mFileToNames.get(file);
            Set languageStrings = (Set)languageToStrings.get(language);
            if (languageStrings == null) {
                languageToStrings.put(language, fileStrings);
            } else {
                languageStrings.addAll(fileStrings);
            }
            allStrings.addAll(fileStrings);
        }
        HashSet defaultStrings = (HashSet)languageToStrings.get(defaultLanguage);
        if (defaultStrings == null) {
            defaultStrings = new HashSet();
        }
        if (this.mFileToLocale != null) {
            HashSet specifiedLocales = Sets.newHashSet();
            for (Map.Entry<File, String> entry : this.mFileToLocale.entrySet()) {
                String locale = entry.getValue();
                int index = locale.indexOf(45);
                if (index != -1) {
                    locale = locale.substring(0, index);
                }
                specifiedLocales.add(locale);
            }
            if (specifiedLocales.size() == 1) {
                String first = (String)specifiedLocales.iterator().next();
                Set languageStrings = (Set)languageToStrings.get(first);
                assert (languageStrings != null);
                defaultStrings.addAll(languageStrings);
            }
        }
        int stringCount = allStrings.size();
        if (!sCompleteRegions && !languageToStrings.containsKey("en") && this.mFileToLocale == null) {
            for (String l : languageToStrings.keySet()) {
                if (!l.startsWith("en-")) continue;
                languageToStrings.put("en", defaultStrings);
                break;
            }
        }
        if (!sCompleteRegions) {
            for (String l : languageToStrings.keySet()) {
                if (l.indexOf(45) == -1) continue;
                for (Map.Entry entry : languageToStrings.entrySet()) {
                    String language;
                    Set fallback;
                    String languageRegion;
                    int regionIndex;
                    Set strings = (Set)entry.getValue();
                    if (stringCount == strings.size() || (regionIndex = (languageRegion = (String)entry.getKey()).indexOf(45)) == -1 || (fallback = (Set)languageToStrings.get(language = languageRegion.substring(0, regionIndex))) == null) continue;
                    strings.addAll(fallback);
                }
            }
        }
        if (stringCount == defaultStrings.size()) {
            boolean haveError = false;
            for (Map.Entry entry : languageToStrings.entrySet()) {
                Set strings = (Set)entry.getValue();
                if (stringCount == strings.size()) continue;
                haveError = true;
                break;
            }
            if (!haveError) {
                return;
            }
        }
        ArrayList languages = new ArrayList(languageToStrings.keySet());
        Collections.sort(languages);
        for (String language : languages) {
            String message;
            Sets.SetView difference;
            Set strings = (Set)languageToStrings.get(language);
            if (defaultLanguage.equals(language) || stringCount == strings.size()) continue;
            if (reportMissing && !(difference = Sets.difference(defaultStrings, (Set)strings)).isEmpty()) {
                if (this.mMissingLocations == null) {
                    this.mMissingLocations = new HashMap<String, Location>();
                }
                if (this.mDescriptions == null) {
                    this.mDescriptions = new HashMap<String, String>();
                }
                for (String s : difference) {
                    this.mMissingLocations.put(s, null);
                    message = this.mDescriptions.get(s);
                    message = message == null ? String.format("\"`%1$s`\" is not translated in %2$s", s, TranslationDetector.getLanguageDescription(language)) : message + ", " + TranslationDetector.getLanguageDescription(language);
                    this.mDescriptions.put(s, message);
                }
            }
            if (!reportExtra || (difference = Sets.difference((Set)strings, defaultStrings)).isEmpty()) continue;
            if (this.mExtraLocations == null) {
                this.mExtraLocations = new HashMap<String, Location>();
            }
            if (this.mDescriptions == null) {
                this.mDescriptions = new HashMap<String, String>();
            }
            for (String s : difference) {
                if (this.mTranslatedArrays != null && this.mTranslatedArrays.contains(s)) continue;
                this.mExtraLocations.put(s, null);
                message = String.format("\"`%1$s`\" is translated here but not found in default locale", s);
                this.mDescriptions.put(s, message);
            }
        }
    }

    public static String getLanguageDescription(@NonNull String locale) {
        String languageName;
        int index = locale.indexOf(45);
        String regionCode = null;
        String languageCode = locale;
        if (index != -1) {
            regionCode = locale.substring(index + 2).toUpperCase(Locale.US);
            languageCode = locale.substring(0, index).toLowerCase(Locale.US);
        }
        if ((languageName = LocaleManager.getLanguageName(languageCode)) != null) {
            String regionName;
            if (regionCode != null && (regionName = LocaleManager.getRegionName(regionCode)) != null) {
                languageName = languageName + ": " + regionName;
            }
            return String.format("\"%1$s\" (%2$s)", locale, languageName);
        }
        return '\"' + locale + '\"';
    }

    private static String getLanguage(String name) {
        String[] segments = name.split("-");
        String language = null;
        for (String segment : segments) {
            if (language == null && segment.length() == 2 && LANGUAGE_PATTERN.matcher(segment).matches()) {
                language = segment;
            }
            if (language == null || segment.length() != 3 || !REGION_PATTERN.matcher(segment).matches()) continue;
            language = language + '-' + segment;
            break;
        }
        return language;
    }

    @Override
    public void visitElement(@NonNull XmlContext context, @NonNull Element element) {
        if (this.mIgnoreFile) {
            return;
        }
        Attr attribute = element.getAttributeNode("name");
        if (context.getPhase() == 2) {
            String language;
            if (attribute == null) {
                return;
            }
            String name = attribute.getValue();
            if (this.mMissingLocations != null && this.mMissingLocations.containsKey(name) && (language = TranslationDetector.getLanguage(context.file.getParentFile().getName())) == null) {
                if (context.getDriver().isSuppressed(context, MISSING, element)) {
                    this.mMissingLocations.remove(name);
                    return;
                }
                Location location = context.getLocation(attribute);
                location.setClientData(element);
                location.setSecondary(this.mMissingLocations.get(name));
                this.mMissingLocations.put(name, location);
            }
            if (this.mExtraLocations != null && this.mExtraLocations.containsKey(name)) {
                if (context.getDriver().isSuppressed(context, EXTRA, element)) {
                    this.mExtraLocations.remove(name);
                    return;
                }
                Location location = context.getLocation(attribute);
                location.setClientData(element);
                location.setMessage("Also translated here");
                location.setSecondary(this.mExtraLocations.get(name));
                this.mExtraLocations.put(name, location);
            }
            return;
        }
        assert (context.getPhase() == 1);
        if (attribute == null || attribute.getValue().isEmpty()) {
            context.report(MISSING, element, context.getLocation(element), "Missing `name` attribute in `<string>` declaration");
        } else {
            String name = attribute.getValue();
            Attr translatable = element.getAttributeNode("translatable");
            if (translatable != null && !Boolean.valueOf(translatable.getValue()).booleanValue()) {
                String l = LintUtils.getLocaleAndRegion(context.file.getParentFile().getName());
                if (l != null) {
                    context.report(EXTRA, translatable, context.getLocation(translatable), "Non-translatable resources should only be defined in the base `values/` folder");
                } else {
                    if (this.mNonTranslatable == null) {
                        this.mNonTranslatable = new HashSet<String>();
                    }
                    this.mNonTranslatable.add(name);
                }
                return;
            }
            if (element.getTagName().equals("string-array") && TranslationDetector.allItemsAreReferences(element)) {
                if (this.mTranslatedArrays == null) {
                    this.mTranslatedArrays = new HashSet<String>();
                }
                this.mTranslatedArrays.add(name);
                return;
            }
            this.mNames.add(name);
            if (this.mNonTranslatable != null && this.mNonTranslatable.contains(name)) {
                String message = String.format("The resource string \"`%1$s`\" has been marked as `translatable=\"false\"`", name);
                context.report(EXTRA, attribute, context.getLocation(attribute), message);
            }
        }
    }

    private static boolean allItemsAreReferences(Element element) {
        assert (element.getTagName().equals("string-array"));
        NodeList childNodes = element.getChildNodes();
        int n = childNodes.getLength();
        for (int i = 0; i < n; ++i) {
            Node item = childNodes.item(i);
            if (item.getNodeType() != 1 || !"item".equals(item.getNodeName())) continue;
            NodeList itemChildren = item.getChildNodes();
            int m = itemChildren.getLength();
            for (int j = 0; j < m; ++j) {
                String value;
                Node valueNode = itemChildren.item(j);
                if (valueNode.getNodeType() != 3 || (value = valueNode.getNodeValue().trim()).startsWith("@android:") || value.startsWith("@string/")) continue;
                return false;
            }
        }
        return true;
    }
}

