/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.dvcs.repo.RepositoryUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import git4idea.GitLocalBranch;
import git4idea.GitPlatformFacade;
import git4idea.GitUtil;
import git4idea.branch.GitBranchUiHandler;
import git4idea.commands.Git;
import git4idea.commands.GitMessageWithFilesDetector;
import git4idea.config.GitVcsSettings;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class GitBranchOperation {
    protected static final Logger LOG = Logger.getInstance(GitBranchOperation.class);
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final GitPlatformFacade myFacade;
    @NotNull
    protected final Git myGit;
    @NotNull
    protected final GitBranchUiHandler myUiHandler;
    @NotNull
    private final Collection<GitRepository> myRepositories;
    @NotNull
    protected final Map<GitRepository, String> myCurrentHeads;
    private final GitVcsSettings mySettings;
    @NotNull
    private final Collection<GitRepository> mySuccessfulRepositories;
    @NotNull
    private final Collection<GitRepository> myRemainingRepositories;

    protected GitBranchOperation(@NotNull Project project, @NotNull GitPlatformFacade facade, @NotNull Git git, @NotNull GitBranchUiHandler uiHandler, @NotNull Collection<GitRepository> repositories) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/branch/GitBranchOperation", "<init>"));
        }
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "git4idea/branch/GitBranchOperation", "<init>"));
        }
        if (git == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "git", "git4idea/branch/GitBranchOperation", "<init>"));
        }
        if (uiHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiHandler", "git4idea/branch/GitBranchOperation", "<init>"));
        }
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/branch/GitBranchOperation", "<init>"));
        }
        this.myProject = project;
        this.myFacade = facade;
        this.myGit = git;
        this.myUiHandler = uiHandler;
        this.myRepositories = repositories;
        this.myCurrentHeads = ContainerUtil.map2Map(repositories, (Function)new Function<GitRepository, Pair<GitRepository, String>>(){

            public Pair<GitRepository, String> fun(GitRepository repository) {
                GitLocalBranch currentBranch = repository.getCurrentBranch();
                return Pair.create((Object)repository, (Object)(currentBranch == null ? repository.getCurrentRevision() : currentBranch.getName()));
            }
        });
        this.mySuccessfulRepositories = new ArrayList<GitRepository>();
        this.myRemainingRepositories = new ArrayList<GitRepository>(this.myRepositories);
        this.mySettings = this.myFacade.getSettings(this.myProject);
    }

    protected abstract void execute();

    protected abstract void rollback();

    @NotNull
    public abstract String getSuccessMessage();

    @NotNull
    protected abstract String getRollbackProposal();

    @NotNull
    protected abstract String getOperationName();

    @NotNull
    protected GitRepository next() {
        GitRepository gitRepository = this.myRemainingRepositories.iterator().next();
        if (gitRepository == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitBranchOperation", "next"));
        }
        return gitRepository;
    }

    protected boolean hasMoreRepositories() {
        return !this.myRemainingRepositories.isEmpty();
    }

    protected void markSuccessful(GitRepository ... repositories) {
        for (GitRepository repository : repositories) {
            this.mySuccessfulRepositories.add(repository);
            this.myRemainingRepositories.remove(repository);
        }
    }

    protected boolean wereSuccessful() {
        return !this.mySuccessfulRepositories.isEmpty();
    }

    @NotNull
    protected Collection<GitRepository> getSuccessfulRepositories() {
        Collection<GitRepository> collection = this.mySuccessfulRepositories;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitBranchOperation", "getSuccessfulRepositories"));
        }
        return collection;
    }

    @NotNull
    protected String successfulRepositoriesJoined() {
        String string = StringUtil.join(this.mySuccessfulRepositories, (Function)new Function<GitRepository, String>(){

            public String fun(GitRepository repository) {
                return repository.getPresentableUrl();
            }
        }, (String)"<br/>");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitBranchOperation", "successfulRepositoriesJoined"));
        }
        return string;
    }

    @NotNull
    protected Collection<GitRepository> getRepositories() {
        Collection<GitRepository> collection = this.myRepositories;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitBranchOperation", "getRepositories"));
        }
        return collection;
    }

    @NotNull
    protected Collection<GitRepository> getRemainingRepositories() {
        Collection<GitRepository> collection = this.myRemainingRepositories;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitBranchOperation", "getRemainingRepositories"));
        }
        return collection;
    }

    @NotNull
    protected List<GitRepository> getRemainingRepositoriesExceptGiven(@NotNull GitRepository currentRepository) {
        if (currentRepository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentRepository", "git4idea/branch/GitBranchOperation", "getRemainingRepositoriesExceptGiven"));
        }
        ArrayList<GitRepository> repositories = new ArrayList<GitRepository>(this.myRemainingRepositories);
        repositories.remove(currentRepository);
        ArrayList<GitRepository> arrayList = repositories;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitBranchOperation", "getRemainingRepositoriesExceptGiven"));
        }
        return arrayList;
    }

    protected void notifySuccess(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "git4idea/branch/GitBranchOperation", "notifySuccess"));
        }
        VcsNotifier.getInstance((Project)this.myProject).notifySuccess(message);
    }

    protected final void notifySuccess() {
        this.notifySuccess(this.getSuccessMessage());
    }

    protected final void saveAllDocuments() {
        this.myFacade.saveAllDocuments();
    }

    protected void fatalError(@NotNull String title, @NotNull String message) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "git4idea/branch/GitBranchOperation", "fatalError"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "git4idea/branch/GitBranchOperation", "fatalError"));
        }
        if (this.wereSuccessful()) {
            this.showFatalErrorDialogWithRollback(title, message);
        } else {
            this.showFatalNotification(title, message);
        }
    }

    protected void showFatalErrorDialogWithRollback(@NotNull String title, @NotNull String message) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "git4idea/branch/GitBranchOperation", "showFatalErrorDialogWithRollback"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "git4idea/branch/GitBranchOperation", "showFatalErrorDialogWithRollback"));
        }
        boolean rollback = this.myUiHandler.notifyErrorWithRollbackProposal(title, message, this.getRollbackProposal());
        if (rollback) {
            this.rollback();
        }
    }

    protected void showFatalNotification(@NotNull String title, @NotNull String message) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "git4idea/branch/GitBranchOperation", "showFatalNotification"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "git4idea/branch/GitBranchOperation", "showFatalNotification"));
        }
        this.notifyError(title, message);
    }

    protected void notifyError(@NotNull String title, @NotNull String message) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "git4idea/branch/GitBranchOperation", "notifyError"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "git4idea/branch/GitBranchOperation", "notifyError"));
        }
        VcsNotifier.getInstance((Project)this.myProject).notifyError(title, message);
    }

    @NotNull
    protected ProgressIndicator getIndicator() {
        ProgressIndicator progressIndicator = this.myUiHandler.getProgressIndicator();
        if (progressIndicator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitBranchOperation", "getIndicator"));
        }
        return progressIndicator;
    }

    protected void fatalUnmergedFilesError() {
        if (this.wereSuccessful()) {
            this.showUnmergedFilesDialogWithRollback();
        } else {
            this.showUnmergedFilesNotification();
        }
    }

    @NotNull
    protected String repositories() {
        String string = StringUtil.pluralize((String)"repository", (int)this.getSuccessfulRepositories().size());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitBranchOperation", "repositories"));
        }
        return string;
    }

    protected void updateRecentBranch() {
        if (this.getRepositories().size() == 1) {
            GitRepository repository = this.myRepositories.iterator().next();
            this.mySettings.setRecentBranchOfRepository(repository.getRoot().getPath(), this.myCurrentHeads.get(repository));
        } else {
            String recentCommonBranch = this.getRecentCommonBranch();
            if (recentCommonBranch != null) {
                this.mySettings.setRecentCommonBranch(recentCommonBranch);
            }
        }
    }

    @Nullable
    private String getRecentCommonBranch() {
        String recentCommonBranch = null;
        for (String branch : this.myCurrentHeads.values()) {
            if (recentCommonBranch == null) {
                recentCommonBranch = branch;
                continue;
            }
            if (recentCommonBranch.equals(branch)) continue;
            return null;
        }
        return recentCommonBranch;
    }

    private void showUnmergedFilesDialogWithRollback() {
        boolean ok = this.myUiHandler.showUnmergedFilesMessageWithRollback(this.getOperationName(), this.getRollbackProposal());
        if (ok) {
            this.rollback();
        }
    }

    private void showUnmergedFilesNotification() {
        this.myUiHandler.showUnmergedFilesNotification(this.getOperationName(), this.getRepositories());
    }

    protected void refreshRoot(@NotNull GitRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/branch/GitBranchOperation", "refreshRoot"));
        }
        this.myFacade.hardRefresh(repository.getRoot());
    }

    protected void fatalLocalChangesError(@NotNull String reference) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "git4idea/branch/GitBranchOperation", "fatalLocalChangesError"));
        }
        String title = String.format("Couldn't %s %s", this.getOperationName(), reference);
        if (this.wereSuccessful()) {
            this.showFatalErrorDialogWithRollback(title, "");
        }
    }

    protected void fatalUntrackedFilesError(@NotNull VirtualFile root, @NotNull Collection<String> relativePaths) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/branch/GitBranchOperation", "fatalUntrackedFilesError"));
        }
        if (relativePaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePaths", "git4idea/branch/GitBranchOperation", "fatalUntrackedFilesError"));
        }
        if (this.wereSuccessful()) {
            this.showUntrackedFilesDialogWithRollback(root, relativePaths);
        } else {
            this.showUntrackedFilesNotification(root, relativePaths);
        }
    }

    private void showUntrackedFilesNotification(@NotNull VirtualFile root, @NotNull Collection<String> relativePaths) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/branch/GitBranchOperation", "showUntrackedFilesNotification"));
        }
        if (relativePaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePaths", "git4idea/branch/GitBranchOperation", "showUntrackedFilesNotification"));
        }
        this.myUiHandler.showUntrackedFilesNotification(this.getOperationName(), root, relativePaths);
    }

    private void showUntrackedFilesDialogWithRollback(@NotNull VirtualFile root, @NotNull Collection<String> relativePaths) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/branch/GitBranchOperation", "showUntrackedFilesDialogWithRollback"));
        }
        if (relativePaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePaths", "git4idea/branch/GitBranchOperation", "showUntrackedFilesDialogWithRollback"));
        }
        boolean ok = this.myUiHandler.showUntrackedFilesDialogWithRollback(this.getOperationName(), this.getRollbackProposal(), root, relativePaths);
        if (ok) {
            this.rollback();
        }
    }

    @NotNull
    Map<GitRepository, List<Change>> collectLocalChangesConflictingWithBranch(@NotNull Collection<GitRepository> repositories, @NotNull String currentBranch, @NotNull String otherBranch) {
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/branch/GitBranchOperation", "collectLocalChangesConflictingWithBranch"));
        }
        if (currentBranch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentBranch", "git4idea/branch/GitBranchOperation", "collectLocalChangesConflictingWithBranch"));
        }
        if (otherBranch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "otherBranch", "git4idea/branch/GitBranchOperation", "collectLocalChangesConflictingWithBranch"));
        }
        HashMap<GitRepository, List<Change>> changes = new HashMap<GitRepository, List<Change>>();
        for (GitRepository repository : repositories) {
            try {
                Collection<String> diff = GitUtil.getPathsDiffBetweenRefs(this.myGit, repository, currentBranch, otherBranch);
                List<Change> changesInRepo = GitUtil.findLocalChangesForPaths(this.myProject, repository.getRoot(), diff, false);
                if (changesInRepo.isEmpty()) continue;
                changes.put(repository, changesInRepo);
            }
            catch (VcsException e) {
                LOG.warn(String.format("Couldn't collect diff between %s and %s in %s", currentBranch, otherBranch, repository.getRoot()), (Throwable)e);
            }
        }
        HashMap<GitRepository, List<Change>> hashMap = changes;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitBranchOperation", "collectLocalChangesConflictingWithBranch"));
        }
        return hashMap;
    }

    @NotNull
    protected Pair<List<GitRepository>, List<Change>> getConflictingRepositoriesAndAffectedChanges(@NotNull GitRepository currentRepository, @NotNull GitMessageWithFilesDetector localChangesOverwrittenBy, String currentBranch, String nextBranch) {
        if (currentRepository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentRepository", "git4idea/branch/GitBranchOperation", "getConflictingRepositoriesAndAffectedChanges"));
        }
        if (localChangesOverwrittenBy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localChangesOverwrittenBy", "git4idea/branch/GitBranchOperation", "getConflictingRepositoriesAndAffectedChanges"));
        }
        List<Change> affectedChanges = GitUtil.findLocalChangesForPaths(this.myProject, currentRepository.getRoot(), localChangesOverwrittenBy.getRelativeFilePaths(), true);
        Map<GitRepository, List<Change>> conflictingChangesInRepositories = this.collectLocalChangesConflictingWithBranch(this.getRemainingRepositoriesExceptGiven(currentRepository), currentBranch, nextBranch);
        Set<GitRepository> otherProblematicRepositories = conflictingChangesInRepositories.keySet();
        ArrayList<GitRepository> allConflictingRepositories = new ArrayList<GitRepository>(otherProblematicRepositories);
        allConflictingRepositories.add(currentRepository);
        for (List<Change> changes : conflictingChangesInRepositories.values()) {
            affectedChanges.addAll(changes);
        }
        Pair pair = Pair.create(allConflictingRepositories, affectedChanges);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitBranchOperation", "getConflictingRepositoriesAndAffectedChanges"));
        }
        return pair;
    }

    @NotNull
    protected static String stringifyBranchesByRepos(@NotNull Map<GitRepository, String> heads) {
        if (heads == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "heads", "git4idea/branch/GitBranchOperation", "stringifyBranchesByRepos"));
        }
        MultiMap<String, VirtualFile> grouped = GitBranchOperation.groupByBranches(heads);
        if (grouped.size() == 1) {
            String string = (String)grouped.keySet().iterator().next();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitBranchOperation", "stringifyBranchesByRepos"));
            }
            return string;
        }
        String string = StringUtil.join((Collection)grouped.entrySet(), (Function)new Function<Map.Entry<String, Collection<VirtualFile>>, String>(){

            public String fun(Map.Entry<String, Collection<VirtualFile>> entry) {
                String roots = StringUtil.join(entry.getValue(), (Function)new Function<VirtualFile, String>(){

                    public String fun(VirtualFile file) {
                        return file.getName();
                    }
                }, (String)", ");
                return entry.getKey() + " (in " + roots + ")";
            }
        }, (String)"<br/>");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitBranchOperation", "stringifyBranchesByRepos"));
        }
        return string;
    }

    @NotNull
    private static MultiMap<String, VirtualFile> groupByBranches(@NotNull Map<GitRepository, String> heads) {
        if (heads == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "heads", "git4idea/branch/GitBranchOperation", "groupByBranches"));
        }
        MultiMap result = MultiMap.createLinked();
        List sortedRepos = RepositoryUtil.sortRepositories(heads.keySet());
        for (GitRepository repo : sortedRepos) {
            result.putValue((Object)heads.get(repo), (Object)repo.getRoot());
        }
        MultiMap multiMap = result;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitBranchOperation", "groupByBranches"));
        }
        return multiMap;
    }
}

