/*
 * Decompiled with CFR 0.152.
 */
package git4idea.changes;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ChangeListColumn;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.committed.DecoratorManager;
import com.intellij.openapi.vcs.changes.committed.VcsCommittedListsZipper;
import com.intellij.openapi.vcs.changes.committed.VcsCommittedViewAuxiliary;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.ChangesBrowserSettingsEditor;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.AsynchConsumer;
import com.intellij.util.Consumer;
import git4idea.GitFileRevision;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.changes.GitCommittedChangeList;
import git4idea.changes.GitRepositoryLocation;
import git4idea.changes.GitVersionFilterComponent;
import git4idea.commands.GitSimpleHandler;
import git4idea.history.GitHistoryUtils;
import git4idea.history.browser.GitHeavyCommit;
import git4idea.history.browser.SymbolicRefs;
import git4idea.repo.GitRepository;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitCommittedChangeListProvider
implements CommittedChangesProvider<CommittedChangeList, ChangeBrowserSettings> {
    private static final Logger LOG = Logger.getInstance(GitCommittedChangeListProvider.class);
    @NotNull
    private final Project myProject;

    public GitCommittedChangeListProvider(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/changes/GitCommittedChangeListProvider", "<init>"));
        }
        this.myProject = project;
    }

    @NotNull
    public ChangeBrowserSettings createDefaultSettings() {
        ChangeBrowserSettings changeBrowserSettings = new ChangeBrowserSettings();
        if (changeBrowserSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/changes/GitCommittedChangeListProvider", "createDefaultSettings"));
        }
        return changeBrowserSettings;
    }

    public ChangesBrowserSettingsEditor<ChangeBrowserSettings> createFilterUI(boolean showDateFilter) {
        return new GitVersionFilterComponent(showDateFilter);
    }

    public RepositoryLocation getLocationFor(@NotNull FilePath root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/changes/GitCommittedChangeListProvider", "getLocationFor"));
        }
        VirtualFile gitRoot = GitUtil.getGitRootOrNull(root);
        if (gitRoot == null) {
            return null;
        }
        GitRepository repository = (GitRepository)GitUtil.getRepositoryManager(this.myProject).getRepositoryForRoot(gitRoot);
        if (repository == null) {
            LOG.info("No GitRepository for " + gitRoot);
            return null;
        }
        GitLocalBranch currentBranch = repository.getCurrentBranch();
        if (currentBranch == null) {
            return null;
        }
        GitRemoteBranch trackedBranch = currentBranch.findTrackedBranch(repository);
        if (trackedBranch == null) {
            return null;
        }
        File rootFile = new File(gitRoot.getPath());
        return new GitRepositoryLocation(trackedBranch.getRemote().getFirstUrl(), rootFile);
    }

    public RepositoryLocation getLocationFor(FilePath root, String repositoryPath) {
        return this.getLocationFor(root);
    }

    @Nullable
    public VcsCommittedListsZipper getZipper() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCommittedChanges(ChangeBrowserSettings settings, RepositoryLocation location, int maxCount, final AsynchConsumer<CommittedChangeList> consumer) throws VcsException {
        try {
            this.getCommittedChangesImpl(settings, location, maxCount, new Consumer<GitCommittedChangeList>(){

                public void consume(GitCommittedChangeList gitCommittedChangeList) {
                    consumer.consume((Object)gitCommittedChangeList);
                }
            });
        }
        finally {
            consumer.finished();
        }
    }

    public List<CommittedChangeList> getCommittedChanges(ChangeBrowserSettings settings, RepositoryLocation location, int maxCount) throws VcsException {
        final ArrayList<CommittedChangeList> result = new ArrayList<CommittedChangeList>();
        this.getCommittedChangesImpl(settings, location, maxCount, new Consumer<GitCommittedChangeList>(){

            public void consume(GitCommittedChangeList committedChangeList) {
                result.add(committedChangeList);
            }
        });
        return result;
    }

    private void getCommittedChangesImpl(ChangeBrowserSettings settings, RepositoryLocation location, final int maxCount, Consumer<GitCommittedChangeList> consumer) throws VcsException {
        GitRepositoryLocation l = (GitRepositoryLocation)location;
        final Long beforeRev = settings.getChangeBeforeFilter();
        final Long afterRev = settings.getChangeAfterFilter();
        final Date beforeDate = settings.getDateBeforeFilter();
        final Date afterDate = settings.getDateAfterFilter();
        final String author = settings.getUserFilter();
        VirtualFile root = LocalFileSystem.getInstance().findFileByIoFile(l.getRoot());
        if (root == null) {
            throw new VcsException("The repository does not exists anymore: " + l.getRoot());
        }
        GitUtil.getLocalCommittedChanges(this.myProject, root, new Consumer<GitSimpleHandler>(){

            public void consume(GitSimpleHandler h) {
                if (!StringUtil.isEmpty((String)author)) {
                    h.addParameters("--author=" + author);
                }
                if (beforeDate != null) {
                    h.addParameters("--before=" + GitUtil.gitTime(beforeDate));
                }
                if (afterDate != null) {
                    h.addParameters("--after=" + GitUtil.gitTime(afterDate));
                }
                if (maxCount != GitCommittedChangeListProvider.this.getUnlimitedCountValue()) {
                    h.addParameters("-n" + maxCount);
                }
                if (beforeRev != null && afterRev != null) {
                    h.addParameters(GitUtil.formatLongRev(afterRev) + ".." + GitUtil.formatLongRev(beforeRev));
                } else if (beforeRev != null) {
                    h.addParameters(GitUtil.formatLongRev(beforeRev));
                } else if (afterRev != null) {
                    h.addParameters(GitUtil.formatLongRev(afterRev) + "..");
                }
            }
        }, consumer, false);
    }

    public ChangeListColumn[] getColumns() {
        return new ChangeListColumn[]{ChangeListColumn.NUMBER, ChangeListColumn.DATE, ChangeListColumn.DESCRIPTION, ChangeListColumn.NAME};
    }

    public VcsCommittedViewAuxiliary createActions(DecoratorManager manager, RepositoryLocation location) {
        return null;
    }

    public int getUnlimitedCountValue() {
        return -1;
    }

    public Pair<CommittedChangeList, FilePath> getOneList(VirtualFile file, VcsRevisionNumber number) throws VcsException {
        FilePathImpl filePath = new FilePathImpl(file);
        List<GitHeavyCommit> gitCommits = GitHistoryUtils.commitsDetails(this.myProject, (FilePath)filePath, new SymbolicRefs(), Collections.singletonList(number.asString()));
        if (gitCommits.size() != 1) {
            return null;
        }
        GitHeavyCommit gitCommit = gitCommits.get(0);
        GitCommittedChangeList commit = new GitCommittedChangeList(gitCommit.getDescription() + " (" + gitCommit.getShortHash().getString() + ")", gitCommit.getDescription(), gitCommit.getAuthor(), (GitRevisionNumber)number, new Date(gitCommit.getAuthorTime()), gitCommit.getChanges(), true);
        Collection changes = commit.getChanges();
        if (changes.size() == 1) {
            Change change = (Change)changes.iterator().next();
            return Pair.create((Object)((Object)commit), (Object)ChangesUtil.getFilePath((Change)change));
        }
        for (Change change : changes) {
            if (change.getAfterRevision() == null || !FileUtil.filesEqual((File)filePath.getIOFile(), (File)change.getAfterRevision().getFile().getIOFile())) continue;
            return new Pair((Object)commit, (Object)filePath);
        }
        String afterTime = "--after=" + GitUtil.gitTime(gitCommit.getDate());
        List<VcsFileRevision> history = GitHistoryUtils.history(this.myProject, (FilePath)filePath, null, afterTime);
        if (history.isEmpty()) {
            return new Pair((Object)commit, (Object)filePath);
        }
        return Pair.create((Object)((Object)commit), (Object)((GitFileRevision)history.get(history.size() - 1)).getPath());
    }

    public RepositoryLocation getForNonLocal(VirtualFile file) {
        return null;
    }

    public boolean supportsIncomingChanges() {
        return false;
    }
}

