/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.process.DefaultJavaProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.MavenExecutor;
import org.jetbrains.idea.maven.execution.MavenExternalParameters;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.execution.RunnerBundle;
import org.jetbrains.idea.maven.project.MavenConsole;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;

public class MavenExternalExecutor
extends MavenExecutor {
    private OSProcessHandler myProcessHandler;
    @NonNls
    private static final String PHASE_INFO_REGEXP = "\\[INFO\\] \\[.*:.*\\]";
    @NonNls
    private static final int INFO_PREFIX_SIZE = "[INFO] ".length();
    private JavaParameters myJavaParameters;
    private ExecutionException myParameterCreationError;

    public MavenExternalExecutor(Project project, @NotNull MavenRunnerParameters parameters, @Nullable MavenGeneralSettings coreSettings, @Nullable MavenRunnerSettings runnerSettings, @NotNull MavenConsole console) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/idea/maven/execution/MavenExternalExecutor", "<init>"));
        }
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "org/jetbrains/idea/maven/execution/MavenExternalExecutor", "<init>"));
        }
        super(parameters, RunnerBundle.message("external.executor.caption", new Object[0]), console);
        try {
            this.myJavaParameters = MavenExternalParameters.createJavaParameters(project, this.myParameters, coreSettings, runnerSettings);
        }
        catch (ExecutionException e) {
            this.myParameterCreationError = e;
        }
    }

    @Override
    public boolean execute(final ProgressIndicator indicator) {
        this.displayProgress();
        try {
            if (this.myParameterCreationError != null) {
                throw this.myParameterCreationError;
            }
            this.myProcessHandler = new DefaultJavaProcessHandler(this.myJavaParameters){

                public void notifyTextAvailable(String text, Key outputType) {
                    if (!MavenExternalExecutor.this.myConsole.isSuppressed(text)) {
                        super.notifyTextAvailable(text, outputType);
                    }
                    MavenExternalExecutor.this.updateProgress(indicator, text);
                }
            };
            this.myConsole.attachToProcess((ProcessHandler)this.myProcessHandler);
        }
        catch (ExecutionException e) {
            this.myConsole.systemMessage(4, RunnerBundle.message("external.startup.failed", e.getMessage()), null);
            return false;
        }
        this.start();
        this.readProcessOutput();
        this.stop();
        return this.printExitSummary();
    }

    @Override
    void stop() {
        if (this.myProcessHandler != null) {
            this.myProcessHandler.destroyProcess();
            this.myProcessHandler.waitFor();
            this.setExitCode(this.myProcessHandler.getProcess().exitValue());
        }
        super.stop();
    }

    private void readProcessOutput() {
        this.myProcessHandler.startNotify();
        this.myProcessHandler.waitFor();
    }

    private void updateProgress(@Nullable ProgressIndicator indicator, String text) {
        if (indicator != null) {
            if (indicator.isCanceled() && !this.isCancelled()) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MavenExternalExecutor.this.cancel();
                    }
                });
            }
            if (text.matches(PHASE_INFO_REGEXP)) {
                indicator.setText2(text.substring(INFO_PREFIX_SIZE));
            }
        }
    }
}

