/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.LocalFileOperationsHandler;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThrowableConsumer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnFileSystemListener;

public class SvnFileSystemListenerWrapper {
    private final LocalFileOperationsHandler myProxy;
    private final CommandListener myListener;

    public SvnFileSystemListenerWrapper(SvnFileSystemListener delegate) {
        MyCommandListener listener = new MyCommandListener(delegate);
        this.myListener = listener;
        MyStorage storage = new MyStorage(listener);
        this.myProxy = (LocalFileOperationsHandler)Proxy.newProxyInstance(LocalFileOperationsHandler.class.getClassLoader(), new Class[]{LocalFileOperationsHandler.class}, (InvocationHandler)new MyInvoker(storage, (Object)delegate));
    }

    public void registerSelf() {
        LocalFileSystem.getInstance().registerAuxiliaryFileOperationsHandler(this.myProxy);
        CommandProcessor.getInstance().addCommandListener(this.myListener);
    }

    public void unregisterSelf() {
        LocalFileSystem.getInstance().unregisterAuxiliaryFileOperationsHandler(this.myProxy);
        CommandProcessor.getInstance().removeCommandListener(this.myListener);
    }

    private static class MyInvoker
    implements InvocationHandler {
        private final Object myDelegate;
        private final MyStorage myParent;
        private final LocalFileOperationsHandler myParentProxy;

        private MyInvoker(MyStorage parent, Object delegate) {
            this.myParent = parent;
            this.myDelegate = delegate;
            this.myParentProxy = (LocalFileOperationsHandler)Proxy.newProxyInstance(LocalFileOperationsHandler.class.getClassLoader(), new Class[]{LocalFileOperationsHandler.class}, (InvocationHandler)this.myParent);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("afterDone".equals(method.getName()) && args.length == 1) {
                ((ThrowableConsumer)args[0]).consume((Object)this.myParentProxy);
                return null;
            }
            if (LocalFileOperationsHandler.class.equals(method.getDeclaringClass())) {
                this.myParent.register(method, args);
            }
            if ("equals".equals(method.getName())) {
                return args[0].equals(this);
            }
            if ("hashCode".equals(method.getName())) {
                return 1;
            }
            return method.invoke(this.myDelegate, args);
        }
    }

    private static class MyStorage
    implements InvocationHandler {
        private final MyMarker myMarker;
        private final Map<Project, Pair<String, Object[]>> myStarted;

        private MyStorage(MyMarker marker) {
            this.myMarker = marker;
            this.myStarted = new HashMap<Project, Pair<String, Object[]>>();
        }

        @Nullable
        private static Project getProject(Object[] args) {
            for (Object arg : args) {
                if (!(arg instanceof VirtualFile)) continue;
                return ProjectLocator.getInstance().guessProjectForFile((VirtualFile)arg);
            }
            return null;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Pair<String, Object[]> pair;
            Project project = MyStorage.getProject(args);
            if (project != null && (pair = this.myStarted.get(project)) != null && method.getName().equals(pair.getFirst()) && Arrays.equals(args, (Object[])pair.getSecond())) {
                this.myMarker.finish(project);
            }
            return "boolean".equals(method.getReturnType().getName()) ? Boolean.TRUE : null;
        }

        private void register(Method method, Object[] args) {
            Object[] newArr = new Object[args.length];
            System.arraycopy(args, 0, newArr, 0, args.length);
            final Project project = MyStorage.getProject(args);
            if (project != null) {
                this.myMarker.start(project);
                this.myStarted.put(project, (Pair<String, Object[]>)Pair.create((Object)method.getName(), (Object)newArr));
                Disposer.register((Disposable)project, (Disposable)new Disposable(){

                    public void dispose() {
                        MyStorage.this.myStarted.remove(project);
                    }
                });
            }
        }
    }

    private static interface MyMarker {
        public void start(Project var1);

        public void finish(Project var1);
    }

    private static class MyCommandListener
    implements CommandListener,
    MyMarker {
        private volatile boolean myInCommand;
        private final SvnFileSystemListener myDelegate;

        public MyCommandListener(SvnFileSystemListener delegate) {
            this.myDelegate = delegate;
        }

        @Override
        public void start(Project project) {
            if (!this.myInCommand && project != null) {
                this.myDelegate.commandStarted(project);
            }
        }

        @Override
        public void finish(Project project) {
            if (!this.myInCommand && project != null) {
                this.myDelegate.commandFinished(project);
            }
        }

        public void commandStarted(CommandEvent event) {
            this.myInCommand = true;
            this.myDelegate.commandStarted(event);
        }

        public void beforeCommandFinished(CommandEvent event) {
            this.myDelegate.beforeCommandFinished(event);
        }

        public void commandFinished(CommandEvent event) {
            this.myInCommand = false;
            this.myDelegate.commandFinished(event);
        }

        public void undoTransparentActionStarted() {
            this.myDelegate.undoTransparentActionStarted();
        }

        public void undoTransparentActionFinished() {
            this.myDelegate.undoTransparentActionFinished();
        }
    }
}

