/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.ObjectsConvertor;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.DottedBorder;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.util.Consumer;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.continuation.TaskDescriptor;
import com.intellij.util.io.EqualityPolicy;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.NestedCopyType;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopiesContent;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.actions.CleanupWorker;
import org.jetbrains.idea.svn.api.ClientFactory;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.branchConfig.BranchConfigurationDialog;
import org.jetbrains.idea.svn.branchConfig.SelectBranchPopup;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;
import org.jetbrains.idea.svn.checkout.SvnCheckoutProvider;
import org.jetbrains.idea.svn.dialogs.ChangeFormatDialog;
import org.jetbrains.idea.svn.dialogs.SvnFormatWorker;
import org.jetbrains.idea.svn.dialogs.WCInfo;
import org.jetbrains.idea.svn.integrate.MergeContext;
import org.jetbrains.idea.svn.integrate.QuickMerge;
import org.jetbrains.idea.svn.integrate.QuickMergeInteractionImpl;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class CopiesPanel {
    private static final Logger LOG = Logger.getInstance(CopiesPanel.class);
    private static final NotificationGroup NOTIFICATION_GROUP = new NotificationGroup("Svn Roots Detection Errors", NotificationDisplayType.STICKY_BALLOON, true);
    private final Project myProject;
    private MessageBusConnection myConnection;
    private SvnVcs myVcs;
    private JPanel myPanel;
    private JComponent myHolder;
    private LinkLabel myRefreshLabel;
    private List<OverrideEqualsWrapper<WCInfo>> myCurrentInfoList;
    private int myTextHeight;
    private static final String CHANGE_FORMAT = "CHANGE_FORMAT";
    private static final String CLEANUP = "CLEANUP";
    private static final String FIX_DEPTH = "FIX_DEPTH";
    private static final String CONFIGURE_BRANCHES = "CONFIGURE_BRANCHES";
    private static final String MERGE_FROM = "MERGE_FROM";

    public CopiesPanel(Project project) {
        this.myProject = project;
        this.myConnection = this.myProject.getMessageBus().connect((Disposable)this.myProject);
        this.myVcs = SvnVcs.getInstance(this.myProject);
        this.myCurrentInfoList = null;
        final Runnable focus = new Runnable(){

            @Override
            public void run() {
                IdeFocusManager.getInstance((Project)CopiesPanel.this.myProject).requestFocus((Component)CopiesPanel.this.myRefreshLabel, true);
            }
        };
        final Runnable refreshView = new Runnable(){

            @Override
            public void run() {
                final List<WCInfo> infoList = CopiesPanel.this.myVcs.getWcInfosWithErrors();
                final boolean hasErrors = !CopiesPanel.this.myVcs.getSvnFileUrlMapping().getErrorRoots().isEmpty();
                final List supportedFormats = CopiesPanel.this.getSupportedFormats();
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        if (CopiesPanel.this.myCurrentInfoList != null) {
                            List newList = ObjectsConvertor.convert((Collection)infoList, (Convertor)new Convertor<WCInfo, OverrideEqualsWrapper<WCInfo>>(){

                                public OverrideEqualsWrapper<WCInfo> convert(WCInfo o) {
                                    return new OverrideEqualsWrapper<WCInfo>(InfoEqualityPolicy.getInstance(), o);
                                }
                            }, (NotNullFunction)ObjectsConvertor.NOT_NULL);
                            if (Comparing.haveEqualElements((Collection)newList, (Collection)CopiesPanel.this.myCurrentInfoList)) {
                                CopiesPanel.this.myRefreshLabel.setEnabled(true);
                                return;
                            }
                            CopiesPanel.this.myCurrentInfoList = newList;
                        }
                        Collections.sort(infoList, WCComparator.getInstance());
                        CopiesPanel.this.updateList(infoList, supportedFormats);
                        CopiesPanel.this.myRefreshLabel.setEnabled(true);
                        CopiesPanel.this.showErrorNotification(hasErrors);
                        SwingUtilities.invokeLater(focus);
                    }
                };
                ApplicationManager.getApplication().invokeLater(runnable, ModalityState.NON_MODAL);
            }
        };
        Consumer<Boolean> refreshOnPooled = new Consumer<Boolean>(){

            public void consume(Boolean somethingNew) {
                if (Boolean.TRUE.equals(somethingNew)) {
                    if (ApplicationManager.getApplication().isUnitTestMode()) {
                        refreshView.run();
                    } else {
                        ApplicationManager.getApplication().executeOnPooledThread(refreshView);
                    }
                } else {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CopiesPanel.this.myRefreshLabel.setEnabled(true);
                        }
                    }, ModalityState.NON_MODAL);
                }
            }
        };
        this.myConnection.subscribe(SvnVcs.ROOTS_RELOADED, (Object)refreshOnPooled);
        JPanel holderPanel = new JPanel(new BorderLayout());
        FontMetrics fm = holderPanel.getFontMetrics(holderPanel.getFont());
        this.myTextHeight = (int)((double)fm.getHeight() * 1.3);
        this.myPanel = new JPanel(new GridBagLayout());
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.myPanel, "North");
        holderPanel.add((Component)panel, "West");
        this.myRefreshLabel = new MyLinkLabel(this.myTextHeight, "Refresh", new LinkListener(){

            public void linkSelected(LinkLabel aSource, Object aLinkData) {
                if (CopiesPanel.this.myRefreshLabel.isEnabled()) {
                    CopiesPanel.this.myVcs.invokeRefreshSvnRoots();
                    CopiesPanel.this.myRefreshLabel.setEnabled(false);
                }
            }
        });
        JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)holderPanel);
        this.myHolder = pane;
        JScrollBar vBar = pane.getVerticalScrollBar();
        vBar.setBlockIncrement(vBar.getBlockIncrement() * 5);
        vBar.setUnitIncrement(vBar.getUnitIncrement() * 5);
        this.myHolder.setBorder(null);
        this.setFocusableForLinks(this.myRefreshLabel);
        refreshOnPooled.consume((Object)true);
        this.initView();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myRefreshLabel;
    }

    private void updateList(@NotNull List<WCInfo> infoList, @NotNull List<WorkingCopyFormat> supportedFormats) {
        if (infoList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infoList", "org/jetbrains/idea/svn/dialogs/CopiesPanel", "updateList"));
        }
        if (supportedFormats == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supportedFormats", "org/jetbrains/idea/svn/dialogs/CopiesPanel", "updateList"));
        }
        this.myPanel.removeAll();
        Insets nullIndent = new Insets(1, 3, 1, 0);
        GridBagConstraints gb = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 2, 0, 0), 0, 0);
        gb.insets.left = 4;
        this.myPanel.add((Component)this.myRefreshLabel, gb);
        gb.insets.left = 1;
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        Insets topIndent = new Insets(10, 3, 0, 0);
        for (final WCInfo wcInfo : infoList) {
            final Set<WorkingCopyFormat> upgradeFormats = CopiesPanel.getUpgradeFormats(wcInfo, supportedFormats);
            VirtualFile vf = lfs.refreshAndFindFileByIoFile(new File(wcInfo.getPath()));
            final VirtualFile root = vf == null ? wcInfo.getVcsRoot() : vf;
            final JEditorPane editorPane = new JEditorPane("text/html", "");
            editorPane.setEditable(false);
            editorPane.setFocusable(true);
            editorPane.setBackground(UIUtil.getPanelBackground());
            editorPane.setOpaque(false);
            editorPane.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        if (CopiesPanel.CONFIGURE_BRANCHES.equals(e.getDescription())) {
                            if (!this.checkRoot(root, wcInfo.getPath(), " invoke Configure Branches")) {
                                return;
                            }
                            BranchConfigurationDialog.configureBranches(CopiesPanel.this.myProject, root, true);
                        } else if (CopiesPanel.FIX_DEPTH.equals(e.getDescription())) {
                            int result = Messages.showOkCancelDialog((Project)CopiesPanel.this.myVcs.getProject(), (String)("You are going to checkout into '" + wcInfo.getPath() + "' with 'infinity' depth.\n" + "This will update your working copy to HEAD revision as well."), (String)"Set Working Copy Infinity Depth", (Icon)Messages.getWarningIcon());
                            if (result == 0) {
                                SvnCheckoutProvider.checkout(CopiesPanel.this.myVcs.getProject(), new File(wcInfo.getPath()), wcInfo.getRootUrl(), SVNRevision.HEAD, Depth.INFINITY, false, null, wcInfo.getFormat());
                            }
                        } else if (CopiesPanel.CHANGE_FORMAT.equals(e.getDescription())) {
                            CopiesPanel.this.changeFormat(wcInfo, upgradeFormats);
                        } else if (CopiesPanel.MERGE_FROM.equals(e.getDescription())) {
                            if (!this.checkRoot(root, wcInfo.getPath(), " invoke Merge From")) {
                                return;
                            }
                            CopiesPanel.this.mergeFrom(wcInfo, root, editorPane);
                        } else if (CopiesPanel.CLEANUP.equals(e.getDescription())) {
                            if (!this.checkRoot(root, wcInfo.getPath(), " invoke Cleanup")) {
                                return;
                            }
                            new CleanupWorker(new VirtualFile[]{root}, CopiesPanel.this.myVcs.getProject(), "action.Subversion.cleanup.progress.title").execute();
                        }
                    }
                }

                private boolean checkRoot(VirtualFile root2, String path, String actionName) {
                    if (root2 == null) {
                        Messages.showWarningDialog((Project)CopiesPanel.this.myProject, (String)("Invalid working copy root: " + path), (String)("Can not " + actionName));
                        return false;
                    }
                    return true;
                }
            });
            editorPane.setBorder(null);
            editorPane.setText(this.formatWc(wcInfo, upgradeFormats));
            JPanel copyPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gb1 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, nullIndent, 0, 0);
            gb1.insets.top = 1;
            gb1.gridwidth = 3;
            gb.insets = topIndent;
            gb.fill = 2;
            ++gb.gridy;
            JPanel contForCopy = new JPanel(new BorderLayout());
            contForCopy.add((Component)copyPanel, "West");
            this.myPanel.add((Component)contForCopy, gb);
            copyPanel.add((Component)editorPane, gb1);
            gb1.insets = nullIndent;
        }
        this.myPanel.revalidate();
        this.myPanel.repaint();
    }

    private String formatWc(@NotNull WCInfo info, @NotNull Collection<WorkingCopyFormat> upgradeFormats) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/idea/svn/dialogs/CopiesPanel", "formatWc"));
        }
        if (upgradeFormats == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "upgradeFormats", "org/jetbrains/idea/svn/dialogs/CopiesPanel", "formatWc"));
        }
        StringBuilder sb = new StringBuilder().append("<html><head>").append(UIUtil.getCssFontDeclaration((Font)UIUtil.getLabelFont())).append("</head><body><table bgColor=\"").append(ColorUtil.toHex((Color)UIUtil.getPanelBackground())).append("\">");
        sb.append("<tr valign=\"top\"><td colspan=\"3\"><b>").append(info.getPath()).append("</b></td></tr>");
        if (info.hasError()) {
            sb.append("<tr valign=\"top\"><td>URL:</td><td colspan=\"2\" color=\"").append(ColorUtil.toHex((Color)JBColor.red)).append("\">").append(info.getErrorMessage()).append("</td></tr>");
        } else {
            sb.append("<tr valign=\"top\"><td>URL:</td><td colspan=\"2\">").append(info.getRootUrl()).append("</td></tr>");
        }
        if (upgradeFormats.size() > 1) {
            sb.append("<tr valign=\"top\"><td>Format:</td><td>").append(info.getFormat().getName()).append("</td><td><a href=\"").append(CHANGE_FORMAT).append("\">Change</a></td></tr>");
        } else {
            sb.append("<tr valign=\"top\"><td>Format:</td><td colspan=\"2\">").append(info.getFormat().getName()).append("</td></tr>");
        }
        if (!Depth.INFINITY.equals((Object)info.getStickyDepth()) && !info.hasError()) {
            sb.append("<tr valign=\"top\"><td>Depth:</td><td>").append(info.getStickyDepth().getName()).append("</td><td><a href=\"").append(FIX_DEPTH).append("\">Fix</a></td></tr>");
        } else {
            sb.append("<tr valign=\"top\"><td>Depth:</td><td colspan=\"2\">").append(info.getStickyDepth().getName()).append("</td></tr>");
        }
        NestedCopyType type = info.getType();
        if (NestedCopyType.external.equals((Object)type) || NestedCopyType.switched.equals((Object)type)) {
            sb.append("<tr valign=\"top\"><td colspan=\"3\"><i>").append(type.getName()).append("</i></td></tr>");
        }
        if (info.isIsWcRoot()) {
            sb.append("<tr valign=\"top\"><td colspan=\"3\"><i>").append("Working copy root</i></td></tr>");
        }
        if (!info.hasError()) {
            if (info.getFormat().isOrGreater(WorkingCopyFormat.ONE_DOT_SEVEN)) {
                sb.append("<tr valign=\"top\"><td colspan=\"3\"><a href=\"").append(CLEANUP).append("\">Cleanup</a></td></tr>");
            }
            sb.append("<tr valign=\"top\"><td colspan=\"3\"><a href=\"").append(CONFIGURE_BRANCHES).append("\">Configure Branches</a></td></tr>");
            sb.append("<tr valign=\"top\"><td colspan=\"3\"><a href=\"").append(MERGE_FROM).append("\"><b>Merge From...</b></a></i></td></tr>");
            sb.append("</table></body></html>");
        }
        return sb.toString();
    }

    @NotNull
    private List<WorkingCopyFormat> getSupportedFormats() {
        ArrayList result = ContainerUtil.newArrayList();
        ClientFactory factory = this.myVcs.getFactory();
        ClientFactory otherFactory = this.myVcs.getOtherFactory(factory);
        try {
            result.addAll(factory.createUpgradeClient().getSupportedFormats());
            result.addAll(SvnFormatWorker.getOtherFactoryFormats(otherFactory));
        }
        catch (VcsException e) {
            LOG.info((Throwable)e);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/dialogs/CopiesPanel", "getSupportedFormats"));
        }
        return arrayList;
    }

    public static Set<WorkingCopyFormat> getUpgradeFormats(@NotNull WCInfo info, @NotNull List<WorkingCopyFormat> supportedFormats) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/idea/svn/dialogs/CopiesPanel", "getUpgradeFormats"));
        }
        if (supportedFormats == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supportedFormats", "org/jetbrains/idea/svn/dialogs/CopiesPanel", "getUpgradeFormats"));
        }
        EnumSet<WorkingCopyFormat> canUpgradeTo = EnumSet.noneOf(WorkingCopyFormat.class);
        for (WorkingCopyFormat format : supportedFormats) {
            if (!format.isOrGreater(info.getFormat())) continue;
            canUpgradeTo.add(format);
        }
        canUpgradeTo.add(info.getFormat());
        return canUpgradeTo;
    }

    private void mergeFrom(final @NotNull WCInfo wcInfo, final @NotNull VirtualFile root, @Nullable Component mergeLabel) {
        if (wcInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wcInfo", "org/jetbrains/idea/svn/dialogs/CopiesPanel", "mergeFrom"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/idea/svn/dialogs/CopiesPanel", "mergeFrom"));
        }
        SelectBranchPopup.showForBranchRoot(this.myProject, root, new SelectBranchPopup.BranchSelectedCallback(){

            @Override
            public void branchSelected(Project project, SvnBranchConfigurationNew configuration, String url, long revision) {
                new QuickMerge(new MergeContext(CopiesPanel.this.myVcs, url, wcInfo, SVNPathUtil.tail((String)url), root)).execute(new QuickMergeInteractionImpl(CopiesPanel.this.myProject), new TaskDescriptor[0]);
            }
        }, "Select branch", mergeLabel);
    }

    private void setFocusableForLinks(final LinkLabel label) {
        DottedBorder border = new DottedBorder(new Insets(1, 2, 1, 1), (Color)JBColor.BLACK);
        label.setFocusable(true);
        label.addFocusListener((FocusListener)new FocusAdapter((Border)border){
            final /* synthetic */ Border val$border;
            {
                this.val$border = border;
            }

            @Override
            public void focusGained(FocusEvent e) {
                super.focusGained(e);
                label.setBorder(this.val$border);
            }

            @Override
            public void focusLost(FocusEvent e) {
                super.focusLost(e);
                label.setBorder(null);
            }
        });
        label.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (10 == e.getKeyCode()) {
                    label.doClick();
                }
            }
        });
    }

    private void changeFormat(@NotNull WCInfo wcInfo, @NotNull Collection<WorkingCopyFormat> supportedFormats) {
        if (wcInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wcInfo", "org/jetbrains/idea/svn/dialogs/CopiesPanel", "changeFormat"));
        }
        if (supportedFormats == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supportedFormats", "org/jetbrains/idea/svn/dialogs/CopiesPanel", "changeFormat"));
        }
        ChangeFormatDialog dialog = new ChangeFormatDialog(this.myProject, new File(wcInfo.getPath()), false, !wcInfo.isIsWcRoot());
        dialog.setSupported(supportedFormats);
        dialog.setData(wcInfo.getFormat());
        dialog.show();
        if (!dialog.isOK()) {
            return;
        }
        WorkingCopyFormat newFormat = dialog.getUpgradeMode();
        if (!wcInfo.getFormat().equals((Object)newFormat)) {
            ApplicationManager.getApplication().saveAll();
            SvnFormatWorker task = new SvnFormatWorker(this.myProject, newFormat, wcInfo){

                @Override
                public void onSuccess() {
                    super.onSuccess();
                    CopiesPanel.this.myRefreshLabel.doClick();
                }
            };
            ProgressManager.getInstance().run((Task)task);
        }
    }

    private void initView() {
        this.myRefreshLabel.doClick();
    }

    private void showErrorNotification(boolean hasErrors) {
        NotificationsManager manager = NotificationsManager.getNotificationsManager();
        ErrorsFoundNotification[] notifications = (ErrorsFoundNotification[])manager.getNotificationsOfType(ErrorsFoundNotification.class, this.myProject);
        if (hasErrors) {
            if (notifications.length == 0) {
                new ErrorsFoundNotification(this.myProject).notify(this.myProject.isDefault() ? null : this.myProject);
            }
        } else {
            for (ErrorsFoundNotification notification : notifications) {
                notification.expire();
            }
        }
    }

    public JComponent getComponent() {
        return this.myHolder;
    }

    private static class ErrorsFoundNotification
    extends Notification {
        private static final String FIX_ACTION = "FIX";
        private static final String TITLE = "";
        private static final String DESCRIPTION = SvnBundle.message("subversion.roots.detection.errors.found.description", new Object[0]);

        private ErrorsFoundNotification(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/svn/dialogs/CopiesPanel$ErrorsFoundNotification", "<init>"));
            }
            super(NOTIFICATION_GROUP.getDisplayId(), TITLE, DESCRIPTION, NotificationType.ERROR, (NotificationListener)ErrorsFoundNotification.createListener(project));
        }

        private static NotificationListener.Adapter createListener(final @NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/svn/dialogs/CopiesPanel$ErrorsFoundNotification", "createListener"));
            }
            return new NotificationListener.Adapter(){

                protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                    if (notification == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "org/jetbrains/idea/svn/dialogs/CopiesPanel$ErrorsFoundNotification$1", "hyperlinkActivated"));
                    }
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/idea/svn/dialogs/CopiesPanel$ErrorsFoundNotification$1", "hyperlinkActivated"));
                    }
                    if (ErrorsFoundNotification.FIX_ACTION.equals(event.getDescription())) {
                        WorkingCopiesContent.show(project);
                    }
                }
            };
        }
    }

    private static class MyLinkLabel
    extends LinkLabel {
        private final int myHeight;

        public MyLinkLabel(int height, String text, LinkListener linkListener) {
            super(text, null, linkListener);
            this.myHeight = height;
        }

        public Dimension getPreferredSize() {
            Dimension preferredSize = super.getPreferredSize();
            return new Dimension(preferredSize.width, this.myHeight);
        }
    }

    private static class WCComparator
    implements Comparator<WCInfo> {
        private static final WCComparator ourComparator = new WCComparator();

        private WCComparator() {
        }

        public static WCComparator getInstance() {
            return ourComparator;
        }

        @Override
        public int compare(WCInfo o1, WCInfo o2) {
            return o1.getPath().compareTo(o2.getPath());
        }
    }

    private static class InfoEqualityPolicy
    implements EqualityPolicy<WCInfo> {
        private static final InfoEqualityPolicy ourInstance = new InfoEqualityPolicy();

        private InfoEqualityPolicy() {
        }

        public static InfoEqualityPolicy getInstance() {
            return ourInstance;
        }

        public int getHashCode(WCInfo value) {
            HashCodeBuilder builder = new HashCodeBuilder();
            builder.append(value.getPath());
            builder.append(value.getUrl());
            builder.append((Object)value.getFormat());
            builder.append((Object)value.getType());
            builder.append((Object)value.getStickyDepth());
            return builder.getCode();
        }

        public boolean isEqual(WCInfo val1, WCInfo val2) {
            if (val1 == val2) {
                return true;
            }
            if (val1 == null || val2 == null || val1.getClass() != val2.getClass()) {
                return false;
            }
            if (!Comparing.equal((Object)((Object)val1.getFormat()), (Object)((Object)val2.getFormat()))) {
                return false;
            }
            if (!Comparing.equal((String)val1.getPath(), (String)val2.getPath())) {
                return false;
            }
            if (!Comparing.equal((Object)((Object)val1.getStickyDepth()), (Object)((Object)val2.getStickyDepth()))) {
                return false;
            }
            if (!Comparing.equal((Object)((Object)val1.getType()), (Object)((Object)val2.getType()))) {
                return false;
            }
            return Comparing.equal((Object)val1.getUrl(), (Object)val2.getUrl());
        }

        private static class HashCodeBuilder {
            private int myCode = 0;

            private HashCodeBuilder() {
            }

            public void append(Object o) {
                this.myCode = 31 * this.myCode + (o != null ? o.hashCode() : 0);
            }

            public int getCode() {
                return this.myCode;
            }
        }
    }

    public static class OverrideEqualsWrapper<T> {
        private final EqualityPolicy<T> myPolicy;
        private final T myT;

        public OverrideEqualsWrapper(EqualityPolicy<T> policy, T t) {
            this.myPolicy = policy;
            this.myT = t;
        }

        public T getT() {
            return this.myT;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OverrideEqualsWrapper that = (OverrideEqualsWrapper)o;
            return this.myPolicy.isEqual(this.myT, that.getT());
        }

        public int hashCode() {
            return this.myPolicy.getHashCode(this.myT);
        }
    }
}

