/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.MarkerVcsContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.actions.AbstractShowPropertiesDiffAction;
import org.tmatesoft.svn.core.SVNURL;

public class SvnLazyPropertyContentRevision
implements ContentRevision,
MarkerVcsContentRevision {
    private final FilePath myPath;
    private final VcsRevisionNumber myNumber;
    private final Project myProject;
    private final SVNURL myUrl;
    private String myContent;

    public SvnLazyPropertyContentRevision(FilePath path, VcsRevisionNumber number, Project project, SVNURL url) {
        this.myPath = path;
        this.myNumber = number;
        this.myProject = project;
        this.myUrl = url;
    }

    public String getContent() throws VcsException {
        if (this.myContent == null) {
            this.myContent = this.loadContent();
        }
        return this.myContent;
    }

    private String loadContent() {
        final SvnVcs vcs = SvnVcs.getInstance(this.myProject);
        final Ref ref = new Ref();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    ref.set((Object)AbstractShowPropertiesDiffAction.getPropertyList(vcs, SvnLazyPropertyContentRevision.this.myUrl, ((SvnRevisionNumber)SvnLazyPropertyContentRevision.this.myNumber).getRevision()));
                }
                catch (VcsException e) {
                    ref.set((Object)("Can not get properties: " + e.getMessage()));
                }
            }
        };
        if (ApplicationManager.getApplication().isDispatchThread()) {
            boolean completed = ProgressManager.getInstance().runProcessWithProgressSynchronously(runnable, SvnBundle.message("progress.title.loading.file.properties", new Object[0]), true, this.myProject);
            if (!completed) {
                return "Properties load for revision " + this.getRevisionNumber().asString() + " was canceled.";
            }
        } else {
            runnable.run();
        }
        return (String)ref.get();
    }

    @NotNull
    public FilePath getFile() {
        FilePath filePath = this.myPath;
        if (filePath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/SvnLazyPropertyContentRevision", "getFile"));
        }
        return filePath;
    }

    @NotNull
    public VcsRevisionNumber getRevisionNumber() {
        VcsRevisionNumber vcsRevisionNumber = this.myNumber;
        if (vcsRevisionNumber == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/SvnLazyPropertyContentRevision", "getRevisionNumber"));
        }
        return vcsRevisionNumber;
    }

    public VcsKey getVcsKey() {
        return SvnVcs.getKey();
    }
}

