/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.action;

import com.intellij.codeInsight.actions.RearrangeCodeProcessor;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.arrangement.Rearranger;
import java.util.ArrayList;

public class RearrangeCodeAction
extends AnAction {
    public void update(AnActionEvent e) {
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(e.getDataContext());
        boolean enabled = file != null && Rearranger.EXTENSION.forLanguage(file.getLanguage()) != null;
        e.getPresentation().setEnabled(enabled);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            return;
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        Document document = editor.getDocument();
        documentManager.commitDocument(document);
        PsiFile file = documentManager.getPsiFile(document);
        if (file == null) {
            return;
        }
        ArrayList<TextRange> ranges = new ArrayList<TextRange>();
        SelectionModel selectionModel = editor.getSelectionModel();
        if (selectionModel.hasSelection()) {
            ranges.add(TextRange.create((int)selectionModel.getSelectionStart(), (int)selectionModel.getSelectionEnd()));
        } else if (selectionModel.hasBlockSelection()) {
            int[] starts = selectionModel.getBlockSelectionStarts();
            int[] ends = selectionModel.getBlockSelectionEnds();
            for (int i = 0; i < starts.length; ++i) {
                ranges.add(TextRange.create((int)starts[i], (int)ends[i]));
            }
        } else {
            ranges.add(TextRange.create((int)0, (int)document.getTextLength()));
        }
        new RearrangeCodeProcessor(project, file, ranges).run();
    }
}

