/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.pathMacros;

import com.intellij.application.options.pathMacros.PathMacroListEditor;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectEx;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathMacroConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    @NonNls
    public static final String HELP_ID = "preferences.pathVariables";
    private PathMacroListEditor myEditor;

    public JComponent createComponent() {
        this.myEditor = new PathMacroListEditor();
        return this.myEditor.getPanel();
    }

    public void apply() throws ConfigurationException {
        Project[] projects;
        this.myEditor.commit();
        for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
            ((ProjectEx)project).checkUnknownMacros(false);
        }
    }

    public void reset() {
        this.myEditor.reset();
    }

    public void disposeUIResources() {
        this.myEditor = null;
    }

    public String getDisplayName() {
        return ApplicationBundle.message((String)"title.path.variables", (Object[])new Object[0]);
    }

    @NotNull
    public String getHelpTopic() {
        if (HELP_ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/pathMacros/PathMacroConfigurable", "getHelpTopic"));
        }
        return HELP_ID;
    }

    public boolean isModified() {
        return this.myEditor != null && this.myEditor.isModified();
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/pathMacros/PathMacroConfigurable", "getId"));
        }
        return string;
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }
}

