/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ExportableComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Property;
import java.io.File;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="CodeInsightSettings", storages={@Storage(file="$APP_CONFIG$/editor.codeinsight.xml")})
public class CodeInsightSettings
implements PersistentStateComponent<Element>,
Cloneable,
ExportableComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.CodeInsightSettings");
    @NonNls
    public static final String EXTERNAL_FILE_NAME = "editor.codeinsight";
    public boolean AUTO_POPUP_PARAMETER_INFO = true;
    public int PARAMETER_INFO_DELAY = 1000;
    public boolean AUTO_POPUP_JAVADOC_INFO = false;
    public int JAVADOC_INFO_DELAY = 1000;
    public boolean AUTO_POPUP_COMPLETION_LOOKUP = true;
    public int COMPLETION_CASE_SENSITIVE = 3;
    public static final int ALL = 1;
    public static final int NONE = 2;
    public static final int FIRST_LETTER = 3;
    public int AUTOPOPUP_FOCUS_POLICY = 2;
    public static final int NEVER = 1;
    public static final int SMART = 2;
    public static final int ALWAYS = 3;
    public boolean SELECT_AUTOPOPUP_SUGGESTIONS_BY_CHARS = false;
    public boolean AUTOCOMPLETE_ON_CODE_COMPLETION = true;
    public boolean AUTOCOMPLETE_ON_SMART_TYPE_COMPLETION = true;
    @Deprecated
    public boolean AUTOCOMPLETE_ON_CLASS_NAME_COMPLETION = false;
    public boolean AUTOCOMPLETE_COMMON_PREFIX = true;
    public boolean SHOW_STATIC_AFTER_INSTANCE = false;
    public boolean SHOW_FULL_SIGNATURES_IN_PARAMETER_INFO = false;
    public int SMART_BACKSPACE = 1;
    public static final int OFF = 0;
    public static final int AUTOINDENT = 1;
    public boolean SMART_INDENT_ON_ENTER = true;
    public boolean INSERT_BRACE_ON_ENTER = true;
    public boolean INSERT_SCRIPTLET_END_ON_ENTER = true;
    public boolean JAVADOC_STUB_ON_ENTER = true;
    public boolean SMART_END_ACTION = true;
    public boolean JAVADOC_GENERATE_CLOSING_TAG = true;
    public boolean SURROUND_SELECTION_ON_QUOTE_TYPED = false;
    public boolean AUTOINSERT_PAIR_BRACKET = true;
    public boolean AUTOINSERT_PAIR_QUOTE = true;
    public boolean REFORMAT_BLOCK_ON_RBRACE = true;
    public int REFORMAT_ON_PASTE = 3;
    public static final int NO_REFORMAT = 1;
    public static final int INDENT_BLOCK = 2;
    public static final int INDENT_EACH_LINE = 3;
    public static final int REFORMAT_BLOCK = 4;
    public boolean INDENT_TO_CARET_ON_PASTE = false;
    public int ADD_IMPORTS_ON_PASTE = 3;
    public static final int YES = 1;
    public static final int NO = 2;
    public static final int ASK = 3;
    public boolean HIGHLIGHT_BRACES = true;
    public boolean HIGHLIGHT_SCOPE = false;
    public boolean USE_INSTANCEOF_ON_EQUALS_PARAMETER = false;
    public boolean HIGHLIGHT_IDENTIFIER_UNDER_CARET = true;
    public boolean OPTIMIZE_IMPORTS_ON_THE_FLY = false;
    public boolean ADD_UNAMBIGIOUS_IMPORTS_ON_THE_FLY = false;
    public boolean JSP_ADD_UNAMBIGIOUS_IMPORTS_ON_THE_FLY = false;
    @Property(surroundWithTag=false)
    @AbstractCollection(surroundWithTag=false, elementTag="EXCLUDED_PACKAGE", elementValueAttribute="NAME")
    public String[] EXCLUDED_PACKAGES = ArrayUtil.EMPTY_STRING_ARRAY;

    public static CodeInsightSettings getInstance() {
        return (CodeInsightSettings)ServiceManager.getService(CodeInsightSettings.class);
    }

    @NotNull
    public File[] getExportFiles() {
        File[] fileArray = new File[]{PathManager.getOptionsFile((String)EXTERNAL_FILE_NAME)};
        if (fileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/CodeInsightSettings", "getExportFiles"));
        }
        return fileArray;
    }

    @NotNull
    public String getPresentableName() {
        String string = CodeInsightBundle.message((String)"codeinsight.settings", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/CodeInsightSettings", "getPresentableName"));
        }
        return string;
    }

    @Nullable
    public CodeInsightSettings clone() {
        try {
            return (CodeInsightSettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public void loadState(Element state) {
        try {
            XmlSerializer.deserializeInto((Object)this, (Element)state);
        }
        catch (XmlSerializationException e) {
            LOG.info((Throwable)e);
        }
    }

    public Element getState() {
        Element element = new Element("state");
        this.writeExternal(element);
        return element;
    }

    public void writeExternal(Element element) {
        try {
            XmlSerializer.serializeInto((Object)this, (Element)element, (SerializationFilter)new SkipDefaultValuesSerializationFilters());
        }
        catch (XmlSerializationException e) {
            LOG.info((Throwable)e);
        }
    }
}

