/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiMatcherImpl;
import com.intellij.psi.util.PsiMatchers;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaHighlightUtil {
    public static boolean isSerializable(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInsight/daemon/impl/analysis/JavaHighlightUtil", "isSerializable"));
        }
        return JavaHighlightUtil.isSerializable(aClass, "java.io.Serializable");
    }

    public static boolean isSerializable(@NotNull PsiClass aClass, String serializableClassName) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInsight/daemon/impl/analysis/JavaHighlightUtil", "isSerializable"));
        }
        Project project = aClass.getManager().getProject();
        PsiClass serializableClass = JavaPsiFacade.getInstance((Project)project).findClass(serializableClassName, aClass.getResolveScope());
        return serializableClass != null && aClass.isInheritor(serializableClass, true);
    }

    public static boolean isSerializationRelatedMethod(PsiMethod method, PsiClass containingClass) {
        if (containingClass == null) {
            return false;
        }
        if (method.isConstructor()) {
            return JavaHighlightUtil.isSerializable(containingClass, "java.io.Externalizable") && method.getParameterList().getParametersCount() == 0 && method.hasModifierProperty("public");
        }
        if (method.hasModifierProperty("static")) {
            return false;
        }
        String name = method.getName();
        PsiParameter[] parameters = method.getParameterList().getParameters();
        PsiType returnType = method.getReturnType();
        if ("readObjectNoData".equals(name)) {
            return parameters.length == 0 && TypeConversionUtil.isVoidType((PsiType)returnType) && JavaHighlightUtil.isSerializable(containingClass);
        }
        if ("readObject".equals(name)) {
            return parameters.length == 1 && parameters[0].getType().equalsToText("java.io.ObjectInputStream") && TypeConversionUtil.isVoidType((PsiType)returnType) && method.hasModifierProperty("private") && JavaHighlightUtil.isSerializable(containingClass);
        }
        if ("readResolve".equals(name)) {
            return parameters.length == 0 && returnType != null && returnType.equalsToText("java.lang.Object") && (containingClass.hasModifierProperty("abstract") || JavaHighlightUtil.isSerializable(containingClass));
        }
        if ("writeReplace".equals(name)) {
            return parameters.length == 0 && returnType != null && returnType.equalsToText("java.lang.Object") && (containingClass.hasModifierProperty("abstract") || JavaHighlightUtil.isSerializable(containingClass));
        }
        if ("writeObject".equals(name)) {
            return parameters.length == 1 && TypeConversionUtil.isVoidType((PsiType)returnType) && parameters[0].getType().equalsToText("java.io.ObjectOutputStream") && method.hasModifierProperty("private") && JavaHighlightUtil.isSerializable(containingClass);
        }
        return false;
    }

    @NotNull
    public static String formatType(@Nullable PsiType type) {
        String string = type == null ? "null" : type.getInternalCanonicalText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/JavaHighlightUtil", "formatType"));
        }
        return string;
    }

    @Nullable
    private static PsiType getArrayInitializerType(@NotNull PsiArrayInitializerExpression element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/analysis/JavaHighlightUtil", "getArrayInitializerType"));
        }
        PsiType typeCheckResult = JavaHighlightUtil.sameType(element.getInitializers());
        return typeCheckResult != null ? typeCheckResult.createArrayType() : null;
    }

    @Nullable
    public static PsiType sameType(@NotNull PsiExpression[] expressions) {
        if (expressions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressions", "com/intellij/codeInsight/daemon/impl/analysis/JavaHighlightUtil", "sameType"));
        }
        PsiType type = null;
        for (PsiExpression expression : expressions) {
            PsiType currentType = expression instanceof PsiArrayInitializerExpression ? JavaHighlightUtil.getArrayInitializerType((PsiArrayInitializerExpression)expression) : expression.getType();
            if (type == null) {
                type = currentType;
                continue;
            }
            if (type.equals(currentType)) continue;
            return null;
        }
        return type;
    }

    @NotNull
    public static String formatMethod(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/daemon/impl/analysis/JavaHighlightUtil", "formatMethod"));
        }
        String string = PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/JavaHighlightUtil", "formatMethod"));
        }
        return string;
    }

    public static boolean isSuperOrThisCall(PsiStatement statement, boolean testForSuper, boolean testForThis) {
        if (!(statement instanceof PsiExpressionStatement)) {
            return false;
        }
        PsiExpression expression = ((PsiExpressionStatement)statement).getExpression();
        if (!(expression instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiReferenceExpression methodExpression = ((PsiMethodCallExpression)expression).getMethodExpression();
        if (testForSuper && "super".equals(methodExpression.getText())) {
            return true;
        }
        return testForThis && "this".equals(methodExpression.getText());
    }

    @Nullable
    public static List<PsiMethod> getChainedConstructors(PsiMethod constructor) {
        ConstructorVisitorInfo info = new ConstructorVisitorInfo();
        JavaHighlightUtil.visitConstructorChain(constructor, info);
        if (info.visitedConstructors != null) {
            info.visitedConstructors.remove(constructor);
        }
        return info.visitedConstructors;
    }

    static void visitConstructorChain(PsiMethod constructor, ConstructorVisitorInfo info) {
        while (constructor != null) {
            PsiCodeBlock body = constructor.getBody();
            if (body == null) {
                return;
            }
            PsiStatement[] statements = body.getStatements();
            if (statements.length == 0) {
                return;
            }
            PsiStatement statement = statements[0];
            PsiElement element = new PsiMatcherImpl((PsiElement)statement).dot(PsiMatchers.hasClass(PsiExpressionStatement.class)).firstChild(PsiMatchers.hasClass(PsiMethodCallExpression.class)).firstChild(PsiMatchers.hasClass(PsiReferenceExpression.class)).firstChild(PsiMatchers.hasClass(PsiKeyword.class)).dot(PsiMatchers.hasText("this")).parent(null).parent(null).getElement();
            if (element == null) {
                return;
            }
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)element;
            PsiMethod method = methodCall.resolveMethod();
            if (method == null) {
                return;
            }
            if (info.visitedConstructors != null && info.visitedConstructors.contains(method)) {
                info.recursivelyCalledConstructor = method;
                return;
            }
            if (info.visitedConstructors == null) {
                info.visitedConstructors = new ArrayList<PsiMethod>(5);
            }
            info.visitedConstructors.add(method);
            constructor = method;
        }
        return;
    }

    static class ConstructorVisitorInfo {
        List<PsiMethod> visitedConstructors;
        PsiMethod recursivelyCalledConstructor;

        ConstructorVisitorInfo() {
        }
    }
}

