/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.ImportFilter;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.DaemonListeners;
import com.intellij.codeInsight.daemon.impl.ShowAutoImportPass;
import com.intellij.codeInsight.daemon.impl.actions.AddImportAction;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.HintAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.packageDependencies.DependencyRule;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ImportClassFixBase<T extends PsiElement, R extends PsiReference>
implements HintAction,
HighPriorityAction {
    @NotNull
    private final T myElement;
    @NotNull
    private final R myRef;

    protected ImportClassFixBase(@NotNull T elem, @NotNull R ref) {
        if (elem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elem", "com/intellij/codeInsight/daemon/impl/quickfix/ImportClassFixBase", "<init>"));
        }
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/codeInsight/daemon/impl/quickfix/ImportClassFixBase", "<init>"));
        }
        this.myElement = elem;
        this.myRef = ref;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/ImportClassFixBase", "isAvailable"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/ImportClassFixBase", "isAvailable"));
        }
        if (!this.myElement.isValid()) {
            return false;
        }
        PsiElement parent = this.myElement.getParent();
        if (parent instanceof PsiNewExpression && ((PsiNewExpression)parent).getQualifier() != null) {
            return false;
        }
        PsiManager manager = file.getManager();
        return manager.isInProject((PsiElement)file) && !this.getClassesToImport().isEmpty();
    }

    @Nullable
    protected abstract String getReferenceName(@NotNull R var1);

    protected abstract PsiElement getReferenceNameElement(@NotNull R var1);

    protected abstract boolean hasTypeParameters(@NotNull R var1);

    @NotNull
    public List<PsiClass> getClassesToImport() {
        JavaResolveResult result;
        PsiElement element;
        if (this.myRef instanceof PsiJavaReference && (element = (result = ((PsiJavaReference)this.myRef).advancedResolve(true)).getElement()) instanceof PsiClass && result.isValidResult()) {
            List<PsiClass> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ImportClassFixBase", "getClassesToImport"));
            }
            return list;
        }
        String name = this.getReferenceName(this.myRef);
        GlobalSearchScope scope = this.myElement.getResolveScope();
        if (name == null) {
            List<PsiClass> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ImportClassFixBase", "getClassesToImport"));
            }
            return list;
        }
        if (!this.canReferenceClass(this.myRef)) {
            List<PsiClass> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ImportClassFixBase", "getClassesToImport"));
            }
            return list;
        }
        boolean referenceHasTypeParameters = this.hasTypeParameters(this.myRef);
        PsiClass[] classes = PsiShortNamesCache.getInstance((Project)this.myElement.getProject()).getClassesByName(name, scope);
        if (classes.length == 0) {
            List<PsiClass> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ImportClassFixBase", "getClassesToImport"));
            }
            return list;
        }
        List<PsiClass> classList = new ArrayList<PsiClass>(classes.length);
        boolean isAnnotationReference = this.myElement.getParent() instanceof PsiAnnotation;
        PsiFile file = this.myElement.getContainingFile();
        for (PsiClass aClass : classes) {
            String qName;
            if (isAnnotationReference && !aClass.isAnnotationType() || JavaCompletionUtil.isInExcludedPackage((PsiMember)aClass, false) || referenceHasTypeParameters && !aClass.hasTypeParameters() || (qName = aClass.getQualifiedName()) == null || qName.indexOf(46) == -1 || !qName.endsWith(name) || file != null && !ImportFilter.shouldImport((PsiFile)file, (String)qName) || !this.isAccessible((PsiMember)aClass, this.myElement)) continue;
            classList.add(aClass);
        }
        List<PsiClass> filtered = this.filterByContext(classList = this.filterByRequiredMemberName(classList), this.myElement);
        if (!filtered.isEmpty()) {
            classList = filtered;
        }
        this.filterAlreadyImportedButUnresolved(classList);
        List<PsiClass> list = classList;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ImportClassFixBase", "getClassesToImport"));
        }
        return list;
    }

    protected boolean canReferenceClass(R ref) {
        return true;
    }

    private List<PsiClass> filterByRequiredMemberName(List<PsiClass> classList) {
        List filtered;
        final String memberName = this.getRequiredMemberName(this.myElement);
        if (memberName != null && !(filtered = ContainerUtil.findAll(classList, (Condition)new Condition<PsiClass>(){

            public boolean value(PsiClass psiClass) {
                PsiField field = psiClass.findFieldByName(memberName, true);
                if (field != null && field.hasModifierProperty("static") && ImportClassFixBase.this.isAccessible((PsiMember)field, ImportClassFixBase.this.myElement)) {
                    return true;
                }
                PsiClass inner = psiClass.findInnerClassByName(memberName, true);
                if (inner != null && ImportClassFixBase.this.isAccessible((PsiMember)inner, ImportClassFixBase.this.myElement)) {
                    return true;
                }
                for (PsiMethod method : psiClass.findMethodsByName(memberName, true)) {
                    if (!method.hasModifierProperty("static") || !ImportClassFixBase.this.isAccessible((PsiMember)method, ImportClassFixBase.this.myElement)) continue;
                    return true;
                }
                return false;
            }
        })).isEmpty()) {
            classList = filtered;
        }
        return classList;
    }

    private void filterAlreadyImportedButUnresolved(@NotNull List<PsiClass> list) {
        PsiFile containingFile;
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/codeInsight/daemon/impl/quickfix/ImportClassFixBase", "filterAlreadyImportedButUnresolved"));
        }
        PsiElement element = this.myRef.getElement();
        PsiFile psiFile = containingFile = element == null ? null : element.getContainingFile();
        if (!(containingFile instanceof PsiJavaFile)) {
            return;
        }
        PsiJavaFile javaFile = (PsiJavaFile)containingFile;
        PsiImportList importList = javaFile.getImportList();
        PsiImportStatementBase[] importStatements = importList == null ? PsiImportStatementBase.EMPTY_ARRAY : importList.getAllImportStatements();
        THashSet importedNames = new THashSet(importStatements.length);
        for (PsiImportStatementBase statement : importStatements) {
            String name;
            PsiJavaCodeReferenceElement ref = statement.getImportReference();
            String string = name = ref == null ? null : ref.getReferenceName();
            if (name == null || ref.resolve() != null) continue;
            importedNames.add(name);
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            PsiClass aClass = list.get(i);
            String className = aClass.getName();
            if (className == null || !importedNames.contains(className)) continue;
            list.remove(i);
        }
    }

    @Nullable
    protected String getRequiredMemberName(T reference) {
        return null;
    }

    @NotNull
    protected List<PsiClass> filterByContext(@NotNull List<PsiClass> candidates, @NotNull T ref) {
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "com/intellij/codeInsight/daemon/impl/quickfix/ImportClassFixBase", "filterByContext"));
        }
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/codeInsight/daemon/impl/quickfix/ImportClassFixBase", "filterByContext"));
        }
        List<PsiClass> list = candidates;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ImportClassFixBase", "filterByContext"));
        }
        return list;
    }

    protected abstract boolean isAccessible(PsiMember var1, T var2);

    protected abstract String getQualifiedName(T var1);

    protected static List<PsiClass> filterAssignableFrom(PsiType type, List<PsiClass> candidates) {
        final PsiClass actualClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type);
        if (actualClass != null) {
            return ContainerUtil.findAll(candidates, (Condition)new Condition<PsiClass>(){

                public boolean value(PsiClass psiClass) {
                    return InheritanceUtil.isInheritorOrSelf((PsiClass)psiClass, (PsiClass)actualClass, (boolean)true);
                }
            });
        }
        return candidates;
    }

    protected static List<PsiClass> filterBySuperMethods(PsiParameter parameter, List<PsiClass> candidates) {
        PsiMethod method;
        PsiElement granny;
        PsiElement parent = parameter.getParent();
        if (parent instanceof PsiParameterList && (granny = parent.getParent()) instanceof PsiMethod && (method = (PsiMethod)granny).getModifierList().findAnnotation("java.lang.Override") != null) {
            PsiClass aClass = method.getContainingClass();
            HashSet probableTypes = new HashSet();
            InheritanceUtil.processSupers((PsiClass)aClass, (boolean)false, (Processor)new Processor<PsiClass>((Set)probableTypes){
                final /* synthetic */ Set val$probableTypes;
                {
                    this.val$probableTypes = set;
                }

                public boolean process(PsiClass psiClass) {
                    for (PsiMethod psiMethod : psiClass.findMethodsByName(method.getName(), false)) {
                        for (PsiParameter psiParameter : psiMethod.getParameterList().getParameters()) {
                            ContainerUtil.addIfNotNull((Collection)this.val$probableTypes, (Object)PsiUtil.resolveClassInClassTypeOnly((PsiType)psiParameter.getType()));
                        }
                    }
                    return true;
                }
            });
            List filtered = ContainerUtil.filter(candidates, (Condition)new Condition<PsiClass>((Set)probableTypes){
                final /* synthetic */ Set val$probableTypes;
                {
                    this.val$probableTypes = set;
                }

                public boolean value(PsiClass psiClass) {
                    return this.val$probableTypes.contains(psiClass);
                }
            });
            if (!filtered.isEmpty()) {
                return filtered;
            }
        }
        return candidates;
    }

    public Result doFix(@NotNull Editor editor, boolean allowPopup, boolean allowCaretNearRef) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/quickfix/ImportClassFixBase", "doFix"));
        }
        List<PsiClass> classesToImport = this.getClassesToImport();
        if (classesToImport.isEmpty()) {
            return Result.POPUP_NOT_SHOWN;
        }
        try {
            Pattern pattern;
            Matcher matcher;
            String name = this.getQualifiedName(this.myElement);
            if (name != null && (matcher = (pattern = Pattern.compile(DaemonCodeAnalyzerSettings.getInstance().NO_AUTO_IMPORT_PATTERN)).matcher(name)).matches()) {
                return Result.POPUP_NOT_SHOWN;
            }
        }
        catch (PatternSyntaxException e) {
            // empty catch block
        }
        PsiFile psiFile = this.myElement.getContainingFile();
        if (classesToImport.size() > 1) {
            ImportClassFixBase.reduceSuggestedClassesBasedOnDependencyRuleViolation(psiFile, classesToImport);
        }
        PsiClass[] classes = classesToImport.toArray(new PsiClass[classesToImport.size()]);
        Project project = this.myElement.getProject();
        CodeInsightUtil.sortIdenticalShortNameClasses(classes, this.myRef);
        final AddImportAction action = this.createAddImportAction(classes, project, editor);
        boolean canImportHere = true;
        if (classes.length == 1 && (canImportHere = this.canImportHere(allowCaretNearRef, editor, psiFile, classes[0].getName())) && (FileTypeUtils.isInServerPageFile((PsiElement)psiFile) ? CodeInsightSettings.getInstance().JSP_ADD_UNAMBIGIOUS_IMPORTS_ON_THE_FLY : CodeInsightSettings.getInstance().ADD_UNAMBIGIOUS_IMPORTS_ON_THE_FLY) && (ApplicationManager.getApplication().isUnitTestMode() || DaemonListeners.canChangeFileSilently((PsiFileSystemItem)psiFile)) && !ImportClassFixBase.autoImportWillInsertUnexpectedCharacters(classes[0]) && !LaterInvocator.isInModalContext()) {
            CommandProcessor.getInstance().runUndoTransparentAction(new Runnable(){

                @Override
                public void run() {
                    action.execute();
                }
            });
            return Result.CLASS_AUTO_IMPORTED;
        }
        if (allowPopup && canImportHere) {
            String hintText = ShowAutoImportPass.getMessage(classes.length > 1, classes[0].getQualifiedName());
            if (!ApplicationManager.getApplication().isUnitTestMode() && !HintManager.getInstance().hasShownHintsThatWillHideByOtherHint(true)) {
                HintManager.getInstance().showQuestionHint(editor, hintText, this.getStartOffset(this.myElement, this.myRef), this.getEndOffset(this.myElement, this.myRef), (QuestionAction)action);
            }
            return Result.POPUP_SHOWN;
        }
        return Result.POPUP_NOT_SHOWN;
    }

    protected int getStartOffset(T element, R ref) {
        return element.getTextOffset();
    }

    protected int getEndOffset(T element, R ref) {
        return element.getTextRange().getEndOffset();
    }

    private static boolean autoImportWillInsertUnexpectedCharacters(PsiClass aClass) {
        PsiClass containingClass = aClass.getContainingClass();
        return containingClass != null;
    }

    private boolean canImportHere(boolean allowCaretNearRef, Editor editor, PsiFile psiFile, String exampleClassName) {
        return (allowCaretNearRef || !this.isCaretNearRef(editor, this.myRef)) && !this.hasUnresolvedImportWhichCanImport(psiFile, exampleClassName);
    }

    protected abstract boolean isQualified(R var1);

    public boolean showHint(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/quickfix/ImportClassFixBase", "showHint"));
        }
        if (this.isQualified(this.myRef)) {
            return false;
        }
        Result result = this.doFix(editor, true, false);
        return result == Result.POPUP_SHOWN || result == Result.CLASS_AUTO_IMPORTED;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("import.class.fix", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ImportClassFixBase", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("import.class.fix", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ImportClassFixBase", "getFamilyName"));
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    protected abstract boolean hasUnresolvedImportWhichCanImport(PsiFile var1, String var2);

    private static void reduceSuggestedClassesBasedOnDependencyRuleViolation(PsiFile file, List<PsiClass> availableClasses) {
        Project project = file.getProject();
        DependencyValidationManager validationManager = DependencyValidationManager.getInstance((Project)project);
        for (int i = availableClasses.size() - 1; i >= 0; --i) {
            DependencyRule[] violated;
            PsiClass psiClass = availableClasses.get(i);
            PsiFile targetFile = psiClass.getContainingFile();
            if (targetFile == null || (violated = validationManager.getViolatorDependencyRules(file, targetFile)).length == 0) continue;
            availableClasses.remove(i);
            if (availableClasses.size() == 1) break;
        }
    }

    private boolean isCaretNearRef(@NotNull Editor editor, @NotNull R ref) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/quickfix/ImportClassFixBase", "isCaretNearRef"));
        }
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/codeInsight/daemon/impl/quickfix/ImportClassFixBase", "isCaretNearRef"));
        }
        PsiElement nameElement = this.getReferenceNameElement(ref);
        if (nameElement == null) {
            return false;
        }
        TextRange range = nameElement.getTextRange();
        int offset = editor.getCaretModel().getOffset();
        return offset == range.getEndOffset();
    }

    public void invoke(final @NotNull Project project, final Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/ImportClassFixBase", "invoke"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                List<PsiClass> classesToImport = ImportClassFixBase.this.getClassesToImport();
                PsiClass[] classes = classesToImport.toArray(new PsiClass[classesToImport.size()]);
                if (classes.length == 0) {
                    return;
                }
                AddImportAction action = ImportClassFixBase.this.createAddImportAction(classes, project, editor);
                action.execute();
            }
        });
    }

    protected void bindReference(PsiReference reference, PsiClass targetClass) {
        reference.bindToElement((PsiElement)targetClass);
    }

    protected AddImportAction createAddImportAction(PsiClass[] classes, Project project, Editor editor) {
        return new AddImportAction(project, (PsiReference)this.myRef, editor, classes){

            @Override
            protected void bindReference(PsiReference ref, PsiClass targetClass) {
                ImportClassFixBase.this.bindReference(ref, targetClass);
            }
        };
    }

    public static enum Result {
        POPUP_SHOWN,
        CLASS_AUTO_IMPORTED,
        POPUP_NOT_SHOWN;

    }
}

