/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.folding.impl.EditorFoldingInfo;
import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class CollapseBlockHandler
implements CodeInsightActionHandler {
    public static final String ourPlaceHolderText = "{...}";
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.folding.impl.CollapseBlockHandler");

    public void invoke(@NotNull Project project, final @NotNull Editor editor, final @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/folding/impl/CollapseBlockHandler", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/folding/impl/CollapseBlockHandler", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/folding/impl/CollapseBlockHandler", "invoke"));
        }
        editor.getFoldingModel().runBatchFoldingOperation(new Runnable(){

            @Override
            public void run() {
                EditorFoldingInfo info = EditorFoldingInfo.get(editor);
                FoldingModelEx model = (FoldingModelEx)editor.getFoldingModel();
                PsiElement element = file.findElementAt(editor.getCaretModel().getOffset() - 1);
                if (!(element instanceof PsiJavaToken) || ((PsiJavaToken)element).getTokenType() != JavaTokenType.RBRACE) {
                    element = file.findElementAt(editor.getCaretModel().getOffset());
                }
                if (element == null) {
                    return;
                }
                PsiCodeBlock block = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)element, PsiCodeBlock.class);
                FoldRegion previous = null;
                FoldRegion myPrevious = null;
                while (block != null) {
                    int end;
                    int start = block.getTextRange().getStartOffset();
                    FoldRegion existing = FoldingUtil.findFoldRegion(editor, start, end = block.getTextRange().getEndOffset());
                    if (existing != null) {
                        previous = existing;
                        if (info.getPsiElement(existing) == null) {
                            myPrevious = existing;
                        }
                        block = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)block, PsiCodeBlock.class);
                        continue;
                    }
                    if (model.intersectsRegion(start, end)) break;
                    FoldRegion region = model.addFoldRegion(start, end, CollapseBlockHandler.ourPlaceHolderText);
                    LOG.assertTrue(region != null);
                    region.setExpanded(false);
                    if (myPrevious != null && info.getPsiElement(region) == null) {
                        info.removeRegion(myPrevious);
                        model.removeFoldRegion(myPrevious);
                    }
                    int offset = block.getTextRange().getEndOffset() < editor.getCaretModel().getOffset() ? start : end;
                    editor.getCaretModel().moveToOffset(offset);
                    return;
                }
                if (previous != null) {
                    previous.setExpanded(false);
                    if (myPrevious != null) {
                        info.removeRegion(myPrevious);
                        model.removeFoldRegion(myPrevious);
                    }
                    editor.getCaretModel().moveToOffset(previous.getEndOffset());
                }
            }
        });
    }

    public boolean startInWriteAction() {
        return true;
    }
}

