/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.folding.impl.EditorFoldingInfo;
import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class CollapseSelectionHandler
implements CodeInsightActionHandler {
    private static final String ourPlaceHolderText = "...";
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.folding.impl.CollapseSelectionHandler");

    public void invoke(@NotNull Project project, final @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/folding/impl/CollapseSelectionHandler", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/folding/impl/CollapseSelectionHandler", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/folding/impl/CollapseSelectionHandler", "invoke"));
        }
        editor.getFoldingModel().runBatchFoldingOperation(new Runnable(){

            @Override
            public void run() {
                EditorFoldingInfo info = EditorFoldingInfo.get(editor);
                FoldingModelEx foldingModel = (FoldingModelEx)editor.getFoldingModel();
                if (editor.getSelectionModel().hasSelection()) {
                    FoldRegion region;
                    int end;
                    int start = editor.getSelectionModel().getSelectionStart();
                    if (start + 1 >= (end = editor.getSelectionModel().getSelectionEnd())) {
                        return;
                    }
                    Document doc = editor.getDocument();
                    if (start < end && doc.getCharsSequence().charAt(end - 1) == '\n') {
                        --end;
                    }
                    if ((region = FoldingUtil.findFoldRegion(editor, start, end)) != null) {
                        if (info.getPsiElement(region) == null) {
                            editor.getFoldingModel().removeFoldRegion(region);
                            info.removeRegion(region);
                        }
                    } else if (!foldingModel.intersectsRegion(start, end)) {
                        region = foldingModel.addFoldRegion(start, end, CollapseSelectionHandler.ourPlaceHolderText);
                        LOG.assertTrue(region != null, (Object)("Fold region is not created. Folding model: " + foldingModel));
                        region.setExpanded(false);
                        int offset = Math.min(start + CollapseSelectionHandler.ourPlaceHolderText.length(), doc.getTextLength());
                        editor.getCaretModel().moveToOffset(offset);
                    }
                } else {
                    FoldRegion[] regions = FoldingUtil.getFoldRegionsAtOffset(editor, editor.getCaretModel().getOffset());
                    if (regions.length > 0) {
                        FoldRegion region = regions[0];
                        if (info.getPsiElement(region) == null) {
                            editor.getFoldingModel().removeFoldRegion(region);
                            info.removeRegion(region);
                        } else {
                            region.setExpanded(!region.isExpanded());
                        }
                    }
                }
            }
        });
    }

    public boolean startInWriteAction() {
        return false;
    }
}

