/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.classFilesIndex.chainsSearch.context;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

class ChainCompletionContextStringUtil {
    private static final int COMMON_PART_MIN_LENGTH = 3;

    private ChainCompletionContextStringUtil() {
    }

    public static boolean isSimilar(@NotNull String varName, @NotNull String parameterName) {
        if (varName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "varName", "com/intellij/compiler/classFilesIndex/chainsSearch/context/ChainCompletionContextStringUtil", "isSimilar"));
        }
        if (parameterName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterName", "com/intellij/compiler/classFilesIndex/chainsSearch/context/ChainCompletionContextStringUtil", "isSimilar"));
        }
        String sanitizedParamName = ChainCompletionContextStringUtil.sanitizedToLowerCase(parameterName);
        if (StringUtil.commonPrefix((String)varName, (String)sanitizedParamName).length() >= 3) {
            return true;
        }
        String suffix = StringUtil.commonSuffix((String)varName, (String)sanitizedParamName);
        return suffix.length() >= 3;
    }

    @NotNull
    public static String sanitizedToLowerCase(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/compiler/classFilesIndex/chainsSearch/context/ChainCompletionContextStringUtil", "sanitizedToLowerCase"));
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (!Character.isLetter(ch)) continue;
            result.append(Character.toLowerCase(ch));
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/classFilesIndex/chainsSearch/context/ChainCompletionContextStringUtil", "sanitizedToLowerCase"));
        }
        return string;
    }
}

