/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.process.ConsoleHistoryModel;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.UndoConstants;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actions.ContentChooser;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringHash;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.SafeFileOutputStream;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.xml.XppReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmlpull.v1.XmlSerializer;

public class ConsoleHistoryController {
    private static final int VERSION = 1;
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.execution.console.ConsoleHistoryController");
    private final LanguageConsoleImpl myConsole;
    private final AnAction myHistoryNext;
    private final AnAction myHistoryPrev;
    private final AnAction myBrowseHistory;
    private boolean myMultiline;
    private final ModelHelper myHelper;
    private long myLastSaveStamp;

    public ConsoleHistoryController(@NotNull String type, @Nullable String persistenceId, @NotNull LanguageConsoleImpl console, @NotNull ConsoleHistoryModel model) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/execution/console/ConsoleHistoryController", "<init>"));
        }
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/execution/console/ConsoleHistoryController", "<init>"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/execution/console/ConsoleHistoryController", "<init>"));
        }
        this.myHistoryNext = new MyAction(true);
        this.myHistoryPrev = new MyAction(false);
        this.myBrowseHistory = new MyBrowseAction();
        this.myHelper = new ModelHelper(type, StringUtil.isEmpty((String)persistenceId) ? console.getProject().getPresentableUrl() : persistenceId, model);
        this.myConsole = console;
    }

    public boolean isMultiline() {
        return this.myMultiline;
    }

    public ConsoleHistoryController setMultiline(boolean multiline) {
        this.myMultiline = multiline;
        return this;
    }

    public ConsoleHistoryModel getModel() {
        return this.myHelper.getModel();
    }

    public void install() {
        if (this.myHelper.getId() != null) {
            ApplicationManager.getApplication().getMessageBus().connect((Disposable)this.myConsole).subscribe(ProjectEx.ProjectSaved.TOPIC, (Object)new ProjectEx.ProjectSaved(){

                @Override
                public void saved(@NotNull Project project) {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/console/ConsoleHistoryController$1", "saved"));
                    }
                    ConsoleHistoryController.this.saveHistory();
                }
            });
            Disposer.register((Disposable)this.myConsole, (Disposable)new Disposable(){

                public void dispose() {
                    ConsoleHistoryController.this.saveHistory();
                }
            });
            this.loadHistory(this.myHelper.getId());
        }
        this.configureActions();
        this.myLastSaveStamp = this.getCurrentTimeStamp();
    }

    private long getCurrentTimeStamp() {
        return this.getModel().getModificationCount() + this.myConsole.getEditorDocument().getModificationStamp();
    }

    private void configureActions() {
        EmptyAction.setupAction((AnAction)this.myHistoryNext, (String)"Console.History.Next", null);
        EmptyAction.setupAction((AnAction)this.myHistoryPrev, (String)"Console.History.Previous", null);
        EmptyAction.setupAction((AnAction)this.myBrowseHistory, (String)"Console.History.Browse", null);
        if (!this.myMultiline) {
            AnAction up = ActionManager.getInstance().getActionOrStub("EditorUp");
            AnAction down = ActionManager.getInstance().getActionOrStub("EditorDown");
            if (up != null && down != null) {
                this.myHistoryNext.registerCustomShortcutSet(up.getShortcutSet(), null);
                this.myHistoryPrev.registerCustomShortcutSet(down.getShortcutSet(), null);
            } else {
                this.myHistoryNext.registerCustomShortcutSet(38, 0, null);
                this.myHistoryPrev.registerCustomShortcutSet(40, 0, null);
            }
        }
        this.myHistoryNext.registerCustomShortcutSet(this.myHistoryNext.getShortcutSet(), this.myConsole.getCurrentEditor().getComponent());
        this.myHistoryPrev.registerCustomShortcutSet(this.myHistoryPrev.getShortcutSet(), this.myConsole.getCurrentEditor().getComponent());
        this.myBrowseHistory.registerCustomShortcutSet(this.myBrowseHistory.getShortcutSet(), this.myConsole.getCurrentEditor().getComponent());
    }

    public boolean loadHistory(String id) {
        String prev = this.myHelper.getContent();
        boolean result = this.myHelper.loadHistory(id);
        String userValue = this.myHelper.getContent();
        if (prev != userValue && userValue != null) {
            this.setConsoleText(userValue, false, false);
        }
        return result;
    }

    private void saveHistory() {
        if (this.myLastSaveStamp == this.getCurrentTimeStamp()) {
            return;
        }
        this.myHelper.setContent(this.myConsole.getEditorDocument().getText());
        this.myHelper.saveHistory();
        this.myLastSaveStamp = this.getCurrentTimeStamp();
    }

    private static void cleanupOldFiles(File dir) {
        long keep10weeks = 6048000000L;
        long curTime = System.currentTimeMillis();
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isFile() || !file.getName().endsWith(".hist.xml") || curTime - file.lastModified() <= 6048000000L) continue;
                file.delete();
            }
        }
    }

    public AnAction getHistoryNext() {
        return this.myHistoryNext;
    }

    public AnAction getHistoryPrev() {
        return this.myHistoryPrev;
    }

    public AnAction getBrowseHistory() {
        return this.myBrowseHistory;
    }

    protected void setConsoleText(final String command, final boolean storeUserText, final boolean regularMode) {
        if (regularMode && this.myMultiline && StringUtil.isEmptyOrSpaces((String)command)) {
            return;
        }
        final Editor editor = this.myConsole.getCurrentEditor();
        final Document document = editor.getDocument();
        new WriteCommandAction.Simple(this.myConsole.getProject(), new PsiFile[0]){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                int offset;
                if (storeUserText) {
                    ConsoleHistoryController.this.myHelper.setContent(document.getText());
                }
                String text = StringUtil.notNullize((String)command);
                if (regularMode) {
                    if (ConsoleHistoryController.this.myMultiline) {
                        offset = ConsoleHistoryController.this.insertTextMultiline(text, editor, document);
                    } else {
                        document.setText((CharSequence)text);
                        offset = document.getTextLength();
                    }
                } else {
                    offset = 0;
                    try {
                        document.putUserData(UndoConstants.DONT_RECORD_UNDO, (Object)Boolean.TRUE);
                        document.setText((CharSequence)text);
                    }
                    finally {
                        document.putUserData(UndoConstants.DONT_RECORD_UNDO, null);
                    }
                }
                editor.getCaretModel().moveToOffset(offset);
                editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            }
        }.execute();
    }

    protected int insertTextMultiline(String text, Editor editor, Document document) {
        TextRange selection = EditorUtil.getSelectionInAnyMode(editor);
        int start = document.getLineStartOffset(document.getLineNumber(selection.getStartOffset()));
        int end = document.getLineEndOffset(document.getLineNumber(selection.getEndOffset()));
        document.replaceString(start, end, (CharSequence)text);
        editor.getSelectionModel().setSelection(start, start + text.length());
        return start;
    }

    private boolean canMoveInEditor(boolean next) {
        Editor consoleEditor = this.myConsole.getCurrentEditor();
        Document document = consoleEditor.getDocument();
        CaretModel caretModel = consoleEditor.getCaretModel();
        if (LookupManager.getActiveLookup(consoleEditor) != null) {
            return false;
        }
        if (next) {
            return document.getLineNumber(caretModel.getOffset()) == 0;
        }
        int lineCount = document.getLineCount();
        return (lineCount == 0 || document.getLineNumber(caretModel.getOffset()) == lineCount - 1) && StringUtil.isEmptyOrSpaces((String)document.getText().substring(caretModel.getOffset()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void textTag(@NotNull XmlSerializer out, @NotNull String tag, @NotNull String text) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/execution/console/ConsoleHistoryController", "textTag"));
        }
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/execution/console/ConsoleHistoryController", "textTag"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/execution/console/ConsoleHistoryController", "textTag"));
        }
        out.startTag(null, tag);
        try {
            out.cdsect(text);
        }
        finally {
            out.endTag(null, tag);
        }
    }

    public static class ModelHelper {
        private final String myType;
        private final String myId;
        private final ConsoleHistoryModel myModel;
        private String myContent;

        public ModelHelper(String type, String id, ConsoleHistoryModel model) {
            this.myType = type;
            this.myId = id;
            this.myModel = model;
        }

        public ConsoleHistoryModel getModel() {
            return this.myModel;
        }

        public void setContent(String userValue) {
            this.myContent = userValue;
        }

        public String getId() {
            return this.myId;
        }

        public String getContent() {
            return this.myContent;
        }

        private String getHistoryFilePath(String id) {
            return PathManager.getSystemPath() + File.separator + "userHistory" + File.separator + this.myType + Long.toHexString(StringHash.calc((String)id)) + ".hist.xml";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean loadHistory(String id) {
            File file = new File(this.getHistoryFilePath(id));
            if (!file.exists()) {
                return false;
            }
            XppReader xmlReader = null;
            try {
                xmlReader = new XppReader((Reader)new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                String text = this.loadHistory((HierarchicalStreamReader)xmlReader, id);
                if (text != null) {
                    this.myContent = text;
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Exception ex) {
                Throwable cause = ExceptionUtil.getRootCause((Throwable)ex);
                if (cause instanceof EOFException) {
                    LOG.warn("Failed to load " + this.myType + " console history from: " + file.getPath(), (Throwable)ex);
                    boolean bl = false;
                    return bl;
                }
                LOG.error((Throwable)ex);
            }
            finally {
                if (xmlReader != null) {
                    xmlReader.close();
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void saveHistory() {
            File file = new File(this.getHistoryFilePath(this.myId));
            File dir = file.getParentFile();
            if (!dir.exists() && !dir.mkdirs() || !dir.isDirectory()) {
                LOG.error("failed to create folder: " + dir.getAbsolutePath());
                return;
            }
            OutputStream os = null;
            try {
                XmlSerializer serializer = XmlPullParserFactory.newInstance().newSerializer();
                try {
                    serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                os = new SafeFileOutputStream(file);
                serializer.setOutput(os, "UTF-8");
                this.saveHistory(serializer);
                serializer.flush();
            }
            catch (Exception ex) {
                LOG.error((Throwable)ex);
            }
            finally {
                try {
                    os.close();
                }
                catch (Exception ignored) {}
            }
            ConsoleHistoryController.cleanupOldFiles(dir);
        }

        @Nullable
        private String loadHistory(HierarchicalStreamReader in, String expectedId) {
            if (!in.getNodeName().equals("console-history")) {
                return null;
            }
            int version = StringUtil.parseInt((String)in.getAttribute("version"), (int)0);
            String id = in.getAttribute("id");
            if (!expectedId.equals(id)) {
                return null;
            }
            ArrayList entries = ContainerUtil.newArrayList();
            String consoleContent = null;
            while (in.hasMoreChildren()) {
                in.moveDown();
                if ("history-entry".equals(in.getNodeName())) {
                    entries.add(StringUtil.notNullize((String)in.getValue()));
                } else if ("console-content".equals(in.getNodeName())) {
                    consoleContent = StringUtil.notNullize((String)in.getValue());
                }
                in.moveUp();
            }
            ListIterator iterator = entries.listIterator(entries.size());
            while (iterator.hasPrevious()) {
                String entry = (String)iterator.previous();
                this.getModel().addToHistory(entry);
            }
            return consoleContent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void saveHistory(XmlSerializer out) throws IOException {
            out.startDocument("UTF-8", null);
            out.startTag(null, "console-history");
            out.attribute(null, "version", String.valueOf(1));
            out.attribute(null, "id", this.myId);
            try {
                for (String s : this.getModel().getHistory()) {
                    ConsoleHistoryController.textTag(out, "history-entry", s);
                }
                String current = this.myContent;
                if (StringUtil.isNotEmpty((String)current)) {
                    ConsoleHistoryController.textTag(out, "console-content", current);
                }
            }
            finally {
                out.endTag(null, "console-history");
                out.endDocument();
            }
        }
    }

    private class MyBrowseAction
    extends AnAction {
        private MyBrowseAction() {
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(ConsoleHistoryController.this.getModel().getHistorySize() > 0);
        }

        public void actionPerformed(AnActionEvent e) {
            String s1 = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ConsoleHistoryController.this.myHistoryNext);
            String s2 = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ConsoleHistoryController.this.myHistoryPrev);
            String title = ConsoleHistoryController.this.myConsole.getTitle() + " History" + (StringUtil.isNotEmpty((String)s1) && StringUtil.isNotEmpty((String)s2) ? " (" + s1 + " and " + s2 + " while in editor)" : "");
            ContentChooser<String> chooser = new ContentChooser<String>(ConsoleHistoryController.this.myConsole.getProject(), title, true){

                @Override
                protected void removeContentAt(String content) {
                    ConsoleHistoryController.this.getModel().removeFromHistory(content);
                }

                @Override
                protected String getStringRepresentationFor(String content) {
                    return content;
                }

                @Override
                protected List<String> getContents() {
                    return ConsoleHistoryController.this.getModel().getHistory();
                }

                @Override
                protected Editor createIdeaEditor(String text) {
                    PsiFile consoleFile = ConsoleHistoryController.this.myConsole.getFile();
                    Language language = consoleFile.getLanguage();
                    Project project = consoleFile.getProject();
                    PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText("a." + consoleFile.getFileType().getDefaultExtension(), language, (CharSequence)StringUtil.convertLineSeparators((String)new String(text)), false, true);
                    VirtualFile virtualFile = psiFile.getViewProvider().getVirtualFile();
                    if (virtualFile instanceof LightVirtualFile) {
                        ((LightVirtualFile)virtualFile).setWritable(false);
                    }
                    Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
                    EditorFactory editorFactory = EditorFactory.getInstance();
                    EditorEx editor = (EditorEx)editorFactory.createViewer(document, project);
                    editor.getSettings().setFoldingOutlineShown(false);
                    editor.getSettings().setLineMarkerAreaShown(false);
                    editor.getSettings().setIndentGuidesShown(false);
                    SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)language, (Project)project, (VirtualFile)psiFile.getViewProvider().getVirtualFile());
                    editor.setHighlighter(new LexerEditorHighlighter(highlighter, editor.getColorsScheme()));
                    return editor;
                }
            };
            chooser.setContentIcon(null);
            chooser.setSplitterOrientation(false);
            chooser.setSelectedIndex(Math.max(ConsoleHistoryController.this.getModel().getHistoryCursor(), 0));
            chooser.show();
            if (chooser.isOK()) {
                ConsoleHistoryController.this.setConsoleText(chooser.getSelectedText(), false, true);
            }
        }
    }

    private class MyAction
    extends AnAction {
        private final boolean myNext;

        public MyAction(boolean next) {
            this.myNext = next;
            this.getTemplatePresentation().setVisible(false);
        }

        public void actionPerformed(AnActionEvent e) {
            String command;
            if (this.myNext) {
                command = ConsoleHistoryController.this.getModel().getHistoryNext();
                if (!ConsoleHistoryController.this.myMultiline && command == null) {
                    return;
                }
            } else {
                if (!ConsoleHistoryController.this.myMultiline && ConsoleHistoryController.this.getModel().getHistoryCursor() < 0) {
                    return;
                }
                command = (String)ObjectUtils.chooseNotNull((Object)ConsoleHistoryController.this.getModel().getHistoryPrev(), (Object)(ConsoleHistoryController.this.myMultiline ? "" : StringUtil.notNullize((String)ConsoleHistoryController.this.myHelper.getContent())));
            }
            ConsoleHistoryController.this.setConsoleText(command, this.myNext && ConsoleHistoryController.this.getModel().getHistoryCursor() == 0, true);
        }

        public void update(AnActionEvent e) {
            super.update(e);
            e.getPresentation().setEnabled(ConsoleHistoryController.this.myMultiline || ConsoleHistoryController.this.canMoveInEditor(this.myNext));
        }
    }
}

