/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.execution.Executor;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.openapi.project.Project;
import com.intellij.util.config.Storage;
import java.util.Collection;
import org.jetbrains.annotations.Nullable;

public abstract class JavaAwareTestConsoleProperties
extends TestConsoleProperties {
    public JavaAwareTestConsoleProperties(Storage storage, Project project, Executor executor) {
        super(storage, project, executor);
    }

    @Override
    public boolean isPaused() {
        DebuggerSession debuggerSession = this.getDebugSession();
        return debuggerSession != null && debuggerSession.isPaused();
    }

    @Nullable
    public DebuggerSession getDebugSession() {
        DebuggerManagerEx debuggerManager = DebuggerManagerEx.getInstanceEx(this.getProject());
        if (debuggerManager == null) {
            return null;
        }
        Collection<DebuggerSession> sessions = debuggerManager.getSessions();
        for (DebuggerSession debuggerSession : sessions) {
            if (this.getConsole() != debuggerSession.getProcess().getExecutionResult().getExecutionConsole()) continue;
            return debuggerSession;
        }
        return null;
    }
}

