/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.application.ApplicationStarter;
import com.intellij.openapi.application.ApplicationStarterEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.projectImport.ProjectOpenProcessor;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandLineProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.CommandLineProcessor");

    private CommandLineProcessor() {
    }

    public static void openFileOrProject(final String name) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (name != null) {
                    CommandLineProcessor.doOpenFileOrProject(name);
                }
            }
        });
    }

    @Nullable
    private static Project doOpenFileOrProject(String name) {
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(name);
        if (virtualFile == null) {
            Messages.showErrorDialog((String)("Cannot find file '" + name + "'"), (String)"Cannot find file");
            return null;
        }
        ProjectOpenProcessor provider = ProjectOpenProcessor.getImportProvider((VirtualFile)virtualFile);
        if (provider instanceof PlatformProjectOpenProcessor && !virtualFile.isDirectory()) {
            provider = null;
        }
        if (provider != null || name.endsWith(".ipr") || new File(name, ".idea").exists()) {
            Project result = ProjectUtil.openOrImport(name, null, true);
            if (result == null) {
                Messages.showErrorDialog((String)("Cannot open project '" + name + "'"), (String)"Cannot open project");
            }
            return result;
        }
        return CommandLineProcessor.doOpenFile(virtualFile, -1);
    }

    @Nullable
    private static Project doOpenFile(VirtualFile virtualFile, int line) {
        Project[] projects = ProjectManager.getInstance().getOpenProjects();
        if (projects.length == 0) {
            PlatformProjectOpenProcessor processor = PlatformProjectOpenProcessor.getInstanceIfItExists();
            if (processor != null) {
                return PlatformProjectOpenProcessor.doOpenProject(virtualFile, null, false, line, null, false);
            }
            Messages.showErrorDialog((String)"No project found to open file in", (String)"Cannot open file");
            return null;
        }
        Project project = CommandLineProcessor.findBestProject(virtualFile, projects);
        if (line == -1) {
            new OpenFileDescriptor(project, virtualFile).navigate(true);
        } else {
            new OpenFileDescriptor(project, virtualFile, line - 1, 0).navigate(true);
        }
        return project;
    }

    @NotNull
    private static Project findBestProject(VirtualFile virtualFile, Project[] projects) {
        for (Project aProject : projects) {
            if (!ProjectRootManager.getInstance((Project)aProject).getFileIndex().isInContent(virtualFile)) continue;
            Project project = aProject;
            if (project == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/CommandLineProcessor", "findBestProject"));
            }
            return project;
        }
        IdeFrame frame = IdeFocusManager.getGlobalInstance().getLastFocusedFrame();
        Project project = frame == null ? null : frame.getProject();
        Project project2 = project != null ? project : projects[0];
        if (project2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/CommandLineProcessor", "findBestProject"));
        }
        return project2;
    }

    @Nullable
    public static Project processExternalCommandLine(List<String> args, @Nullable String currentDirectory) {
        if (args.size() > 0) {
            LOG.info("External command line:");
            LOG.info("Dir: " + currentDirectory);
            for (String arg : args) {
                LOG.info(arg);
            }
        }
        LOG.info("-----");
        if (args.size() > 0) {
            String command = args.get(0);
            for (ApplicationStarter starter : (ApplicationStarter[])Extensions.getExtensions((ExtensionPointName)ApplicationStarter.EP_NAME)) {
                if (!command.equals(starter.getCommandName()) || !(starter instanceof ApplicationStarterEx) || !((ApplicationStarterEx)starter).canProcessExternalCommandLine()) continue;
                LOG.info("Processing command with " + starter);
                ((ApplicationStarterEx)starter).processExternalCommandLine(ArrayUtil.toStringArray(args), currentDirectory);
                return null;
            }
        }
        Project lastOpenedProject = null;
        int line = -1;
        int argsSize = args.size();
        for (int i = 0; i < argsSize; ++i) {
            String arg = args.get(i);
            if (arg.equals("nosplash")) continue;
            if (arg.equals("-l") || arg.equals("--line")) {
                if (++i == args.size()) break;
                try {
                    line = Integer.parseInt(args.get(i));
                }
                catch (NumberFormatException e) {
                    line = -1;
                }
                continue;
            }
            if (StringUtil.isQuotedString((String)arg)) {
                arg = StringUtil.stripQuotesAroundValue((String)arg);
            }
            if (!new File(arg).isAbsolute()) {
                String string = arg = currentDirectory != null ? new File(currentDirectory, arg).getAbsolutePath() : new File(arg).getAbsolutePath();
            }
            if (line != -1) {
                VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(arg);
                if (virtualFile != null) {
                    lastOpenedProject = CommandLineProcessor.doOpenFile(virtualFile, line);
                    continue;
                }
                Messages.showErrorDialog((String)("Cannot find file '" + arg + "'"), (String)"Cannot find file");
                continue;
            }
            lastOpenedProject = CommandLineProcessor.doOpenFileOrProject(arg);
        }
        return lastOpenedProject;
    }
}

