/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.idea.LoggerFactory;
import com.intellij.idea.Main;
import com.intellij.idea.SocketLock;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ConfigImportHelper;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.win32.IdeaWin32;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.Consumer;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.lang.UrlClassLoader;
import com.sun.jna.Native;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.swing.JOptionPane;
import org.jetbrains.annotations.NonNls;

public class StartupUtil {
    @NonNls
    public static final String NO_SPLASH = "nosplash";
    private static SocketLock ourLock;
    private static final String JAVA_IO_TEMP_DIR = "java.io.tmpdir";

    private StartupUtil() {
    }

    public static boolean shouldShowSplash(String[] args) {
        return !Arrays.asList(args).contains(NO_SPLASH);
    }

    public static boolean isHeadless() {
        return Main.isHeadless();
    }

    public static synchronized void addExternalInstanceListener(Consumer<List<String>> consumer) {
        ourLock.setActivateListener(consumer);
    }

    public static synchronized int getAcquiredPort() {
        return ourLock.getAcquiredPort();
    }

    static void prepareAndStart(String[] args, AppStarter appStarter) {
        boolean canStart;
        boolean newConfigFolder = false;
        if (!Main.isHeadless()) {
            AppUIUtil.updateFrameClass();
            newConfigFolder = !new File(PathManager.getConfigPath()).exists();
        }
        boolean bl = canStart = StartupUtil.checkJdkVersion() && StartupUtil.checkSystemFolders() && StartupUtil.lockSystemFolders(args);
        if (!canStart) {
            System.exit(3);
        }
        if (newConfigFolder) {
            ConfigImportHelper.importConfigsTo(PathManager.getConfigPath());
        }
        Logger.setFactory(LoggerFactory.class);
        Logger log = Logger.getInstance(Main.class);
        StartupUtil.startLogging(log);
        StartupUtil.loadSystemLibraries(log);
        StartupUtil.fixProcessEnvironment(log);
        if (!Main.isHeadless()) {
            AppUIUtil.updateWindowIcon(JOptionPane.getRootFrame());
            AppUIUtil.registerBundledFonts();
        }
        appStarter.start(newConfigFolder);
    }

    private static boolean checkJdkVersion() {
        if (!"true".equals(System.getProperty("idea.no.jre.check"))) {
            try {
                Class.forName("com.sun.jdi.Field");
            }
            catch (ClassNotFoundException e) {
                String message = "'tools.jar' seems to be not in " + ApplicationNamesInfo.getInstance().getProductName() + " classpath.\n" + "Please ensure JAVA_HOME points to JDK rather than JRE.";
                Main.showMessage((String)"JDK Required", (String)message, (boolean)true);
                return false;
            }
            if (StringUtil.containsIgnoreCase((String)System.getProperty("java.vm.name", ""), (String)"OpenJDK") && !SystemInfo.isJavaVersionAtLeast((String)"1.7")) {
                String message = "OpenJDK 6 is not supported. Please use Oracle Java or newer OpenJDK.";
                Main.showMessage((String)"Unsupported JVM", (String)message, (boolean)true);
                return false;
            }
        }
        return true;
    }

    private static synchronized boolean checkSystemFolders() {
        String configPath = PathManager.getConfigPath();
        PathManager.ensureConfigFolderExists();
        if (!new File(configPath).isDirectory()) {
            String message = "Config path '" + configPath + "' is invalid.\n" + "If you have modified the '" + "idea.config.path" + "' property please make sure it is correct,\n" + "otherwise please re-install the IDE.";
            Main.showMessage((String)"Invalid Config Path", (String)message, (boolean)true);
            return false;
        }
        String systemPath = PathManager.getSystemPath();
        if (!new File(systemPath).isDirectory()) {
            String message = "System path '" + systemPath + "' is invalid.\n" + "If you have modified the '" + "idea.system.path" + "' property please make sure it is correct,\n" + "otherwise please re-install the IDE.";
            Main.showMessage((String)"Invalid System Path", (String)message, (boolean)true);
            return false;
        }
        File ideTempDir = new File(PathManager.getTempPath());
        String tempInaccessible = null;
        if (!ideTempDir.isDirectory() && !ideTempDir.mkdirs()) {
            tempInaccessible = "unable to create the directory";
        } else {
            try {
                File ideTempFile = new File(ideTempDir, "idea_tmp_check.sh");
                FileUtil.writeToFile((File)ideTempFile, (String)"#!/bin/sh\nexit 0");
                if (SystemInfo.isWindows || SystemInfo.isMac) {
                    tempInaccessible = null;
                } else if (!ideTempFile.setExecutable(true, true)) {
                    tempInaccessible = "cannot set executable permission";
                } else if (new ProcessBuilder(ideTempFile.getAbsolutePath()).start().waitFor() != 0) {
                    tempInaccessible = "cannot execute test script";
                }
                if (!FileUtilRt.delete((File)ideTempFile)) {
                    ideTempFile.deleteOnExit();
                }
            }
            catch (Exception e) {
                tempInaccessible = e.getClass().getSimpleName() + ": " + e.getMessage();
            }
        }
        if (tempInaccessible != null) {
            String message = "Temp directory '" + ideTempDir + "' is inaccessible.\n" + "If you have modified the '" + "idea.system.path" + "' property please make sure it is correct,\n" + "otherwise please re-install the IDE.\n\nDetails: " + tempInaccessible;
            Main.showMessage((String)"Invalid System Path", (String)message, (boolean)true);
            return false;
        }
        return true;
    }

    private static synchronized boolean lockSystemFolders(String[] args) {
        SocketLock.ActivateStatus activateStatus;
        if (ourLock == null) {
            ourLock = new SocketLock();
        }
        if ((activateStatus = ourLock.lock(PathManager.getConfigPath(), true, args)) == SocketLock.ActivateStatus.NO_INSTANCE) {
            activateStatus = ourLock.lock(PathManager.getSystemPath(), false, new String[0]);
        }
        if (activateStatus != SocketLock.ActivateStatus.NO_INSTANCE) {
            if (Main.isHeadless() || activateStatus == SocketLock.ActivateStatus.CANNOT_ACTIVATE) {
                String message = "Only one instance of " + ApplicationNamesInfo.getInstance().getFullProductName() + " can be run at a time.";
                Main.showMessage((String)"Too Many Instances", (String)message, (boolean)true);
            }
            return false;
        }
        return true;
    }

    private static void fixProcessEnvironment(Logger log) {
        boolean envReady;
        if (!Main.isCommandLine()) {
            System.setProperty("__idea.mac.env.lock", "unlocked");
        }
        if (!(envReady = EnvironmentUtil.isEnvironmentReady())) {
            log.info("initializing environment");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadSystemLibraries(Logger log) {
        File ideTempDir = new File(PathManager.getTempPath());
        if (!ideTempDir.mkdirs() && !ideTempDir.exists()) {
            throw new RuntimeException("Unable to create temp directory '" + ideTempDir + "'");
        }
        String javaTempDir = System.getProperty(JAVA_IO_TEMP_DIR);
        try {
            System.setProperty(JAVA_IO_TEMP_DIR, ideTempDir.getPath());
            if (System.getProperty("jna.nosys") == null && System.getProperty("jna.nounpack") == null) {
                System.setProperty("jna.nosys", "true");
                System.setProperty("jna.nounpack", "false");
            }
            try {
                long t = System.currentTimeMillis();
                log.info("JNA library loaded (" + Native.POINTER_SIZE * 8 + "-bit) in " + (System.currentTimeMillis() - t) + " ms");
            }
            catch (Throwable t) {
                StartupUtil.logError(log, "Unable to load JNA library", t);
            }
        }
        finally {
            System.setProperty(JAVA_IO_TEMP_DIR, javaTempDir);
        }
        if (SystemInfo.isWin2kOrNewer) {
            IdeaWin32.isAvailable();
        }
        if (SystemInfo.isWin2kOrNewer && !Main.isHeadless()) {
            try {
                UrlClassLoader.loadPlatformLibrary((String)"focusKiller");
                log.info("Using \"FocusKiller\" library to prevent focus stealing.");
            }
            catch (Throwable t) {
                log.info("\"FocusKiller\" library not found or there were problems loading it.", t);
            }
        }
    }

    private static void logError(Logger log, String message, Throwable t) {
        message = message + " (OS: " + SystemInfo.OS_NAME + " " + SystemInfo.OS_VERSION + ")";
        log.error(message, t);
    }

    private static void startLogging(final Logger log) {
        Runtime.getRuntime().addShutdownHook(new Thread("Shutdown hook - logging"){

            @Override
            public void run() {
                log.info("------------------------------------------------------ IDE SHUTDOWN ------------------------------------------------------");
            }
        });
        log.info("------------------------------------------------------ IDE STARTED ------------------------------------------------------");
        ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
        ApplicationNamesInfo namesInfo = ApplicationNamesInfo.getInstance();
        String buildDate = new SimpleDateFormat("dd MMM yyyy HH:ss", Locale.US).format(appInfo.getBuildDate().getTime());
        log.info("IDE: " + namesInfo.getFullProductName() + " (build #" + appInfo.getBuild().asStringWithAllDetails() + ", " + buildDate + ")");
        log.info("OS: " + SystemInfoRt.OS_NAME + " (" + SystemInfoRt.OS_VERSION + ", " + SystemInfo.OS_ARCH + ")");
        log.info("JRE: " + System.getProperty("java.runtime.version", "-") + " (" + System.getProperty("java.vendor", "-") + ")");
        log.info("JVM: " + System.getProperty("java.vm.version", "-") + " (" + System.getProperty("java.vm.name", "-") + ")");
        List<String> arguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
        if (arguments != null) {
            log.info("JVM Args: " + StringUtil.join(arguments, (String)" "));
        }
    }

    static interface AppStarter {
        public void start(boolean var1);
    }
}

