/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StateStorageException;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.ComponentVersionProvider;
import com.intellij.openapi.components.impl.stores.StorageData;
import com.intellij.openapi.components.impl.stores.StorageUtil;
import com.intellij.openapi.components.impl.stores.StreamProvider;
import com.intellij.openapi.components.impl.stores.XmlElementStorage;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.tracker.VirtualFileTracker;
import com.intellij.util.LineSeparator;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.Collections;
import java.util.Set;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Parent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileBasedStorage
extends XmlElementStorage {
    private final String myFilePath;
    private final File myFile;
    private volatile VirtualFile myCachedVirtualFile;
    private LineSeparator myLineSeparator;

    public FileBasedStorage(@NotNull String filePath, @NotNull String fileSpec, @Nullable RoamingType roamingType, @Nullable TrackingPathMacroSubstitutor pathMacroManager, @NotNull String rootElementName, @NotNull Disposable parentDisposable, final @Nullable StateStorage.Listener listener, @Nullable StreamProvider streamProvider, ComponentVersionProvider componentVersionProvider) {
        VirtualFileTracker virtualFileTracker;
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/components/impl/stores/FileBasedStorage", "<init>"));
        }
        if (fileSpec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSpec", "com/intellij/openapi/components/impl/stores/FileBasedStorage", "<init>"));
        }
        if (rootElementName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElementName", "com/intellij/openapi/components/impl/stores/FileBasedStorage", "<init>"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/components/impl/stores/FileBasedStorage", "<init>"));
        }
        super(fileSpec, roamingType, pathMacroManager, rootElementName, streamProvider, componentVersionProvider);
        this.myFilePath = filePath;
        this.myFile = new File(filePath);
        if (listener != null && (virtualFileTracker = (VirtualFileTracker)ServiceManager.getService(VirtualFileTracker.class)) != null) {
            virtualFileTracker.addTracker("file://" + this.myFile.getAbsolutePath().replace(File.separatorChar, '/'), (VirtualFileListener)new VirtualFileAdapter(){

                public void fileMoved(@NotNull VirtualFileMoveEvent event) {
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/components/impl/stores/FileBasedStorage$1", "fileMoved"));
                    }
                    FileBasedStorage.this.myCachedVirtualFile = null;
                }

                public void fileDeleted(@NotNull VirtualFileEvent event) {
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/components/impl/stores/FileBasedStorage$1", "fileDeleted"));
                    }
                    FileBasedStorage.this.myCachedVirtualFile = null;
                }

                public void fileCreated(@NotNull VirtualFileEvent event) {
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/components/impl/stores/FileBasedStorage$1", "fileCreated"));
                    }
                    FileBasedStorage.this.myCachedVirtualFile = event.getFile();
                }

                public void contentsChanged(@NotNull VirtualFileEvent event) {
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/components/impl/stores/FileBasedStorage$1", "contentsChanged"));
                    }
                    assert (listener != null);
                    listener.storageFileChanged(event, (StateStorage)FileBasedStorage.this);
                }
            }, false, parentDisposable);
        }
    }

    protected boolean isUseXmlProlog() {
        return false;
    }

    protected boolean isUseLfLineSeparatorByDefault() {
        return this.isUseXmlProlog();
    }

    @Override
    protected XmlElementStorage.XmlElementStorageSaveSession createSaveSession(@NotNull StorageData storageData) {
        if (storageData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageData", "com/intellij/openapi/components/impl/stores/FileBasedStorage", "createSaveSession"));
        }
        return new FileSaveSession(storageData);
    }

    @Override
    @NotNull
    protected StorageData createStorageData() {
        FileStorageData data = new FileStorageData(this.myRootElementName);
        data.myFilePath = this.myFilePath;
        FileStorageData fileStorageData = data;
        if (fileStorageData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/FileBasedStorage", "createStorageData"));
        }
        return fileStorageData;
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myCachedVirtualFile;
        if (virtualFile == null) {
            this.myCachedVirtualFile = virtualFile = LocalFileSystem.getInstance().findFileByIoFile(this.myFile);
        }
        return virtualFile;
    }

    @NotNull
    public File getFile() {
        File file = this.myFile;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/FileBasedStorage", "getFile"));
        }
        return file;
    }

    @NotNull
    public String getFilePath() {
        String string = this.myFilePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/FileBasedStorage", "getFilePath"));
        }
        return string;
    }

    @Override
    @Nullable
    protected Element loadLocalData() {
        this.myBlockSavingTheContent = false;
        try {
            VirtualFile file = this.getVirtualFile();
            if (file == null || file.isDirectory() || !file.isValid()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Document was not loaded for " + this.myFileSpec + " file is " + (file == null ? "null" : "directory"));
                }
                return null;
            }
            if (file.getLength() == 0L) {
                return this.processReadException(null);
            }
            CharBuffer charBuffer = CharsetToolkit.UTF8_CHARSET.decode(ByteBuffer.wrap(file.contentsToByteArray()));
            this.myLineSeparator = StorageUtil.detectLineSeparators(charBuffer, this.isUseLfLineSeparatorByDefault() ? null : LineSeparator.LF);
            return JDOMUtil.loadDocument((CharSequence)charBuffer).getRootElement();
        }
        catch (JDOMException e) {
            return this.processReadException((Exception)((Object)e));
        }
        catch (IOException e) {
            return this.processReadException(e);
        }
    }

    @Nullable
    private Element processReadException(@Nullable Exception e) {
        boolean contentTruncated = e == null;
        boolean bl = this.myBlockSavingTheContent = this.isProjectOrModuleOrWorkspaceFile() && !contentTruncated;
        if (!ApplicationManager.getApplication().isUnitTestMode() && !ApplicationManager.getApplication().isHeadlessEnvironment()) {
            if (e != null) {
                LOG.info((Throwable)e);
            }
            Notifications.Bus.notify((Notification)new Notification("System Messages", "Load Settings", "Cannot load settings from file '" + this.myFile.getPath() + "': " + (e == null ? "content truncated" : e.getLocalizedMessage()) + "\n" + this.getInvalidContentMessage(contentTruncated), NotificationType.WARNING));
        }
        return null;
    }

    private boolean isProjectOrModuleOrWorkspaceFile() {
        return StorageUtil.isProjectOrModuleFile(this.myFileSpec) || this.myFileSpec.equals("$WORKSPACE_FILE$");
    }

    private String getInvalidContentMessage(boolean contentTruncated) {
        return this.isProjectOrModuleOrWorkspaceFile() && !contentTruncated ? "Please correct the file content" : "File content will be recreated";
    }

    @Override
    public void setDefaultState(Element element) {
        element.setName(this.myRootElementName);
        super.setDefaultState(element);
    }

    public void updatedFromStreamProvider(@NotNull Set<String> changedComponentNames, boolean deleted) {
        if (changedComponentNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedComponentNames", "com/intellij/openapi/components/impl/stores/FileBasedStorage", "updatedFromStreamProvider"));
        }
        if (this.myRoamingType == RoamingType.DISABLED) {
            return;
        }
        this.resetProviderCache();
        try {
            Element newElement;
            Element element = newElement = deleted ? null : this.loadDataFromStreamProvider();
            if (newElement == null) {
                StorageUtil.deleteFile(this.myFile, this, this.myCachedVirtualFile);
                if (this.myLoadedData != null) {
                    changedComponentNames.addAll(this.myLoadedData.getComponentNames());
                    this.myLoadedData = null;
                }
            } else if (this.myLoadedData != null) {
                StorageData newStorageData = this.createStorageData();
                this.loadState(newStorageData, newElement);
                changedComponentNames.addAll(this.myLoadedData.getChangedComponentNames(newStorageData, this.myPathMacroSubstitutor));
                this.myLoadedData = newStorageData;
            }
        }
        catch (Throwable e) {
            LOG.error(e);
        }
    }

    @Deprecated
    @Nullable
    public File updateFileExternallyFromStreamProviders() throws IOException {
        Element element = this.getElement(this.loadData(true), true, Collections.<String, Element>emptyMap());
        if (element == null) {
            FileUtil.delete((File)this.myFile);
            return null;
        }
        BufferExposingByteArrayOutputStream out = StorageUtil.newContentIfDiffers((Parent)element, this.getVirtualFile());
        if (out == null) {
            return null;
        }
        File file = new File(this.myFile.getAbsolutePath());
        FileUtil.writeToFile((File)file, (byte[])out.getInternalBuffer(), (int)0, (int)out.size());
        return file;
    }

    public String toString() {
        return this.getFilePath();
    }

    public static class FileStorageData
    extends StorageData {
        String myFilePath;

        public FileStorageData(String rootElementName) {
            super(rootElementName);
        }

        protected FileStorageData(FileStorageData storageData) {
            super(storageData);
            this.myFilePath = storageData.myFilePath;
        }

        @Override
        public StorageData clone() {
            return new FileStorageData(this);
        }

        @NonNls
        public String toString() {
            return "FileStorageData[" + this.myFilePath + "]";
        }
    }

    private class FileSaveSession
    extends XmlElementStorage.XmlElementStorageSaveSession {
        protected FileSaveSession(StorageData storageData) {
            if (storageData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageData", "com/intellij/openapi/components/impl/stores/FileBasedStorage$FileSaveSession", "<init>"));
            }
            super(FileBasedStorage.this, storageData);
        }

        @Override
        protected void doSave(@Nullable Element element) throws IOException {
            BufferExposingByteArrayOutputStream content;
            if (FileBasedStorage.this.myLineSeparator == null) {
                FileBasedStorage.this.myLineSeparator = FileBasedStorage.this.isUseLfLineSeparatorByDefault() ? LineSeparator.LF : LineSeparator.getSystemLineSeparator();
            }
            BufferExposingByteArrayOutputStream bufferExposingByteArrayOutputStream = content = element == null ? null : StorageUtil.writeToBytes((Parent)element, FileBasedStorage.this.myLineSeparator.getSeparatorString());
            if (ApplicationManager.getApplication().isUnitTestMode() && StringUtil.startsWithChar((CharSequence)FileBasedStorage.this.myFile.getPath(), (char)'$')) {
                throw new StateStorageException("It seems like some macros were not expanded for path: " + FileBasedStorage.this.myFile.getPath());
            }
            try {
                if (FileBasedStorage.this.myStreamProvider != null && FileBasedStorage.this.myStreamProvider.isEnabled()) {
                    this.saveForProvider((BufferExposingByteArrayOutputStream)(FileBasedStorage.this.myLineSeparator == LineSeparator.LF ? content : null), element);
                }
            }
            catch (Throwable e) {
                XmlElementStorage.LOG.error(e);
            }
            if (XmlElementStorage.LOG.isDebugEnabled() && FileBasedStorage.this.myFileSpec.equals("$MODULE_FILE$")) {
                XmlElementStorage.LOG.debug("doSave " + FileBasedStorage.this.getFilePath());
            }
            if (content == null) {
                StorageUtil.deleteFile(FileBasedStorage.this.myFile, this, FileBasedStorage.this.getVirtualFile());
                FileBasedStorage.this.myCachedVirtualFile = null;
            } else {
                VirtualFile file = FileBasedStorage.this.getVirtualFile();
                if (file == null || !file.exists()) {
                    FileUtil.createParentDirs((File)FileBasedStorage.this.myFile);
                    file = null;
                }
                FileBasedStorage.this.myCachedVirtualFile = StorageUtil.writeFile(FileBasedStorage.this.myFile, this, file, content, FileBasedStorage.this.isUseXmlProlog() ? FileBasedStorage.this.myLineSeparator : null);
            }
        }
    }
}

