/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.actions;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.diff.DiffElement;
import com.intellij.ide.diff.DirDiffSettings;
import com.intellij.ide.diff.VirtualFileDiffElement;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diff.DirDiffManager;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;

public class CompareDirectoriesAction
extends DumbAwareAction {
    public static final String LAST_USED_KEY = "dir.diff.last.used.directory";

    public void actionPerformed(AnActionEvent e) {
        Project project = CompareDirectoriesAction.getEventProject((AnActionEvent)e);
        VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        FeatureUsageTracker.getInstance().triggerFeatureUsed("dir.diff");
        if (project != null && files != null) {
            VirtualFileDiffElement src = null;
            VirtualFileDiffElement trg = null;
            if (files.length == 2 && files[0].isDirectory() && files[1].isDirectory()) {
                src = new VirtualFileDiffElement(files[0]);
                trg = new VirtualFileDiffElement(files[1]);
            } else if (files.length == 1 && files[0].isDirectory()) {
                VirtualFile[] result;
                src = new VirtualFileDiffElement(files[0]);
                FileChooserDescriptor descriptor = new FileChooserDescriptor(false, true, false, false, false, false);
                String path = PropertiesComponent.getInstance((Project)project).getValue(LAST_USED_KEY);
                VirtualFile toSelect = null;
                if (path != null) {
                    toSelect = LocalFileSystem.getInstance().findFileByPath(path);
                }
                if (toSelect == null) {
                    toSelect = project.getBaseDir();
                }
                if ((result = FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)project, (VirtualFile)toSelect)).length == 1 && result[0] != null && result[0].isDirectory()) {
                    PropertiesComponent.getInstance((Project)project).setValue(LAST_USED_KEY, result[0].getPath());
                    trg = new VirtualFileDiffElement(result[0]);
                }
            }
            DirDiffManager mgr = DirDiffManager.getInstance((Project)project);
            if (src != null && trg != null && mgr.canShow(src, trg)) {
                mgr.showDiff((DiffElement)src, (DiffElement)trg, new DirDiffSettings(), null);
            }
        }
    }

    public void update(AnActionEvent e) {
        VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (files != null && files.length > 0 && files.length < 3 && files[0].isDirectory() && (files.length == 1 || files[1].isDirectory())) {
            e.getPresentation().setEnabled(true);
            e.getPresentation().setVisible(true);
            e.getPresentation().setText(files.length == 1 ? "Compare Directory with..." : "Compare Directories");
            return;
        }
        e.getPresentation().setEnabled(false);
        e.getPresentation().setVisible(false);
    }
}

