/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.internal;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import java.io.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InternalExternalProjectInfo
implements ExternalProjectInfo,
Serializable {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final ProjectSystemId myProjectSystemId;
    @NotNull
    private final String myExternalProjectPath;
    @Nullable
    private DataNode<ProjectData> myExternalProjectStructure;
    private long lastSuccessfulImportTimestamp;
    private long lastImportTimestamp;

    public InternalExternalProjectInfo(@NotNull ProjectSystemId projectSystemId, @NotNull String externalProjectPath, @Nullable DataNode<ProjectData> externalProjectStructure) {
        if (projectSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectSystemId", "com/intellij/openapi/externalSystem/model/internal/InternalExternalProjectInfo", "<init>"));
        }
        if (externalProjectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalProjectPath", "com/intellij/openapi/externalSystem/model/internal/InternalExternalProjectInfo", "<init>"));
        }
        this.lastSuccessfulImportTimestamp = -1L;
        this.lastImportTimestamp = -1L;
        this.myProjectSystemId = projectSystemId;
        this.myExternalProjectPath = externalProjectPath;
        this.myExternalProjectStructure = externalProjectStructure;
    }

    @NotNull
    public ProjectSystemId getProjectSystemId() {
        ProjectSystemId projectSystemId = this.myProjectSystemId;
        if (projectSystemId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/internal/InternalExternalProjectInfo", "getProjectSystemId"));
        }
        return projectSystemId;
    }

    @NotNull
    public String getExternalProjectPath() {
        String string = this.myExternalProjectPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/internal/InternalExternalProjectInfo", "getExternalProjectPath"));
        }
        return string;
    }

    @Nullable
    public DataNode<ProjectData> getExternalProjectStructure() {
        return this.myExternalProjectStructure;
    }

    public long getLastSuccessfulImportTimestamp() {
        return this.lastSuccessfulImportTimestamp;
    }

    public long getLastImportTimestamp() {
        return this.lastImportTimestamp;
    }

    public void setExternalProjectStructure(@Nullable DataNode<ProjectData> externalProjectStructure) {
        this.myExternalProjectStructure = externalProjectStructure;
    }

    public void setLastSuccessfulImportTimestamp(long lastSuccessfulImportTimestamp) {
        this.lastSuccessfulImportTimestamp = lastSuccessfulImportTimestamp;
    }

    public void setLastImportTimestamp(long lastImportTimestamp) {
        this.lastImportTimestamp = lastImportTimestamp;
    }
}

