/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.impl.EditorTabbedContainer;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowContentUiType;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.docking.DockManager;
import com.intellij.util.ArrayUtil;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.EnumSet;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PreviewPanel
extends JPanel {
    private CardLayout myLayout;
    private static final Key<VirtualFile> FILE_KEY = Key.create((String)"v_file");
    private static final int HISTORY_LIMIT = 10;
    private final Project myProject;
    private final FileEditorManagerImpl myManager;
    private final DockManager myDockManager;
    private EditorWindow myWindow;
    private EditorsSplitters myEditorsSplitters;
    private ArrayList<VirtualFile> myHistory = new ArrayList();
    private VirtualFile myModifiedFile = null;
    private ToolWindowImpl myToolWindow;
    private VirtualFile myAwaitingForOpen = null;
    private ContentManager myContentManager;
    private Content myStubContent;
    private boolean myBlocked = false;
    private EnumSet<ContentType> myTypes = EnumSet.noneOf(ContentType.class);

    static boolean isAvailable() {
        return false;
    }

    PreviewPanel(Project project, FileEditorManagerImpl manager, DockManager dockManager) {
        this.myProject = project;
        this.myManager = manager;
        this.myDockManager = dockManager;
    }

    @Nullable
    EditorWindow getWindow() {
        if (!PreviewPanel.isAvailable() || this.isBlocked() || this.myProject.isDisposed()) {
            return null;
        }
        this.initToolWindowIfNeed();
        return this.myWindow;
    }

    boolean isBlocked() {
        return this.myBlocked;
    }

    private void initToolWindowIfNeed() {
        if (!PreviewPanel.isAvailable() || ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(ToolWindowId.PREVIEW) != null) {
            return;
        }
        this.myToolWindow = (ToolWindowImpl)ToolWindowManager.getInstance((Project)this.myProject).registerToolWindow(ToolWindowId.PREVIEW, (JComponent)this, ToolWindowAnchor.RIGHT, (Disposable)this.myProject, false);
        UISettings.getInstance().addUISettingsListener(new UISettingsListener(){

            public void uiSettingsChanged(UISettings source) {
                if (!PreviewPanel.isAvailable()) {
                    VirtualFile[] files;
                    for (VirtualFile file : files = PreviewPanel.this.myWindow.getFiles()) {
                        PreviewPanel.this.close(file);
                    }
                    ToolWindowManager.getInstance((Project)PreviewPanel.this.myProject).unregisterToolWindow(ToolWindowId.PREVIEW);
                }
            }
        }, (Disposable)this.myProject);
        this.myToolWindow.setIcon(AllIcons.Actions.PreviewDetails);
        this.myToolWindow.setContentUiType(ToolWindowContentUiType.COMBO, null);
        this.myContentManager = this.myToolWindow.getContentManager();
        this.myStubContent = this.myContentManager.getContent(0);
        this.myContentManager.addContentManagerListener((ContentManagerListener)new ContentManagerAdapter(){

            public void selectionChanged(ContentManagerEvent event) {
                final VirtualFile file = (VirtualFile)event.getContent().getUserData(FILE_KEY);
                if (event.getOperation() == ContentManagerEvent.ContentOperation.remove && file != null && file.equals(PreviewPanel.this.myModifiedFile)) {
                    PreviewPanel.this.close(file);
                    return;
                }
                if (event.getOperation() != ContentManagerEvent.ContentOperation.add) {
                    return;
                }
                if (file != null) {
                    event.getContent().setComponent((JComponent)PreviewPanel.this);
                    if (!file.equals(PreviewPanel.this.myWindow.getSelectedFile())) {
                        ApplicationManager.getApplication().invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                PreviewPanel.this.myManager.openFileWithProviders(file, false, PreviewPanel.this.myWindow);
                            }
                        });
                    }
                }
            }
        });
        this.myEditorsSplitters = new MyEditorsSplitters();
        this.myProject.getMessageBus().connect().subscribe(FileEditorManagerListener.Before.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener.Before(){

            public void beforeFileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                if (source == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/openapi/fileEditor/impl/PreviewPanel$3", "beforeFileOpened"));
                }
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/PreviewPanel$3", "beforeFileOpened"));
                }
                PreviewPanel.this.myAwaitingForOpen = file;
                VirtualFile currentFile = PreviewPanel.this.getCurrentFile();
                if (currentFile != null && currentFile.equals(PreviewPanel.this.myModifiedFile) && !currentFile.equals(file)) {
                    PreviewPanel.this.close(currentFile);
                }
            }

            public void beforeFileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                if (source == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/openapi/fileEditor/impl/PreviewPanel$3", "beforeFileClosed"));
                }
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/PreviewPanel$3", "beforeFileClosed"));
                }
                PreviewPanel.this.checkStubContent();
            }
        });
        this.myEditorsSplitters.createCurrentWindow();
        this.myWindow = this.myEditorsSplitters.getCurrentWindow();
        this.myWindow.setTabsPlacement(0);
        this.myLayout = new CardLayout();
        this.setLayout(this.myLayout);
        this.add(ContentType.Files.toString(), (Component)((Object)this.myEditorsSplitters));
        this.myToolWindow.setTitleActions(new MoveToEditorTabsAction());
        ArrayList<ContentTypeToggleAction> myGearActions = new ArrayList<ContentTypeToggleAction>();
        for (ContentType contentType : ContentType.values()) {
            myGearActions.add(new ContentTypeToggleAction(contentType));
        }
        this.myToolWindow.setAdditionalGearActions((ActionGroup)new DefaultActionGroup("Preview", myGearActions));
        this.myToolWindow.hide(null);
    }

    @Nullable
    private VirtualFile getCurrentFile() {
        VirtualFile[] files = this.myWindow.getFiles();
        return files.length == 1 ? files[0] : null;
    }

    @NotNull
    private Content addContent(VirtualFile file) {
        this.myHistory.add(file);
        while (this.myHistory.size() > 10) {
            this.myHistory.remove(0);
        }
        String title = StringUtil.getShortened((String)EditorTabbedContainer.calcTabTitle(this.myProject, file), (int)UISettings.getInstance().EDITOR_TAB_TITLE_LIMIT);
        Content content = this.myContentManager.getFactory().createContent((JComponent)this, title, false);
        content.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
        content.putUserData(FILE_KEY, (Object)file);
        content.setIcon(file.getFileType().getIcon());
        content.setPopupIcon(file.getFileType().getIcon());
        this.myContentManager.addContent(content, 0);
        this.checkStubContent();
        Content content2 = content;
        if (content2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/PreviewPanel", "addContent"));
        }
        return content2;
    }

    private void setSelected(VirtualFile file) {
        Content content = this.getContent(file);
        if (content == null) {
            content = this.addContent(file);
        }
        this.myContentManager.setSelectedContent(content);
        this.myContentManager.addContent(content, 0);
    }

    @Nullable
    private Content getContent(VirtualFile file) {
        Content[] contents;
        for (Content content : contents = this.myContentManager.getContents()) {
            if (!file.equals(content.getUserData(FILE_KEY))) continue;
            return content;
        }
        return null;
    }

    private void checkStubContent() {
        if (this.myContentManager.getContents().length == 0) {
            this.myToolWindow.getComponent().putClientProperty("HideIdLabel", "false");
            this.myStubContent.setComponent((JComponent)this);
            this.myContentManager.addContent(this.myStubContent);
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (PreviewPanel.this.myContentManager.getIndexOfContent(PreviewPanel.this.myStubContent) != -1) {
                        PreviewPanel.this.toggleToolWindow(false);
                    }
                }
            });
        } else if (this.myContentManager.getContents().length > 1) {
            this.myToolWindow.getComponent().putClientProperty("HideIdLabel", "true");
            this.myContentManager.removeContent(this.myStubContent, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(@NotNull VirtualFile file) {
        Content content;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/PreviewPanel", "close"));
        }
        this.myHistory.remove(file);
        if (ArrayUtil.find((Object[])this.myEditorsSplitters.getOpenFiles(), (Object)file) != -1) {
            this.myEditorsSplitters.closeFile(file, false);
        }
        if (file.equals(this.myAwaitingForOpen)) {
            this.myAwaitingForOpen = null;
        }
        if (file.equals(this.myModifiedFile)) {
            this.myBlocked = true;
            try {
                this.myManager.openFileWithProviders(this.myModifiedFile, false, true);
            }
            finally {
                this.myBlocked = false;
            }
            this.myModifiedFile = null;
        }
        if ((content = this.getContent(file)) != null) {
            this.myContentManager.removeContent(content, false);
            this.checkStubContent();
        }
    }

    private void toggleToolWindow(boolean activate) {
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(ToolWindowId.PREVIEW);
        if (toolWindow != null) {
            if (activate) {
                toolWindow.activate(null, false);
            } else {
                toolWindow.hide(null);
            }
        }
    }

    private class MyEditorsSplitters
    extends EditorsSplitters {
        public MyEditorsSplitters() {
            super(PreviewPanel.this.myManager, PreviewPanel.this.myDockManager, false);
        }

        @Override
        protected void afterFileOpen(VirtualFile file) {
            if (file.equals(PreviewPanel.this.myAwaitingForOpen)) {
                PreviewPanel.this.setSelected(file);
            }
            PreviewPanel.this.myAwaitingForOpen = null;
        }

        @Override
        protected void afterFileClosed(VirtualFile file) {
            PreviewPanel.this.close(file);
        }

        @Override
        public void updateFileIcon(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/PreviewPanel$MyEditorsSplitters", "updateFileIcon"));
            }
            EditorWithProviderComposite composite = PreviewPanel.this.myWindow.findFileComposite(file);
            if (composite != null && composite.isModified()) {
                PreviewPanel.this.myModifiedFile = file;
            }
        }

        @Override
        protected EditorWindow createEditorWindow() {
            return new EditorWindow(this){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void onBeforeSetEditor(VirtualFile file) {
                    VirtualFile currentFile = MyEditorsSplitters.this.getCurrentFile();
                    if (currentFile != null && currentFile.equals(PreviewPanel.this.myModifiedFile)) {
                        PreviewPanel.this.myBlocked = true;
                        try {
                            PreviewPanel.this.myManager.openFileWithProviders(PreviewPanel.this.myModifiedFile, false, true);
                        }
                        finally {
                            PreviewPanel.this.myBlocked = false;
                        }
                    } else {
                        PreviewPanel.this.toggleToolWindow(true);
                    }
                }
            };
        }

        @Override
        public void setTabsPlacement(int tabPlacement) {
            super.setTabsPlacement(0);
        }

        @Override
        public boolean isPreview() {
            return true;
        }
    }

    private class ContentTypeToggleAction
    extends ToggleAction {
        private final ContentType myContentType;

        ContentTypeToggleAction(ContentType contentType) {
            super(contentType.toString());
            this.myContentType = contentType;
        }

        public boolean isSelected(AnActionEvent e) {
            return PreviewPanel.this.myTypes.contains((Object)this.myContentType);
        }

        public void setSelected(AnActionEvent e, boolean state) {
            if (state) {
                PreviewPanel.this.myTypes.add(this.myContentType);
            } else {
                PreviewPanel.this.myTypes.remove((Object)this.myContentType);
            }
        }
    }

    private class MoveToEditorTabsAction
    extends AnAction {
        public MoveToEditorTabsAction() {
            super("Move to main tabs", "Move to main tabs", AllIcons.Duplicates.SendToTheLeftGrayed);
        }

        public void actionPerformed(AnActionEvent e) {
            VirtualFile virtualFile = PreviewPanel.this.getCurrentFile();
            if (virtualFile == null) {
                return;
            }
            EditorWindow window = PreviewPanel.this.myManager.getCurrentWindow();
            if (window == null) {
                PreviewPanel.this.myManager.getMainSplitters().createCurrentWindow();
                window = PreviewPanel.this.myManager.getCurrentWindow();
            }
            PreviewPanel.this.myManager.openFileWithProviders(virtualFile, true, window);
            PreviewPanel.this.close(virtualFile);
            PreviewPanel.this.toggleToolWindow(false);
        }
    }

    static enum ContentType {
        Files,
        Usages,
        Diagrams,
        Documentation;

    }
}

