/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.ex;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableEP;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.NonDefaultProjectConfigurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigurableWrapper
implements SearchableConfigurable {
    private static final ConfigurableWrapper[] EMPTY_ARRAY = new ConfigurableWrapper[0];
    private static final NullableFunction<ConfigurableEP<Configurable>, Configurable> CONFIGURABLE_FUNCTION = new NullableFunction<ConfigurableEP<Configurable>, Configurable>(){

        public Configurable fun(ConfigurableEP<Configurable> ep) {
            return ConfigurableWrapper.wrapConfigurable(ep);
        }
    };
    private static final Logger LOG = Logger.getInstance(ConfigurableWrapper.class);
    private final ConfigurableEP myEp;
    private UnnamedConfigurable myConfigurable;

    @Nullable
    public static <T extends UnnamedConfigurable> T wrapConfigurable(ConfigurableEP<T> ep) {
        if (!ep.canCreateConfigurable()) {
            return null;
        }
        if (ep.displayName != null || ep.key != null || ep.groupId != null) {
            UnnamedConfigurable configurable = null;
            if (ep.providerClass != null && (configurable = ep.createConfigurable()) == null) {
                return null;
            }
            return (T)(!ep.dynamic && ep.children == null && ep.childrenEPName == null ? new ConfigurableWrapper(ep, configurable) : new CompositeWrapper((ConfigurableEP)ep, configurable, new Configurable[0]));
        }
        return (T)ep.createConfigurable();
    }

    public static <T extends UnnamedConfigurable> List<T> createConfigurables(ExtensionPointName<? extends ConfigurableEP<T>> name) {
        return ContainerUtil.mapNotNull((Object[])name.getExtensions(), (Function)new NullableFunction<ConfigurableEP<T>, T>(){

            public T fun(ConfigurableEP<T> ep) {
                return ConfigurableWrapper.wrapConfigurable(ep);
            }
        });
    }

    public static boolean isNoScroll(Configurable configurable) {
        return ConfigurableWrapper.cast(Configurable.NoScroll.class, (UnnamedConfigurable)configurable) != null;
    }

    public static boolean hasOwnContent(UnnamedConfigurable configurable) {
        SearchableConfigurable.Parent parent = ConfigurableWrapper.cast(SearchableConfigurable.Parent.class, configurable);
        return parent != null && parent.hasOwnContent();
    }

    public static boolean isNonDefaultProject(Configurable configurable) {
        return configurable instanceof NonDefaultProjectConfigurable || configurable instanceof ConfigurableWrapper && ((ConfigurableWrapper)configurable).myEp.nonDefaultProject;
    }

    @Nullable
    public static <T> T cast(@NotNull Class<T> type, UnnamedConfigurable configurable) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/options/ex/ConfigurableWrapper", "cast"));
        }
        if (configurable instanceof ConfigurableWrapper) {
            ConfigurableWrapper wrapper = (ConfigurableWrapper)configurable;
            if (wrapper.myConfigurable == null) {
                try {
                    String name;
                    String string = name = wrapper.myEp.instanceClass != null ? wrapper.myEp.instanceClass : wrapper.myEp.implementationClass;
                    if (!type.isAssignableFrom(Class.forName(name, false, wrapper.myEp.getLoaderForClass()))) {
                        return null;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            configurable = wrapper.getConfigurable();
        }
        return type.isInstance(configurable) ? (T)type.cast(configurable) : null;
    }

    private ConfigurableWrapper(@NotNull ConfigurableEP ep, @Nullable UnnamedConfigurable configurable) {
        if (ep == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ep", "com/intellij/openapi/options/ex/ConfigurableWrapper", "<init>"));
        }
        this.myEp = ep;
        this.myConfigurable = configurable;
    }

    public UnnamedConfigurable getConfigurable() {
        if (this.myConfigurable == null) {
            this.myConfigurable = this.myEp.createConfigurable();
            if (this.myConfigurable == null) {
                LOG.error("Can't instantiate configurable for " + this.myEp);
            }
        }
        return this.myConfigurable;
    }

    @Nls
    public String getDisplayName() {
        UnnamedConfigurable configurable;
        if (this.myEp.displayName == null && this.myEp.key == null && (configurable = this.getConfigurable()) instanceof Configurable) {
            return ((Configurable)configurable).getDisplayName();
        }
        return this.myEp.getDisplayName();
    }

    public String getInstanceClass() {
        return this.myEp.instanceClass;
    }

    public String getProviderClass() {
        return this.myEp.providerClass;
    }

    @Nullable
    public String getHelpTopic() {
        UnnamedConfigurable configurable = this.getConfigurable();
        return configurable instanceof Configurable ? ((Configurable)configurable).getHelpTopic() : null;
    }

    @Nullable
    public JComponent createComponent() {
        return this.getConfigurable().createComponent();
    }

    public boolean isModified() {
        return this.getConfigurable().isModified();
    }

    public void apply() throws ConfigurationException {
        this.getConfigurable().apply();
    }

    public void reset() {
        this.getConfigurable().reset();
    }

    public void disposeUIResources() {
        this.getConfigurable().disposeUIResources();
    }

    @NotNull
    public String getId() {
        if (this.myEp.id != null) {
            String string = this.myEp.id;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/ex/ConfigurableWrapper", "getId"));
            }
            return string;
        }
        UnnamedConfigurable configurable = this.getConfigurable();
        if (configurable instanceof SearchableConfigurable) {
            String string = ((SearchableConfigurable)configurable).getId();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/ex/ConfigurableWrapper", "getId"));
            }
            return string;
        }
        String string = this.myEp.instanceClass != null ? this.myEp.instanceClass : this.myEp.providerClass;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/ex/ConfigurableWrapper", "getId"));
        }
        return string;
    }

    @NotNull
    public ConfigurableEP getExtensionPoint() {
        ConfigurableEP configurableEP = this.myEp;
        if (configurableEP == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/ex/ConfigurableWrapper", "getExtensionPoint"));
        }
        return configurableEP;
    }

    public String getParentId() {
        return this.myEp.parentId;
    }

    public ConfigurableWrapper addChild(Configurable configurable) {
        return new CompositeWrapper(this.myEp, null, new Configurable[]{configurable});
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Nullable
    public Runnable enableSearch(String option) {
        UnnamedConfigurable configurable = this.getConfigurable();
        return configurable instanceof SearchableConfigurable ? ((SearchableConfigurable)configurable).enableSearch(option) : null;
    }

    private static class CompositeWrapper
    extends ConfigurableWrapper
    implements Configurable.Composite {
        private Configurable[] myKids;

        private CompositeWrapper(@NotNull ConfigurableEP ep, @Nullable UnnamedConfigurable configurable, Configurable ... kids) {
            ExtensionPoint childrenEP;
            Object[] extensions;
            if (ep == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ep", "com/intellij/openapi/options/ex/ConfigurableWrapper$CompositeWrapper", "<init>"));
            }
            super(ep, configurable);
            if (ep.dynamic) {
                kids = ((Configurable.Composite)this.getConfigurable()).getConfigurables();
            } else if (ep.children != null) {
                kids = (Configurable[])ContainerUtil.mapNotNull((Object[])ep.getChildren(), (Function)new NullableFunction<ConfigurableEP, ConfigurableWrapper>(){

                    public ConfigurableWrapper fun(ConfigurableEP ep) {
                        return ep.isAvailable() ? (ConfigurableWrapper)ConfigurableWrapper.wrapConfigurable(ep) : null;
                    }
                }, (Object[])EMPTY_ARRAY);
            }
            if (ep.childrenEPName != null && (extensions = (childrenEP = Extensions.getArea((AreaInstance)ep.getProject()).getExtensionPoint(ep.childrenEPName)).getExtensions()).length > 0) {
                if (extensions[0] instanceof ConfigurableEP) {
                    Object[] children = (Configurable[])ContainerUtil.mapNotNull((Object[])((ConfigurableEP[])extensions), (Function)CONFIGURABLE_FUNCTION, (Object[])new Configurable[0]);
                    kids = (Configurable[])ArrayUtil.mergeArrays((Object[])kids, (Object[])children);
                } else {
                    kids = (Configurable[])ArrayUtil.mergeArrays((Object[])kids, (Object[])((Configurable.Composite)this.getConfigurable()).getConfigurables());
                }
            }
            this.myKids = kids;
        }

        public Configurable[] getConfigurables() {
            return this.myKids;
        }

        @Override
        public ConfigurableWrapper addChild(Configurable configurable) {
            this.myKids = (Configurable[])ArrayUtil.append((Object[])this.myKids, (Object)configurable);
            return this;
        }
    }
}

