/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.ex;

import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.Kernel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;

public class GlassPanel
extends JComponent {
    private final Set<JComponent> myLightComponents = new HashSet<JComponent>();
    private final JComponent myPanel;
    private static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);

    public GlassPanel(JComponent containingPanel) {
        this.myPanel = containingPanel;
        this.setVisible(false);
    }

    @Override
    public void paintComponent(Graphics g) {
        this.paintSpotlights(g);
    }

    protected void paintSpotlights(Graphics g) {
        this.paintSpotlight(g, this);
    }

    public void paintSpotlight(Graphics g, JComponent surfaceComponent) {
        Dimension size = surfaceComponent.getSize();
        if (this.myLightComponents.size() > 0) {
            int width = size.width - 1;
            int height = size.height - 1;
            Rectangle2D.Double screen = new Rectangle2D.Double(0.0, 0.0, width, height);
            Rectangle visibleRect = this.myPanel.getVisibleRect();
            Point leftPoint = SwingUtilities.convertPoint(this.myPanel, new Point(visibleRect.x, visibleRect.y), surfaceComponent);
            Area innerPanel = new Area(new Rectangle2D.Double(leftPoint.x, leftPoint.y, visibleRect.width, visibleRect.height));
            Area mask = new Area(screen);
            ArrayList<JComponent> components = new ArrayList<JComponent>();
            for (JComponent lightComponent : this.myLightComponents) {
                Area labelForArea;
                JLabel label;
                Component labelFor;
                Area area = this.getComponentArea(surfaceComponent, lightComponent, 1);
                if (area == null) continue;
                components.add(lightComponent);
                if (lightComponent instanceof JLabel && (labelFor = (label = (JLabel)lightComponent).getLabelFor()) instanceof JComponent && (labelForArea = this.getComponentArea(surfaceComponent, (JComponent)labelFor, 1)) != null) {
                    components.add((JComponent)labelFor);
                    area.add(labelForArea);
                }
                area.intersect(innerPanel);
                mask.subtract(area);
            }
            Graphics2D g2 = (Graphics2D)g;
            Color shieldColor = new Color(0.0f, 0.0f, 0.0f, 0.2f);
            Color boundsColor = Color.gray;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(shieldColor);
            g2.fill(mask);
            g2.setColor(ColorUtil.toAlpha((Color)Color.orange, (int)25));
            GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g2);
            for (int i = 2; i > 0; --i) {
                g2.setStroke(new BasicStroke(i));
                Area arrr = new Area();
                for (JComponent component : components) {
                    Area area = this.getComponentArea(surfaceComponent, component, i - 1);
                    if (area == null) continue;
                    arrr.add(area);
                }
                g2.draw(arrr);
            }
            config.restore();
        }
    }

    @Nullable
    private Area getComponentArea(JComponent surfaceComponent, JComponent lightComponent, int offset) {
        int hInset;
        if (!lightComponent.isShowing()) {
            return null;
        }
        Point panelPoint = SwingUtilities.convertPoint(lightComponent, new Point(0, 0), surfaceComponent);
        int x = panelPoint.x;
        int y = panelPoint.y;
        Insets insetsToIgnore = lightComponent.getInsets();
        boolean isWithBorder = Boolean.TRUE.equals(lightComponent.getClientProperty("searchUtil.highlightWithBorder"));
        boolean isLabelFromTabbedPane = Boolean.TRUE.equals(lightComponent.getClientProperty("JBTabbedPane.labelFromTabbedPane"));
        if (insetsToIgnore == null || UIUtil.isUnderAquaLookAndFeel() && lightComponent instanceof JButton || isWithBorder) {
            insetsToIgnore = EMPTY_INSETS;
        }
        int n = isWithBorder ? 7 : (hInset = isLabelFromTabbedPane ? 20 : 7);
        int vInset = isWithBorder ? 1 : (isLabelFromTabbedPane ? 10 : 5);
        int xCoord = x - (hInset += offset) + insetsToIgnore.left;
        int yCoord = y - (vInset += offset) + insetsToIgnore.top;
        int width = lightComponent.getWidth() + hInset * 2 - insetsToIgnore.right - insetsToIgnore.left;
        int height = lightComponent.getHeight() + vInset * 2 - insetsToIgnore.top - insetsToIgnore.bottom;
        return new Area(new RoundRectangle2D.Double(xCoord, yCoord, width, height, Math.min(height, 30), Math.min(height, 30)));
    }

    protected static Kernel getBlurKernel(int blurSize) {
        if (blurSize <= 0) {
            return null;
        }
        int size = blurSize * blurSize;
        float coeff = 1.0f / (float)size;
        float[] kernelData = new float[size];
        for (int i = 0; i < size; ++i) {
            kernelData[i] = coeff;
        }
        return new Kernel(blurSize, blurSize, kernelData);
    }

    public static double getArea(JComponent component) {
        return Math.PI * (double)component.getWidth() * (double)component.getHeight() / 4.0;
    }

    public void addSpotlight(JComponent component) {
        this.myLightComponents.add(component);
        this.setVisible(true);
    }

    public void removeSpotlight(JComponent component) {
        this.myLightComponents.remove(component);
    }

    public void clear() {
        this.myLightComponents.clear();
        this.setVisible(false);
    }
}

