/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ui;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsBalloonProblemNotifier
implements Runnable {
    public static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.toolWindowGroup((String)"Common Version Control Messages", (String)ChangesViewContentManager.TOOLWINDOW_ID);
    private final Project myProject;
    private final String myMessage;
    private final MessageType myMessageType;
    private final boolean myShowOverChangesView;
    @Nullable
    private final NamedRunnable[] myNotificationListener;

    public VcsBalloonProblemNotifier(@NotNull Project project, @NotNull String message, MessageType messageType) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/ui/VcsBalloonProblemNotifier", "<init>"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/openapi/vcs/ui/VcsBalloonProblemNotifier", "<init>"));
        }
        this(project, message, messageType, true, null);
    }

    public VcsBalloonProblemNotifier(@NotNull Project project, @NotNull String message, MessageType messageType, boolean showOverChangesView, @Nullable NamedRunnable[] notificationListener) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/ui/VcsBalloonProblemNotifier", "<init>"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/openapi/vcs/ui/VcsBalloonProblemNotifier", "<init>"));
        }
        this.myProject = project;
        this.myMessage = message;
        this.myMessageType = messageType;
        this.myShowOverChangesView = showOverChangesView;
        this.myNotificationListener = notificationListener;
    }

    public static void showOverChangesView(@NotNull Project project, @NotNull String message, MessageType type, NamedRunnable ... notificationListener) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/ui/VcsBalloonProblemNotifier", "showOverChangesView"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/openapi/vcs/ui/VcsBalloonProblemNotifier", "showOverChangesView"));
        }
        VcsBalloonProblemNotifier.show(project, message, type, true, notificationListener);
    }

    public static void showOverVersionControlView(@NotNull Project project, @NotNull String message, MessageType type) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/ui/VcsBalloonProblemNotifier", "showOverVersionControlView"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/openapi/vcs/ui/VcsBalloonProblemNotifier", "showOverVersionControlView"));
        }
        VcsBalloonProblemNotifier.show(project, message, type, false, null);
    }

    private static void show(final Project project, final String message, final MessageType type, final boolean showOverChangesView, final @Nullable NamedRunnable[] notificationListener) {
        Application application = ApplicationManager.getApplication();
        if (application.isHeadlessEnvironment()) {
            return;
        }
        Runnable showErrorAction = new Runnable(){

            @Override
            public void run() {
                new VcsBalloonProblemNotifier(project, message, type, showOverChangesView, notificationListener).run();
            }
        };
        if (application.isDispatchThread()) {
            showErrorAction.run();
        } else {
            application.invokeLater(showErrorAction);
        }
    }

    @Override
    public void run() {
        Notification notification;
        if (this.myNotificationListener != null && this.myNotificationListener.length > 0) {
            NotificationType type = this.myMessageType.toNotificationType();
            StringBuilder sb = new StringBuilder(this.myMessage);
            for (NamedRunnable runnable : this.myNotificationListener) {
                String name = runnable.toString();
                sb.append("<br/><a href=\"").append(name).append("\">").append(name).append("</a>");
            }
            notification = NOTIFICATION_GROUP.createNotification(type.name(), sb.toString(), this.myMessageType.toNotificationType(), new NotificationListener(){

                public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                    if (notification == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/openapi/vcs/ui/VcsBalloonProblemNotifier$2", "hyperlinkUpdate"));
                    }
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vcs/ui/VcsBalloonProblemNotifier$2", "hyperlinkUpdate"));
                    }
                    if (HyperlinkEvent.EventType.ACTIVATED.equals(event.getEventType())) {
                        if (VcsBalloonProblemNotifier.this.myNotificationListener.length == 1) {
                            VcsBalloonProblemNotifier.this.myNotificationListener[0].run();
                        } else {
                            String description = event.getDescription();
                            if (description != null) {
                                for (NamedRunnable runnable : VcsBalloonProblemNotifier.this.myNotificationListener) {
                                    if (!description.equals(runnable.toString())) continue;
                                    runnable.run();
                                    break;
                                }
                            }
                        }
                        notification.expire();
                    }
                }
            });
        } else {
            notification = NOTIFICATION_GROUP.createNotification(this.myMessage, this.myMessageType);
        }
        notification.notify(this.myProject.isDefault() ? null : this.myProject);
    }
}

