/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocationNameFieldsBinding {
    private boolean myModifyingLocation = false;
    private boolean myModifyingProjectName = false;
    private boolean myExternalModify = false;
    private String myBaseDir;
    private String mySuggestedProjectName;

    public LocationNameFieldsBinding(@Nullable Project project, final TextFieldWithBrowseButton locationTextField, final JTextField nameTextField, String baseDir, String browseFolderTitle) {
        this.myBaseDir = baseDir;
        File suggestedProjectDirectory = FileUtil.findSequentNonexistentFile((File)new File(baseDir), (String)"untitled", (String)"");
        locationTextField.setText(suggestedProjectDirectory.toString());
        nameTextField.setDocument(new NameFieldDocument(nameTextField, locationTextField));
        this.mySuggestedProjectName = suggestedProjectDirectory.getName();
        nameTextField.setText(this.mySuggestedProjectName);
        nameTextField.selectAll();
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        ComponentWithBrowseButton.BrowseFolderActionListener<JTextField> listener = new ComponentWithBrowseButton.BrowseFolderActionListener<JTextField>(browseFolderTitle, "", (ComponentWithBrowseButton)locationTextField, project, descriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT){

            protected void onFileChosen(@NotNull VirtualFile chosenFile) {
                if (chosenFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chosenFile", "com/intellij/platform/LocationNameFieldsBinding$1", "onFileChosen"));
                }
                LocationNameFieldsBinding.this.myBaseDir = chosenFile.getPath();
                if (LocationNameFieldsBinding.this.isProjectNameChanged(nameTextField.getText()) && !nameTextField.getText().equals(chosenFile.getName())) {
                    LocationNameFieldsBinding.this.myExternalModify = true;
                    locationTextField.setText(new File(chosenFile.getPath(), nameTextField.getText()).toString());
                    LocationNameFieldsBinding.this.myExternalModify = false;
                } else {
                    LocationNameFieldsBinding.this.myExternalModify = true;
                    locationTextField.setText(chosenFile.getPath());
                    nameTextField.setText(chosenFile.getName());
                    LocationNameFieldsBinding.this.myExternalModify = false;
                }
            }
        };
        locationTextField.addActionListener((ActionListener)listener);
        locationTextField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                int ind;
                if (LocationNameFieldsBinding.this.myExternalModify) {
                    return;
                }
                LocationNameFieldsBinding.this.myModifyingLocation = true;
                String path = locationTextField.getText().trim();
                if (path.endsWith(File.separator)) {
                    path = path.substring(0, path.length() - File.separator.length());
                }
                if ((ind = path.lastIndexOf(File.separator)) != -1) {
                    String projectName = path.substring(ind + 1, path.length());
                    if (!nameTextField.getText().trim().isEmpty()) {
                        LocationNameFieldsBinding.this.myBaseDir = path.substring(0, ind);
                    }
                    if (!projectName.equals(nameTextField.getText()) && !LocationNameFieldsBinding.this.myModifyingProjectName) {
                        nameTextField.setText(projectName);
                    }
                }
                LocationNameFieldsBinding.this.myModifyingLocation = false;
            }
        });
    }

    private boolean isProjectNameChanged(@NotNull String currentName) {
        if (currentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentName", "com/intellij/platform/LocationNameFieldsBinding", "isProjectNameChanged"));
        }
        return !currentName.equals(this.mySuggestedProjectName);
    }

    private class NameFieldDocument
    extends PlainDocument {
        public NameFieldDocument(final JTextField projectNameTextField, final TextFieldWithBrowseButton locationField) {
            this.addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    if (!LocationNameFieldsBinding.this.myModifyingLocation && !LocationNameFieldsBinding.this.myExternalModify) {
                        LocationNameFieldsBinding.this.myModifyingProjectName = true;
                        File f = new File(LocationNameFieldsBinding.this.myBaseDir);
                        locationField.setText(new File(f, projectNameTextField.getText()).getPath());
                    }
                }
            });
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            boolean ok = true;
            for (int idx = 0; idx < str.length() && ok; ++idx) {
                char ch = str.charAt(idx);
                ok = ch != File.separatorChar && ch != '\\' && ch != '/' && ch != '|' && ch != ':';
            }
            if (ok) {
                super.insertString(offs, str, a);
            }
        }
    }
}

