/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui;

import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.util.Comparing;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProfileManagerImpl;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.profile.codeInspection.ui.InspectionToolsConfigurable;
import com.intellij.profile.codeInspection.ui.SingleInspectionProfilePanel;
import java.util.Arrays;

public class ProjectInspectionToolsConfigurable
extends InspectionToolsConfigurable {
    private static final Logger LOG = Logger.getInstance((String)("#" + ProjectInspectionToolsConfigurable.class.getName()));

    public ProjectInspectionToolsConfigurable(InspectionProfileManager profileManager, InspectionProjectProfileManager projectProfileManager) {
        super(projectProfileManager, profileManager);
    }

    @Override
    protected InspectionProfileImpl getCurrentProfile() {
        return (InspectionProfileImpl)this.myProjectProfileManager.getProjectProfileImpl();
    }

    @Override
    public void apply() throws ConfigurationException {
        super.apply();
        InspectionProfileImpl selectedObject = this.getSelectedObject();
        LOG.assertTrue(selectedObject != null);
        String profileName = selectedObject.getName();
        SingleInspectionProfilePanel selectedPanel = this.getSelectedPanel();
        LOG.assertTrue(selectedPanel != null, (Object)("selected profile: " + profileName + " panels: " + Arrays.toString(this.getKnownNames().toArray())));
        if (selectedPanel.isProfileShared()) {
            this.myProjectProfileManager.setProjectProfile(profileName);
        } else {
            this.myProfileManager.setRootProfile(profileName);
            this.myProjectProfileManager.setProjectProfile(null);
        }
        InspectionProfileManagerImpl.onProfilesChanged();
    }

    @Override
    public boolean isModified() {
        InspectionProfileImpl selectedObject = this.getSelectedObject();
        if (selectedObject != null && !Comparing.strEqual((String)this.getCurrentProfile().getName(), (String)selectedObject.getName())) {
            return true;
        }
        return super.isModified();
    }
}

