/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.typeMigration.TypeMigrationLabeler;
import com.intellij.refactoring.typeMigration.TypeMigrationRules;
import com.intellij.refactoring.typeMigration.TypeMigrationViewDescriptor;
import com.intellij.refactoring.typeMigration.ui.FailedConversionsDialog;
import com.intellij.refactoring.typeMigration.ui.MigrationPanel;
import com.intellij.refactoring.typeMigration.usageInfo.TypeMigrationUsageInfo;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.ui.content.Content;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class TypeMigrationProcessor
extends BaseRefactoringProcessor {
    private PsiElement[] myRoot;
    private final TypeMigrationRules myRules;
    private TypeMigrationLabeler myLabeler;

    public TypeMigrationProcessor(Project project, PsiElement root, TypeMigrationRules rules) {
        this(project, new PsiElement[]{root}, rules);
    }

    public TypeMigrationProcessor(Project project, PsiElement[] roots, TypeMigrationRules rules) {
        super(project);
        this.myRoot = roots;
        this.myRules = rules;
    }

    public static void runHighlightingTypeMigration(final Project project, final Editor editor, TypeMigrationRules rules, PsiElement root) {
        final PsiFile containingFile = root.getContainingFile();
        TypeMigrationProcessor processor = new TypeMigrationProcessor(project, root, rules){

            @Override
            public void performRefactoring(final UsageInfo[] usages) {
                super.performRefactoring(usages);
                if (editor != null) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ArrayList<Object> result = new ArrayList<Object>();
                            for (UsageInfo usage : usages) {
                                PsiElement element = usage.getElement();
                                if (element == null || containingFile != element.getContainingFile()) continue;
                                if (element instanceof PsiMethod) {
                                    result.add(((PsiMethod)element).getReturnTypeElement());
                                    continue;
                                }
                                if (element instanceof PsiVariable) {
                                    result.add(((PsiVariable)element).getTypeElement());
                                    continue;
                                }
                                result.add(element);
                            }
                            RefactoringUtil.highlightAllOccurrences(project, PsiUtilCore.toPsiElementArray(result), editor);
                        }
                    });
                }
            }
        };
        processor.run();
    }

    @Override
    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo[] usages) {
        TypeMigrationViewDescriptor typeMigrationViewDescriptor = new TypeMigrationViewDescriptor(this.myRoot[0]);
        if (typeMigrationViewDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/typeMigration/TypeMigrationProcessor", "createUsageViewDescriptor"));
        }
        return typeMigrationViewDescriptor;
    }

    @Override
    protected boolean preprocessUsages(Ref<UsageInfo[]> refUsages) {
        if (this.hasFailedConversions()) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw new RuntimeException(StringUtil.join((String[])this.myLabeler.getFailedConversionsReport(), (String)"\n"));
            }
            FailedConversionsDialog dialog = new FailedConversionsDialog(this.myLabeler.getFailedConversionsReport(), this.myProject);
            dialog.show();
            if (!dialog.isOK()) {
                int exitCode = dialog.getExitCode();
                this.prepareSuccessful();
                if (exitCode == 2) {
                    this.previewRefactoring((UsageInfo[])refUsages.get());
                }
                return false;
            }
        }
        this.prepareSuccessful();
        return true;
    }

    public boolean hasFailedConversions() {
        return this.myLabeler.hasFailedConversions();
    }

    @Override
    protected void previewRefactoring(UsageInfo[] usages) {
        MigrationPanel panel = new MigrationPanel(this.myRoot[0], this.myLabeler, this.myProject, this.isPreviewUsages());
        String text = this.myRoot[0] instanceof PsiField ? "field '" + ((PsiField)this.myRoot[0]).getName() + "'" : (this.myRoot[0] instanceof PsiParameter ? "parameter '" + ((PsiParameter)this.myRoot[0]).getName() + "'" : (this.myRoot[0] instanceof PsiLocalVariable ? "variable '" + ((PsiLocalVariable)this.myRoot[0]).getName() + "'" : (this.myRoot[0] instanceof PsiMethod ? "method '" + ((PsiMethod)this.myRoot[0]).getName() + "' return" : Arrays.toString(this.myRoot))));
        String fromType = ((PsiType)ObjectUtils.assertNotNull((Object)TypeMigrationLabeler.getElementType(this.myRoot[0]))).getPresentableText();
        String toType = this.myRules.getMigrationRootType().getPresentableText();
        String name = "Migrate Type of " + text + " from '" + fromType + "' to '" + toType + "'";
        Content content = UsageViewManager.getInstance((Project)this.myProject).addContent(name, false, (JComponent)panel, true, true);
        panel.setContent(content);
        ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(ToolWindowId.FIND).activate(null);
    }

    @Override
    @NotNull
    public UsageInfo[] findUsages() {
        UsageInfo[] usageInfoArray;
        this.myLabeler = new TypeMigrationLabeler(this.myRules);
        try {
            usageInfoArray = this.myLabeler.getMigratedUsages(!this.isPreviewUsages(), this.myRoot);
        }
        catch (TypeMigrationLabeler.MigrateException e) {
            this.setPreviewUsages(true);
            UsageInfo[] usageInfoArray2 = this.myLabeler.getMigratedUsages(false, this.myRoot);
            if (usageInfoArray2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/typeMigration/TypeMigrationProcessor", "findUsages"));
            }
            return usageInfoArray2;
        }
        if (usageInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/typeMigration/TypeMigrationProcessor", "findUsages"));
        }
        return usageInfoArray;
    }

    @Override
    protected void refreshElements(PsiElement[] elements) {
        this.myRoot = elements;
    }

    @Override
    public void performRefactoring(UsageInfo[] usages) {
        for (PsiElement element : this.myRoot) {
            if (!(element instanceof PsiVariable)) continue;
            ((PsiVariable)element).normalizeDeclaration();
        }
        TypeMigrationProcessor.change(this.myLabeler, usages);
    }

    public static void change(TypeMigrationLabeler labeler, UsageInfo[] usages) {
        ArrayList<UsageInfo> nonCodeUsages = new ArrayList<UsageInfo>();
        for (UsageInfo usage : usages) {
            if (((TypeMigrationUsageInfo)usage).isExcluded()) continue;
            PsiElement element = usage.getElement();
            if (element instanceof PsiVariable || element instanceof PsiMember || element instanceof PsiExpression || element instanceof PsiReferenceParameterList) {
                labeler.change((TypeMigrationUsageInfo)usage);
                continue;
            }
            nonCodeUsages.add(usage);
        }
        for (UsageInfo usageInfo : nonCodeUsages) {
            Object target;
            PsiReference reference;
            PsiElement element = usageInfo.getElement();
            if (element == null || (reference = element.getReference()) == null || !((target = labeler.getConversion(element)) instanceof PsiMember)) continue;
            try {
                reference.bindToElement((PsiElement)target);
            }
            catch (IncorrectOperationException ignored) {}
        }
    }

    public TypeMigrationLabeler getLabeler() {
        return this.myLabeler;
    }

    @Override
    protected String getCommandName() {
        return "TypeMigration";
    }
}

