/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher;

import com.intellij.dupLocator.iterators.ArrayBackedNodeIterator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.structuralsearch.impl.matcher.GlobalMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SubstitutionHandler;
import java.util.ArrayList;

public class XmlMatchingVisitor
extends XmlElementVisitor {
    private final GlobalMatchingVisitor myMatchingVisitor;
    private final boolean myCaseSensitive;

    public XmlMatchingVisitor(GlobalMatchingVisitor matchingVisitor) {
        this.myMatchingVisitor = matchingVisitor;
        this.myCaseSensitive = this.myMatchingVisitor.getMatchContext().getOptions().isCaseSensitiveMatch();
    }

    public void visitElement(PsiElement element) {
        this.myMatchingVisitor.setResult(element.textMatches(element));
    }

    public void visitXmlAttribute(XmlAttribute attribute) {
        XmlAttribute another = (XmlAttribute)this.myMatchingVisitor.getElement();
        boolean isTypedVar = this.myMatchingVisitor.getMatchContext().getPattern().isTypedVar(attribute.getName());
        this.myMatchingVisitor.setResult(this.matches(attribute.getName(), another.getName()) || isTypedVar);
        if (this.myMatchingVisitor.getResult()) {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)attribute.getValueElement(), (PsiElement)another.getValueElement()));
        }
        if (this.myMatchingVisitor.getResult() && isTypedVar) {
            MatchingHandler handler = this.myMatchingVisitor.getMatchContext().getPattern().getHandler(attribute.getName());
            this.myMatchingVisitor.setResult(((SubstitutionHandler)handler).handle((PsiElement)another, this.myMatchingVisitor.getMatchContext()));
        }
    }

    public void visitXmlAttributeValue(XmlAttributeValue value) {
        MatchingHandler handler;
        XmlAttributeValue another = (XmlAttributeValue)this.myMatchingVisitor.getElement();
        String text = value.getValue();
        boolean isTypedVar = this.myMatchingVisitor.getMatchContext().getPattern().isTypedVar(text);
        if (isTypedVar && (handler = this.myMatchingVisitor.getMatchContext().getPattern().getHandler(text)) instanceof SubstitutionHandler) {
            String text2 = another.getText();
            int offset = text2.length() > 0 && (text2.charAt(0) == '\"' || text2.charAt(0) == '\'') ? 1 : 0;
            this.myMatchingVisitor.setResult(((SubstitutionHandler)handler).handle((PsiElement)another, offset, text2.length() - offset, this.myMatchingVisitor.getMatchContext()));
        } else {
            this.myMatchingVisitor.setResult(this.matches(text, another.getValue()));
        }
    }

    public void visitXmlTag(XmlTag tag) {
        XmlTagChild[] contentChildren;
        XmlTag another = (XmlTag)this.myMatchingVisitor.getElement();
        boolean isTypedVar = this.myMatchingVisitor.getMatchContext().getPattern().isTypedVar(tag.getName());
        this.myMatchingVisitor.setResult((this.matches(tag.getName(), another.getName()) || isTypedVar) && this.myMatchingVisitor.matchInAnyOrder((PsiElement[])tag.getAttributes(), (PsiElement[])another.getAttributes()));
        if (this.myMatchingVisitor.getResult() && (contentChildren = tag.getValue().getChildren()).length > 0) {
            XmlTagChild[] patternNodes = contentChildren;
            XmlTagChild[] matchedNodes = another.getValue().getChildren();
            if (contentChildren.length != 1) {
                patternNodes = XmlMatchingVisitor.expandXmlTexts((PsiElement[])patternNodes);
                matchedNodes = XmlMatchingVisitor.expandXmlTexts((PsiElement[])matchedNodes);
            }
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSequentially(new ArrayBackedNodeIterator((PsiElement[])patternNodes), new ArrayBackedNodeIterator((PsiElement[])matchedNodes)));
        }
        if (this.myMatchingVisitor.getResult() && isTypedVar) {
            MatchingHandler handler = this.myMatchingVisitor.getMatchContext().getPattern().getHandler(tag.getName());
            this.myMatchingVisitor.setResult(((SubstitutionHandler)handler).handle((PsiElement)another, this.myMatchingVisitor.getMatchContext()));
        }
    }

    private static PsiElement[] expandXmlTexts(PsiElement[] children) {
        ArrayList<PsiElement> result = new ArrayList<PsiElement>(children.length);
        for (PsiElement c : children) {
            if (c instanceof XmlText) {
                for (PsiElement p : c.getChildren()) {
                    if (p instanceof PsiWhiteSpace) continue;
                    result.add(p);
                }
                continue;
            }
            if (c instanceof PsiWhiteSpace) continue;
            result.add(c);
        }
        return PsiUtilCore.toPsiElementArray(result);
    }

    public void visitXmlText(XmlText text) {
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSequentially(text.getFirstChild(), this.myMatchingVisitor.getElement().getFirstChild()));
    }

    public void visitXmlToken(XmlToken token) {
        if (token.getTokenType() == XmlTokenType.XML_DATA_CHARACTERS) {
            String text = token.getText();
            boolean isTypedVar = this.myMatchingVisitor.getMatchContext().getPattern().isTypedVar(text);
            if (isTypedVar) {
                this.myMatchingVisitor.setResult(this.myMatchingVisitor.handleTypedElement((PsiElement)token, this.myMatchingVisitor.getElement()));
            } else {
                this.myMatchingVisitor.setResult(this.matches(text, this.myMatchingVisitor.getElement().getText()));
            }
        }
    }

    private boolean matches(String a, String b) {
        return this.myCaseSensitive ? a.equals(b) : a.equalsIgnoreCase(b);
    }
}

