/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.win;

import com.intellij.ide.RecentProjectsManagerBase;
import com.intellij.ide.ReopenProjectAction;
import com.intellij.idea.StartupUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.wm.impl.SystemDock;
import com.intellij.ui.win.RecentTasks;
import com.intellij.ui.win.SocketControlHelper;
import com.intellij.ui.win.Task;
import java.io.File;

public class WinDockDelegate
implements SystemDock.Delegate {
    private static final String javaExe = System.getProperty("java.home") + File.separatorChar + "bin" + File.separatorChar + "javaw.exe";
    private static final String argsToExecute = " -classpath \"" + PathManager.getJarPathForClass(SocketControlHelper.class) + "\" com.intellij.ui.win.SocketControlHelper " + StartupUtil.getAcquiredPort() + " ";
    private static boolean initialized = false;
    private static final SystemDock.Delegate instance = new WinDockDelegate();

    private WinDockDelegate() {
    }

    @Override
    public void updateRecentProjectsMenu() {
        AnAction[] recentProjectActions = RecentProjectsManagerBase.getInstance().getRecentProjectsActions(false);
        RecentTasks.clear();
        Task[] tasks = new Task[recentProjectActions.length];
        for (int i = 0; i < recentProjectActions.length; ++i) {
            ReopenProjectAction rpa = (ReopenProjectAction)recentProjectActions[i];
            tasks[i] = new Task(javaExe, argsToExecute + RecentTasks.getShortenPath(rpa.getProjectPath()), rpa.getTemplatePresentation().getText());
        }
        RecentTasks.addTasks(tasks);
    }

    public static synchronized SystemDock.Delegate getInstance() {
        if (!initialized) {
            initialized = true;
        }
        return instance;
    }
}

